/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import net.yacy.cora.document.feed.Hit;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSReader;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.ImageEntry;
import org.apache.commons.lang3.StringUtils;

public class rssParser
extends AbstractParser
implements Parser {
    private static final ConcurrentLog LOG = new ConcurrentLog(rssParser.class.getSimpleName());

    public rssParser() {
        super("RSS Parser");
        this.SUPPORTED_EXTENSIONS.add("rss");
        this.SUPPORTED_EXTENSIONS.add("xml");
        this.SUPPORTED_MIME_TYPES.add("xml");
        this.SUPPORTED_MIME_TYPES.add("text/rss");
        this.SUPPORTED_MIME_TYPES.add("text/xml");
        this.SUPPORTED_MIME_TYPES.add("application/rss+xml");
        this.SUPPORTED_MIME_TYPES.add("application/atom+xml");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        RSSReader rssReader;
        try {
            rssReader = new RSSReader(10000, source);
        }
        catch (IOException e) {
            throw new Parser.Failure("Load error:" + e.getMessage(), location, e);
        }
        return this.rssFeedToDocuments(charset, rssReader.getFeed());
    }

    private Document[] rssFeedToDocuments(String charset, RSSFeed feed2) {
        ArrayList<Document> docs = new ArrayList<Document>();
        for (Hit item : feed2) {
            String linkUrlString = item.getLink();
            DigestURL itemuri = null;
            if (StringUtils.isNotBlank((CharSequence)linkUrlString)) {
                try {
                    itemuri = new DigestURL(item.getLink());
                }
                catch (MalformedURLException e) {
                    LOG.warn("Malformed feed item link url : " + linkUrlString);
                }
            }
            HashSet<String> languages = new HashSet<String>();
            languages.add(item.getLanguage());
            HashSet<AnchorURL> anchors = null;
            String enclosureUrlString = item.getEnclosure();
            if (StringUtils.isNotBlank((CharSequence)enclosureUrlString)) {
                try {
                    AnchorURL enclosureUrl = new AnchorURL(enclosureUrlString);
                    if (itemuri == null) {
                        itemuri = enclosureUrl;
                    } else {
                        anchors = new HashSet<AnchorURL>();
                        anchors.add(enclosureUrl);
                    }
                }
                catch (MalformedURLException e) {
                    LOG.warn("Malformed feed item enclosure url : " + enclosureUrlString);
                }
            }
            if (itemuri == null) continue;
            Document doc = new Document(itemuri, TextParser.mimeOf(itemuri), charset, this, languages, item.getSubject(), rssParser.singleList(item.getTitle()), item.getAuthor(), item.getCopyright(), null, item.getDescriptions(), item.getLon(), item.getLat(), null, anchors, null, new LinkedHashMap<DigestURL, ImageEntry>(), false, item.getPubDate());
            docs.add(doc);
        }
        Document[] da = new Document[docs.size()];
        docs.toArray(da);
        return da;
    }

    @Override
    public boolean isParseWithLimitsSupported() {
        return true;
    }

    @Override
    public Document[] parseWithLimits(DigestURL url, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source, int maxLinks, long maxBytes, Date lastModified) throws Parser.Failure, InterruptedException, UnsupportedOperationException {
        RSSReader rssReader;
        try {
            rssReader = new RSSReader(maxLinks, maxBytes, source);
        }
        catch (IOException e) {
            throw new Parser.Failure("Load error:" + e.getMessage(), url, e);
        }
        Document[] documents = this.rssFeedToDocuments(charset, rssReader.getFeed());
        if (documents != null && documents.length > 0 && (rssReader.isMaxBytesExceeded() || rssReader.getFeed().isMaxSizeExceeded())) {
            documents[documents.length - 1].setPartiallyParsed(true);
        }
        return documents;
    }
}

