/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.xml.ODContentHandler;
import net.yacy.document.parser.xml.ODMetaHandler;
import net.yacy.document.parser.xml.OOXMLSharedStringsHandler;
import net.yacy.document.parser.xml.OOXMLSpreeadsheetHandler;
import net.yacy.kelondro.io.CharBuffer;
import net.yacy.kelondro.util.FileUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ooxmlParser
extends AbstractParser
implements Parser {
    private static final ThreadLocal<SAXParser> tlSax = new ThreadLocal();

    public ooxmlParser() {
        super("Open Office XML Document Parser");
        this.SUPPORTED_EXTENSIONS.add("docx");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.SUPPORTED_EXTENSIONS.add("dotx");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        this.SUPPORTED_EXTENSIONS.add("potx");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.presentationml.template");
        this.SUPPORTED_EXTENSIONS.add("ppsx");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        this.SUPPORTED_EXTENSIONS.add("pptx");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        this.SUPPORTED_EXTENSIONS.add("xlsx");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.SUPPORTED_EXTENSIONS.add("xltx");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.spreadsheetml.template");
    }

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document[] parse(DigestURL location, String mimeType, String charset, File dest) throws Parser.Failure, InterruptedException {
        CharBuffer writer = null;
        try {
            String docDescription = null;
            String docKeywordStr = null;
            String docShortTitle = null;
            String docLongTitle = null;
            String docAuthor = null;
            String docLanguage = null;
            Date docModified = null;
            ZipFile zipFile = new ZipFile(dest);
            Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
            HashSet<AnchorURL> detectedURLs = new HashSet<AnchorURL>();
            ZipEntry sharedStringsEntry = zipFile.getEntry("xl/sharedStrings.xml");
            ArrayList<String> sharedStrings = new ArrayList<String>();
            if (sharedStringsEntry != null) {
                try (InputStream zipFileEntryStream = zipFile.getInputStream(sharedStringsEntry);){
                    SAXParser saxParser = ooxmlParser.getParser();
                    saxParser.parse(zipFileEntryStream, (DefaultHandler)new OOXMLSharedStringsHandler(sharedStrings));
                }
            }
            while (zipEnum.hasMoreElements()) {
                SAXParser saxParser;
                InputStream zipFileEntryStream;
                ZipEntry zipEntry = zipEnum.nextElement();
                String entryName = zipEntry.getName();
                if (entryName.startsWith("xl/worksheets/sheet")) {
                    if (writer == null) {
                        writer = new CharBuffer(0xC800000, (int)zipEntry.getSize());
                    }
                    zipFileEntryStream = zipFile.getInputStream(zipEntry);
                    try {
                        saxParser = ooxmlParser.getParser();
                        saxParser.parse(zipFileEntryStream, (DefaultHandler)new OOXMLSpreeadsheetHandler(sharedStrings, writer, detectedURLs));
                        continue;
                    }
                    finally {
                        zipFileEntryStream.close();
                        continue;
                    }
                }
                if (entryName.equals("word/document.xml") || entryName.startsWith("ppt/slides/slide")) {
                    if (writer == null) {
                        writer = new CharBuffer(0xC800000, (int)zipEntry.getSize());
                    }
                    zipFileEntryStream = zipFile.getInputStream(zipEntry);
                    try {
                        saxParser = ooxmlParser.getParser();
                        saxParser.parse(zipFileEntryStream, (DefaultHandler)new ODContentHandler(writer));
                        continue;
                    }
                    finally {
                        zipFileEntryStream.close();
                        continue;
                    }
                }
                if (!entryName.equals("docProps/core.xml")) continue;
                zipFileEntryStream = zipFile.getInputStream(zipEntry);
                saxParser = ooxmlParser.getParser();
                ODMetaHandler metaData = new ODMetaHandler();
                saxParser.parse(zipFileEntryStream, (DefaultHandler)metaData);
                docDescription = metaData.getDescription();
                docKeywordStr = metaData.getKeyword();
                docShortTitle = metaData.getTitle();
                docLongTitle = metaData.getSubject();
                docAuthor = metaData.getCreator();
                docLanguage = metaData.getLanguage();
                docModified = metaData.getLastModified();
            }
            zipFile.close();
            HashSet<String> languages = new HashSet<String>(1);
            if (docLanguage != null && docLanguage.isEmpty()) {
                languages.add(docLanguage);
            }
            if ((docLongTitle == null || docLongTitle.isEmpty()) && docShortTitle != null) {
                docLongTitle = docShortTitle;
            }
            String[] docKeywords = null;
            if (docKeywordStr != null) {
                docKeywords = docKeywordStr.split(" |,");
            }
            Document[] docs = null;
            byte[] contentBytes = writer == null ? null : UTF8.getBytes(writer.toString());
            ArrayList<String> descriptions = new ArrayList<String>();
            if (docDescription != null && docDescription.length() > 0) {
                descriptions.add(docDescription);
            }
            docs = new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, languages, docKeywords, ooxmlParser.singleList(docLongTitle), docAuthor, null, null, descriptions, 0.0, 0.0, contentBytes, detectedURLs, null, null, false, docModified)};
            return docs;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ConcurrentLog.logException(e);
            throw new Parser.Failure("Unexpected error while parsing odt file. " + e.getMessage(), location);
        }
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        File dest = null;
        try {
            dest = File.createTempFile("OpenDocument", ".odt");
            FileUtils.copy(source, dest);
            Document[] documentArray = this.parse(location, mimeType, charset, dest);
            return documentArray;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            throw new Parser.Failure("Unexpected error while parsing odt file. " + e.getMessage(), location);
        }
        finally {
            if (dest != null) {
                FileUtils.deletedelete(dest);
            }
        }
    }
}

