/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class mmParser
extends AbstractParser
implements Parser {
    private static final ThreadLocal<SAXParser> tlSax = new ThreadLocal();

    public mmParser() {
        super("FreeMind Parser");
        this.SUPPORTED_EXTENSIONS.add("mm");
        this.SUPPORTED_MIME_TYPES.add("application/freemind");
        this.SUPPORTED_MIME_TYPES.add("application/x-freemind");
    }

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        StringBuilder sb = new StringBuilder();
        String rootElementText = "";
        byte[] content = new byte[]{};
        try {
            SAXParser saxParser = mmParser.getParser();
            FreeMindHandler freeMindHandler = new FreeMindHandler();
            saxParser.parse(source, (DefaultHandler)freeMindHandler);
            List<String> nodeTextList = freeMindHandler.getNodeText();
            rootElementText = nodeTextList.isEmpty() ? "" : nodeTextList.get(0);
            for (String nodeText : nodeTextList) {
                sb.append(nodeText);
                sb.append(". ");
            }
            content = UTF8.getBytes(sb.toString());
        }
        catch (SAXException ex) {
            AbstractParser.log.warn(ex.getMessage());
        }
        catch (IOException ex) {
            AbstractParser.log.warn(ex.getMessage());
        }
        return new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, null, null, mmParser.singleList(rootElementText), null, null, null, null, 0.0, 0.0, content, null, null, null, false, new Date())};
    }

    private class FreeMindHandler
    extends DefaultHandler {
        private final List<String> nodeText = new ArrayList<String>();

        private FreeMindHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String textValue;
            if (qName.equals("node") && (textValue = attributes.getValue("TEXT")) != null) {
                this.nodeText.add(textValue);
            }
        }

        protected List<String> getNodeText() {
            return this.nodeText;
        }
    }
}

