/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.html;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.yacy.search.Switchboard;
import org.json.JSONException;
import org.json.JSONObject;

public final class CharacterCoding {
    public static final Pattern ampPattern;
    private static final char AMP_UNICODE;
    private static final String AMP_HTML = "&amp;";
    private static final String SPACE_HTML = "&nbsp;";
    private static final String[] MAPPING4XML;
    private static final String[] MAPPING4HTML;
    private static final Map<String, String> HTML2UNICODE4XML;
    private static final Map<String, String> HTML2UNICODE4HTML;
    private static final Map<Character, String> UNICODE2HTML4XML;
    private static final Map<Character, String> UNICODE2HTML4HTML;

    static void parseJsonEntities(JSONObject entities, Map<String, String> entityToChar) throws JSONException {
        Iterator<String> it = entities.keys();
        while (it.hasNext()) {
            String entity = it.next();
            String c = entities.getJSONObject(entity).getString("characters");
            entityToChar.put(entity, c);
        }
    }

    private CharacterCoding() {
    }

    public static String unicode2xml(String text, boolean amp) {
        return CharacterCoding.unicode2html(text, amp, false);
    }

    public static String unicode2html(String text, boolean amp) {
        return CharacterCoding.unicode2html(text, amp, true);
    }

    private static String unicode2html(String text, boolean amp, boolean html) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(text.length() * 12 / 10);
        int textpos = 0;
        while (textpos < text.length()) {
            char c = text.charAt(textpos);
            if (amp && c == AMP_UNICODE) {
                sb.append(AMP_HTML);
                ++textpos;
                continue;
            }
            String r = UNICODE2HTML4XML.get(Character.valueOf(c));
            if (r != null) {
                sb.append(r);
                ++textpos;
                continue;
            }
            if (html && (r = UNICODE2HTML4HTML.get(Character.valueOf(c))) != null) {
                sb.append(r);
                ++textpos;
                continue;
            }
            sb.append(c);
            ++textpos;
        }
        return sb.toString();
    }

    public static String html2unicode(String text) {
        if (text == null) {
            return null;
        }
        text = ampPattern.matcher(text).replaceAll("&");
        int p = 0;
        StringBuilder sb = new StringBuilder(text.length());
        while (p < text.length()) {
            int pp;
            int p1 = text.indexOf(38, p);
            if (p1 < 0) {
                sb.append(text, p, text.length());
                break;
            }
            sb.append(text, p, p1);
            p = p1;
            if (p >= text.length()) break;
            int q = text.indexOf(59, p);
            if (q < 0) {
                sb.append(text, p, text.length());
                break;
            }
            String s = text.substring(p, q + 1);
            p = q + 1;
            while ((pp = s.indexOf(38, 1)) >= 0) {
                sb.append(s.substring(0, pp));
                s = s.substring(pp);
            }
            if (s.equals(AMP_HTML)) {
                sb.append(AMP_UNICODE);
                continue;
            }
            if (s.equals(SPACE_HTML)) {
                sb.append(" ");
                continue;
            }
            String r = HTML2UNICODE4XML.get(s);
            if (r != null) {
                sb.append(r);
                continue;
            }
            r = HTML2UNICODE4HTML.get(s);
            if (r != null) {
                sb.append(r);
                continue;
            }
            if (s.charAt(1) == '#') {
                if (s.charAt(2) == 'x' || s.charAt(2) == 'X') {
                    try {
                        sb.append(new char[]{(char)Integer.parseInt(s.substring(3, s.length() - 1), 16)});
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                String ucs = s.substring(2, s.length() - 1);
                try {
                    int uc = Integer.parseInt(ucs);
                    sb.append(new char[]{(char)uc});
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String text = "Test-Text mit & um zyklische &uuml; &amp; Ersetzungen auszuschliessen";
        String txet = CharacterCoding.unicode2html("Test-Text mit & um zyklische &uuml; &amp; Ersetzungen auszuschliessen", true);
        System.out.println(txet);
        System.out.println(CharacterCoding.html2unicode(txet));
        if (CharacterCoding.html2unicode(txet).equals("Test-Text mit & um zyklische &uuml; &amp; Ersetzungen auszuschliessen")) {
            System.out.println("correct");
        }
        String text2 = "encodeUnicode2xml: & \" < >";
        System.out.println("encodeUnicode2xml: & \" < >");
        System.out.println(CharacterCoding.unicode2xml("encodeUnicode2xml: & \" < >", true));
        String text3 = "space&nbsp;t&auml;st";
        System.out.println("space&nbsp;t&auml;st");
        System.out.println(CharacterCoding.html2unicode("space&nbsp;t&auml;st"));
    }

    static {
        Character c;
        int i;
        ampPattern = Pattern.compile(Pattern.quote(AMP_HTML));
        AMP_UNICODE = "&".charAt(0);
        MAPPING4XML = new String[]{"\"", "&quot;", "<", "&lt;", ">", "&gt;"};
        MAPPING4HTML = new String[]{"\\", "&#092;", "^", "&#094;", "`", "&#096;", "{", "&#123;", "|", "&#124;", "}", "&#125;", "~", "&#126;", "\u0082", "&#130;", "\u0083", "&#131;", "\u0084", "&#132;", "\u0085", "&#133;", "\u0086", "&#134;", "\u0087", "&#135;", "\u0088", "&#136;", "\u0089", "&#137;", "\u008a", "&#138;", "\u008b", "&#139;", "\u008c", "&#140;", "\u008d", "&#141;", "\u008e", "&#142;", "\u0091", "&#145;", "\u0092", "&#146;", "\u0093", "&#147;", "\u0094", "&#148;", "\u0095", "&#149;", "\u0096", "&#150;", "\u0097", "&#151;", "\u0098", "&#152;", "\u0099", "&#153;", "\u009a", "&#154;", "\u009b", "&#155;", "\u009c", "&#156;", "\u009d", "&#157;", "\u009e", "&#158;", "\u009f", "&#159;", "\u00a1", "&iexcl;", "\u00a2", "&cent;", "\u00a3", "&pound;", "\u00a4", "&curren;", "\u00a5", "&yen;", "\u00a6", "&brvbar;", "\u00a7", "&sect;", "\u00a8", "&uml;", "\u00a9", "&copy;", "\u00aa", "&ordf;", "\u00ab", "&laquo;", "\u00ac", "&not;", "\u00ad", "&shy;", "\u00ae", "&reg;", "\u00af", "&macr;", "\u00b0", "&deg;", "\u00b1", "&plusmn;", "\u00b2", "&sup2;", "\u00b3", "&sup3;", "\u00b4", "&acute;", "\u00b5", "&micro;", "\u00b6", "&para;", "\u00b7", "&middot;", "\u00b8", "&cedil;", "\u00b9", "&sup1;", "\u00ba", "&ordm;", "\u00bb", "&raquo;", "\u00bc", "&frac14;", "\u00bd", "&frac12;", "\u00be", "&frac34;", "\u00bf", "&iquest;", "\u00c0", "&Agrave;", "\u00c1", "&Aacute;", "\u00c2", "&Acirc;", "\u00c3", "&Atilde;", "\u00c4", "&Auml;", "\u00c5", "&Aring;", "\u00c6", "&AElig;", "\u00c7", "&Ccedil;", "\u00c8", "&Egrave;", "\u00c9", "&Eacute;", "\u00ca", "&Ecirc;", "\u00cb", "&Euml;", "\u00cc", "&Igrave;", "\u00cd", "&Iacute;", "\u00ce", "&Icirc;", "\u00cf", "&Iuml;", "\u00d0", "&ETH;", "\u00d1", "&Ntilde;", "\u00d2", "&Ograve;", "\u00d3", "&Oacute;", "\u00d4", "&Ocirc;", "\u00d5", "&Otilde;", "\u00d6", "&Ouml;", "\u00d7", "&times;", "\u00d8", "&Oslash;", "\u00d9", "&Ugrave;", "\u00da", "&Uacute;", "\u00db", "&Ucirc;", "\u00dc", "&Uuml;", "\u00dd", "&Yacute;", "\u00de", "&THORN;", "\u00df", "&szlig;", "\u00e0", "&agrave;", "\u00e1", "&aacute;", "\u00e2", "&acirc;", "\u00e3", "&atilde;", "\u00e4", "&auml;", "\u00e5", "&aring;", "\u00e6", "&aelig;", "\u00e7", "&ccedil;", "\u00e8", "&egrave;", "\u00e9", "&eacute;", "\u00ea", "&ecirc;", "\u00eb", "&euml;", "\u00ec", "&igrave;", "\u00ed", "&iacute;", "\u00ee", "&icirc;", "\u00ef", "&iuml;", "\u00f0", "&eth;", "\u00f1", "&ntilde;", "\u00f2", "&ograve;", "\u00f3", "&oacute;", "\u00f4", "&ocirc;", "\u00f5", "&otilde;", "\u00f6", "&ouml;", "\u00f7", "&divide;", "\u00f8", "&oslash;", "\u00f9", "&ugrave;", "\u00fa", "&uacute;", "\u00fb", "&ucirc;", "\u00fc", "&uuml;", "\u00fd", "&yacute;", "\u00fe", "&thorn;", "\u00ff", "&yuml;"};
        HTML2UNICODE4XML = new HashMap<String, String>();
        HTML2UNICODE4HTML = new HashMap<String, String>();
        UNICODE2HTML4XML = new HashMap<Character, String>(MAPPING4XML.length * 2);
        UNICODE2HTML4HTML = new HashMap<Character, String>(MAPPING4XML.length * 2);
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(Switchboard.getSwitchboard() != null ? Switchboard.getSwitchboard().appPath.getAbsolutePath() : ".", "defaults", "htmlEntities.json"));
            JSONObject json = new JSONObject(new String(encoded, StandardCharsets.UTF_8));
            CharacterCoding.parseJsonEntities(json.getJSONObject("xml"), HTML2UNICODE4XML);
            CharacterCoding.parseJsonEntities(json.getJSONObject("html4"), HTML2UNICODE4HTML);
            CharacterCoding.parseJsonEntities(json.getJSONObject("html5"), HTML2UNICODE4HTML);
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        for (i = 0; i < MAPPING4HTML.length; i += 2) {
            c = Character.valueOf(MAPPING4HTML[i].charAt(0));
            UNICODE2HTML4HTML.put(c, MAPPING4HTML[i + 1]);
        }
        for (i = 0; i < MAPPING4XML.length; i += 2) {
            c = Character.valueOf(MAPPING4XML[i].charAt(0));
            UNICODE2HTML4XML.put(c, MAPPING4XML[i + 1]);
        }
    }
}

