/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.TagValency;
import net.yacy.kelondro.util.FileUtils;
import org.apache.commons.compress.compressors.gzip.GzipUtils;

public class gzipParser
extends AbstractParser
implements Parser {
    private static final int DEFAULT_DEPTH = 999;

    public gzipParser() {
        super("GNU Zip Compressed Archive Parser");
        this.SUPPORTED_EXTENSIONS.add("gz");
        this.SUPPORTED_EXTENSIONS.add("tgz");
        this.SUPPORTED_MIME_TYPES.add("application/x-gzip");
        this.SUPPORTED_MIME_TYPES.add("application/gzip");
        this.SUPPORTED_MIME_TYPES.add("application/x-gunzip");
        this.SUPPORTED_MIME_TYPES.add("application/gzipped");
        this.SUPPORTED_MIME_TYPES.add("application/gzip-compressed");
        this.SUPPORTED_MIME_TYPES.add("gzip/document");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        Document[] documentArray;
        File tempFile = null;
        Document maindoc = null;
        GZIPInputStream zippedContent = null;
        FileOutputStream out = null;
        try {
            zippedContent = new GZIPInputStream(source);
        }
        catch (IOException e) {
            throw new Parser.Failure("Unexpected error while parsing gzip file. " + e.getMessage(), location, new GZIPOpeningStreamException());
        }
        try {
            int read = 0;
            byte[] data = new byte[1024];
            tempFile = File.createTempFile("gunzip", "tmp");
            out = new FileOutputStream(tempFile);
            while ((read = zippedContent.read(data, 0, 1024)) != -1) {
                out.write(data, 0, read);
            }
        }
        catch (Exception e) {
            if (tempFile != null) {
                FileUtils.deletedelete(tempFile);
            }
            throw new Parser.Failure("Unexpected error while parsing gzip file. " + e.getMessage(), location);
        }
        finally {
            if (zippedContent != null) {
                try {
                    zippedContent.close();
                }
                catch (IOException ignored) {
                    log.warn("Could not close gzip input stream");
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new Parser.Failure("Unexpected error while parsing gzip file. " + e.getMessage(), location);
                }
            }
        }
        try {
            maindoc = gzipParser.createMainDocument(location, mimeType, charset, this);
            String contentfilename = GzipUtils.getUncompressedFileName((String)location.getFileName());
            String mime = TextParser.mimeOf(MultiProtocolURL.getFileExtension(contentfilename));
            Document[] docs = TextParser.parseSource(location, mime, null, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, 999, tempFile, null);
            if (docs != null) {
                maindoc.addSubDocuments(docs);
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            throw new Parser.Failure("Unexpected error while parsing gzip file. " + e.getMessage(), location);
        }
        finally {
            if (tempFile != null) {
                FileUtils.deletedelete(tempFile);
            }
        }
        if (maindoc == null) {
            documentArray = null;
        } else {
            Document[] documentArray2 = new Document[1];
            documentArray = documentArray2;
            documentArray2[0] = maindoc;
        }
        return documentArray;
    }

    public static Document createMainDocument(DigestURL location, String mimeType, String charset, gzipParser parser) {
        String filename = location.getFileName();
        Document maindoc = new Document(location, mimeType, charset, parser, null, null, AbstractParser.singleList(filename.isEmpty() ? location.toTokens() : MultiProtocolURL.unescape(filename)), null, null, null, null, 0.0, 0.0, null, null, null, null, false, new Date());
        return maindoc;
    }

    public Document[] parseCompressedInputStream(DigestURL location, String charset, int timezoneOffset, int depth, InputStream compressedInStream, int maxLinks, long maxBytes) throws Parser.Failure {
        String compressedFileName = location.getFileName();
        String contentfilename = GzipUtils.getUncompressedFileName((String)compressedFileName);
        String mime = TextParser.mimeOf(MultiProtocolURL.getFileExtension(contentfilename));
        try {
            String locationPath = location.getPath();
            String contentPath = locationPath.substring(0, locationPath.length() - compressedFileName.length()) + contentfilename;
            DigestURL contentLocation = new DigestURL(location.getProtocol(), location.getHost(), location.getPort(), contentPath);
            return TextParser.parseWithLimits(contentLocation, mime, charset, timezoneOffset, depth, -1L, compressedInStream, maxLinks, maxBytes, null);
        }
        catch (MalformedURLException e) {
            throw new Parser.Failure("Unexpected error while parsing gzip file. " + e.getMessage(), location);
        }
    }

    @Override
    public boolean isParseWithLimitsSupported() {
        return true;
    }

    @Override
    public Document[] parseWithLimits(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source, int maxLinks, long maxBytes, Date lastModified) throws Parser.Failure {
        Document[] documentArray;
        Document maindoc = null;
        GZIPInputStream zippedContent = null;
        try {
            zippedContent = new GZIPInputStream(source);
        }
        catch (IOException e) {
            throw new Parser.Failure("Unexpected error while parsing gzip file. " + e.getMessage(), location, new GZIPOpeningStreamException());
        }
        try {
            maindoc = gzipParser.createMainDocument(location, mimeType, charset, this);
            Document[] docs = this.parseCompressedInputStream(location, charset, timezoneOffset, 999, zippedContent, maxLinks, maxBytes);
            if (docs != null) {
                maindoc.addSubDocuments(docs);
                if (docs.length > 0 && docs[0].isPartiallyParsed()) {
                    maindoc.setPartiallyParsed(true);
                }
            }
        }
        catch (Exception e) {
            throw new Parser.Failure("Unexpected error while parsing gzip file. " + e.getMessage(), location);
        }
        if (maindoc == null) {
            documentArray = null;
        } else {
            Document[] documentArray2 = new Document[1];
            documentArray = documentArray2;
            documentArray2[0] = maindoc;
        }
        return documentArray;
    }

    public class GZIPOpeningStreamException
    extends Exception {
        private static final long serialVersionUID = 2824038185373304636L;

        public GZIPOpeningStreamException() {
        }

        public GZIPOpeningStreamException(String message2) {
            super(message2);
        }
    }
}

