/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.content;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.lod.vocabulary.DublinCore;
import net.yacy.cora.lod.vocabulary.Geo;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.Document;
import net.yacy.document.parser.genericParser;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.common.params.MultiMapSolrParams;

public class DCEntry
extends MultiMapSolrParams {
    private static final long serialVersionUID = -2050291583515701559L;
    private static final Collator insensitiveCollator = Collator.getInstance(Locale.US);
    public static final DCEntry poison;

    public DCEntry() {
        super(new TreeMap((Collator)insensitiveCollator.clone()));
    }

    public DCEntry(DigestURL url, Date date, String title, String author, String body, double lat, double lon) {
        super(new TreeMap((Collator)insensitiveCollator.clone()));
        this.getMap().put(DublinCore.Identifier.getURIref(), new String[]{url.toNormalform(true)});
        this.getMap().put(DublinCore.Date.getURIref(), new String[]{ISO8601Formatter.FORMATTER.format(date)});
        this.getMap().put(DublinCore.Title.getURIref(), new String[]{title});
        this.getMap().put(DublinCore.Creator.getURIref(), new String[]{author});
        this.getMap().put(DublinCore.Description.getURIref(), new String[]{body});
        this.getMap().put(Geo.Lat.getURIref(), new String[]{Double.toString(lat)});
        this.getMap().put(Geo.Long.getURIref(), new String[]{Double.toString(lon)});
    }

    public Date getDate() {
        String d = this.get("docdatetime");
        if (d == null) {
            d = this.get("date");
        }
        if (d == null) {
            d = this.get(DublinCore.Date.getURIref());
        }
        if (d == null) {
            d = this.get("last-modified");
        }
        if (d == null) {
            return null;
        }
        if (d.isEmpty()) {
            return null;
        }
        try {
            Date x = ISO8601Formatter.FORMATTER.parse(d, 0).getTime();
            Date now = new Date();
            return x.after(now) ? now : x;
        }
        catch (ParseException e) {
            ConcurrentLog.logException(e);
            return new Date();
        }
    }

    public DigestURL getIdentifier(boolean useRelationAsAlternative) {
        String u = this.get("url");
        if (u == null) {
            u = this.get("sku");
        }
        if (u == null) {
            String[] urls2 = this.getParams(DublinCore.Identifier.getURIref());
            if (urls2 == null) {
                return useRelationAsAlternative ? this.getRelation() : null;
            }
            if (urls2.length > 0) {
                u = this.bestU(urls2);
            }
        }
        try {
            return new DigestURL(u);
        }
        catch (MalformedURLException e) {
            if (useRelationAsAlternative) {
                DigestURL relation = this.getRelation();
                if (relation != null) {
                    return relation;
                }
                ConcurrentLog.warn("DCEntry", "getIdentifier: url is bad, relation also: " + e.getMessage());
            }
            ConcurrentLog.warn("DCEntry", "getIdentifier: url is bad: " + e.getMessage());
            return null;
        }
    }

    public DigestURL getRelation() {
        String u = this.get(DublinCore.Relation.getURIref());
        if (u == null) {
            return null;
        }
        String[] urls2 = CommonPattern.SEMICOLON.split(u);
        if (urls2.length > 1) {
            u = this.bestU(urls2);
        }
        try {
            return new DigestURL(u);
        }
        catch (MalformedURLException e) {
            ConcurrentLog.warn("DCEntry", "getRelation: url is bad: " + e.getMessage());
            return null;
        }
    }

    private String bestU(String[] urls2) {
        if (urls2.length > 1) {
            for (String uu : urls2) {
                if (!uu.startsWith("http://") || !uu.endsWith(".html") && !uu.endsWith(".htm") && !uu.endsWith(".pdf") && !uu.endsWith(".doc") && !uu.endsWith(".rss") && !uu.endsWith(".xml")) continue;
                return uu;
            }
            for (String uu : urls2) {
                if (!uu.startsWith("http://")) continue;
                return uu;
            }
            for (String uu : urls2) {
                if (!uu.startsWith("https://")) continue;
                return uu;
            }
            for (String uu : urls2) {
                if (!uu.startsWith("ftp://")) continue;
                return uu;
            }
        }
        for (String uu : urls2) {
            if (uu.startsWith("DOI:") || uu.startsWith("doi:")) {
                return "http://dx.doi.org/" + uu;
            }
            if (uu.startsWith("urn:nbn:")) {
                return "http://nbn-resolving.de/" + uu;
            }
            if (!uu.startsWith("urn:ietf:rfc")) continue;
            return "http://wm-urn.org/" + uu;
        }
        return urls2[0];
    }

    public String getLanguage() {
        String l = this.get(DublinCore.Language.getURIref());
        if (l != null && l.length() == 3) {
            if (l.startsWith("ger") || l.startsWith("deu")) {
                l = "de";
            } else if (l.startsWith("eng")) {
                l = "en";
            } else if (l.startsWith("rus")) {
                l = "ru";
            } else if (l.startsWith("jpn")) {
                l = "ja";
            } else if (l.startsWith("ita")) {
                l = "it";
            } else if (l.startsWith("por")) {
                l = "pt";
            } else if (l.startsWith("pol")) {
                l = "pl";
            } else if (l.startsWith("spa")) {
                l = "es";
            } else if (l.startsWith("ukr")) {
                l = "uk";
            } else if (l.startsWith("chi") || l.startsWith("zho")) {
                l = "zh";
            } else if (l.startsWith("fre") || l.startsWith("fra")) {
                l = "fr";
            } else if (l.startsWith("eus") || l.startsWith("baq")) {
                l = "eu";
            } else if (l.startsWith("gre") || l.startsWith("ell")) {
                l = "el";
            } else {
                ULocale loc = new ULocale(l);
                l = loc.getLanguage();
            }
            return l;
        }
        if (l == null) {
            l = this.getIdentifier(true).language();
        }
        if (l == null) {
            return this.get("language");
        }
        return l;
    }

    public String getType() {
        String t = this.get(DublinCore.Type.getURIref());
        if (t == null) {
            return "";
        }
        return t;
    }

    public String getFormat() {
        String t = this.get(DublinCore.Format.getURIref());
        if (t == null) {
            return "";
        }
        return t;
    }

    public String getSource() {
        String t = this.get(DublinCore.Source.getURIref());
        if (t == null) {
            return "";
        }
        return t;
    }

    public String getRights() {
        String t = this.get(DublinCore.Rights.getURIref());
        if (t == null) {
            return "";
        }
        return t;
    }

    public String getTitle() {
        String t = this.get("title");
        if (t == null) {
            t = this.get(DublinCore.Title.getURIref());
        }
        if ((t = DCEntry.stripCDATA(t)) == null) {
            return "";
        }
        return t;
    }

    public String getPublisher() {
        String t = this.get(DublinCore.Publisher.getURIref());
        if ((t = DCEntry.stripCDATA(t)) == null) {
            return "";
        }
        return t;
    }

    public String getCreator() {
        String t = this.get("author");
        if (t == null) {
            t = this.get(DublinCore.Creator.getURIref());
        }
        if ((t = DCEntry.stripCDATA(t)) == null) {
            return "";
        }
        return t;
    }

    public List<String> getDescriptions() {
        String[] t = this.getParams(DublinCore.Description.getURIref());
        ArrayList<String> descriptions = new ArrayList<String>();
        if (t == null) {
            return descriptions;
        }
        for (String s : t) {
            descriptions.add(DCEntry.stripCDATA(s));
        }
        return descriptions;
    }

    public String[] getSubject() {
        String t = this.get("categories");
        if (t != null) {
            t = DCEntry.stripCDATA(t);
            return CommonPattern.SEMICOLON.split(t);
        }
        String[] tx = this.getParams(DublinCore.Subject.getURIref());
        if (tx != null) {
            for (int i = 0; i < tx.length; ++i) {
                tx[i] = DCEntry.stripCDATA(tx[i]);
            }
        }
        return tx;
    }

    public double getLon() {
        String t = this.get(Geo.Long.getURIref());
        if (t == null) {
            t = this.get("geo:lon");
        }
        if ((t = DCEntry.stripCDATA(t)) == null) {
            return 0.0;
        }
        return Double.parseDouble(t);
    }

    public double getLat() {
        String t = this.get(Geo.Lat.getURIref());
        if ((t = DCEntry.stripCDATA(t)) == null) {
            return 0.0;
        }
        return Double.parseDouble(t);
    }

    private static String stripCDATA(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("<![CDATA[")) {
            s = s.substring(9);
        }
        if (s.endsWith("]]")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public Document document() {
        HashSet<String> languages = new HashSet<String>();
        languages.add(this.getLanguage());
        ArrayList<String> t = new ArrayList<String>(1);
        t.add(this.getTitle());
        genericParser parserobj = new genericParser();
        Document document = new Document(this.getIdentifier(true), "text/html", StandardCharsets.UTF_8.name(), parserobj, languages, this.getSubject(), t, this.getCreator(), this.getPublisher(), null, this.getDescriptions(), this.getLon(), this.getLat(), this.get(CollectionSchema.text_t.name(), ""), null, null, null, false, this.getDate());
        document.setScraperObject((Object)this);
        return document;
    }

    public void writeXML(OutputStreamWriter os) throws IOException {
        Document doc = this.document();
        if (doc != null) {
            doc.writeXML(os);
        }
    }

    static {
        insensitiveCollator.setStrength(1);
        insensitiveCollator.setDecomposition(0);
        poison = new DCEntry();
    }
}

