/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data.wiki;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import net.yacy.data.wiki.WikiParser;

abstract class AbstractWikiParser
implements WikiParser {
    AbstractWikiParser() {
    }

    protected abstract String transform(String var1, BufferedReader var2, int var3) throws IOException;

    @Override
    public String transform(String hostport, String content) {
        try {
            return this.transform(hostport, new BufferedReader(new StringReader(content)), content.length());
        }
        catch (IOException e) {
            return "internal error: " + e.getMessage();
        }
    }

    @Override
    public String transform(String hostport, byte[] content) throws UnsupportedEncodingException {
        return this.transform(hostport, content, StandardCharsets.UTF_8.name());
    }

    @Override
    public String transform(String hostport, byte[] content, String encoding) {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        try {
            return this.transform(hostport, new BufferedReader(new InputStreamReader((InputStream)bais, encoding)), content.length);
        }
        catch (IOException e) {
            return "internal error: " + e.getMessage();
        }
    }
}

