/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.data.BookmarksDB;
import net.yacy.data.ListManager;
import net.yacy.kelondro.blob.MapHeap;

public class BookmarkDate {
    private MapHeap datesTable;

    public BookmarkDate(File datesFile) throws IOException {
        this.datesTable = new MapHeap(datesFile, 20, NaturalOrder.naturalOrder, 65536, 500, '_');
    }

    public synchronized void close() {
        this.datesTable.close();
    }

    public Entry getDate(String date) {
        Map<String, String> map;
        try {
            map = this.datesTable.get(UTF8.getBytes(date));
        }
        catch (IOException e) {
            map = null;
        }
        catch (SpaceExceededException e) {
            map = null;
        }
        if (map == null) {
            return new Entry(date);
        }
        return new Entry(date, map);
    }

    public void init(Iterator<BookmarksDB.Bookmark> it) {
        ConcurrentLog.info("BOOKMARKS", "start init dates.db from bookmarks.db...");
        int count = 0;
        while (it.hasNext()) {
            BookmarksDB.Bookmark bookmark = it.next();
            String date = String.valueOf(bookmark.getTimeStamp());
            Entry bmDate = this.getDate(date);
            if (bmDate == null) {
                bmDate = new Entry(date);
            }
            bmDate.add(bookmark.getUrlHash());
            bmDate.setDatesTable();
            ++count;
        }
        ConcurrentLog.info("BOOKMARKS", "finished init " + this.datesTable.size() + " dates using " + count + " bookmarks.");
    }

    public class Entry {
        public static final String URL_HASHES = "urlHashes";
        private final Map<String, String> mem;
        String date;

        public Entry(String mydate) {
            this.date = String.valueOf((mydate == null ? System.currentTimeMillis() : Long.parseLong(mydate)) / 1000L * 1000L);
            this.mem = new HashMap<String, String>();
            this.mem.put(URL_HASHES, "");
        }

        public Entry(String mydate, Map<String, String> map) {
            this.date = String.valueOf(Long.parseLong(mydate) / 1000L * 1000L);
            this.mem = map;
        }

        public Entry(String mydate, List<String> entries2) {
            this.date = String.valueOf(Long.parseLong(mydate) / 1000L * 1000L);
            this.mem = new HashMap<String, String>();
            this.mem.put(URL_HASHES, ListManager.collection2string(entries2));
        }

        public void add(String urlHash) {
            String urlHashes = this.mem.get(URL_HASHES);
            ArrayList<String> list2 = urlHashes != null && !"".equals(urlHashes) ? ListManager.string2arraylist(urlHashes) : new ArrayList();
            if (!list2.contains(urlHash) && urlHash != null && !"".equals(urlHashes)) {
                list2.add(urlHash);
            }
            this.mem.put(URL_HASHES, ListManager.collection2string(list2));
        }

        public void delete(String urlHash) {
            ArrayList<String> list2 = ListManager.string2arraylist(this.mem.get(URL_HASHES));
            if (list2.contains(urlHash)) {
                list2.remove(urlHash);
            }
            this.mem.put(URL_HASHES, ListManager.collection2string(list2));
        }

        public void setDatesTable() {
            if (this.size() > 0) {
                try {
                    BookmarkDate.this.datesTable.insert(UTF8.getBytes(this.getDateString()), this.mem);
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
            } else {
                try {
                    BookmarkDate.this.datesTable.delete(UTF8.getBytes(this.getDateString()));
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }

        public String getDateString() {
            return this.date;
        }

        public List<String> getBookmarkList() {
            return ListManager.string2arraylist(this.mem.get(URL_HASHES));
        }

        public int size() {
            return ListManager.string2arraylist(this.mem.get(URL_HASHES)).size();
        }
    }
}

