/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.data.ListManager;
import net.yacy.data.wiki.WikiBoard;
import net.yacy.kelondro.blob.MapHeap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BlogBoardComments {
    private static final int KEY_LENGTH = 64;
    private static final String DATE_FORMAT = "yyyyMMddHHmmss";
    private static final SimpleDateFormat SIMPLE_DATE_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    private MapHeap database = null;

    public BlogBoardComments(File actpath) throws IOException {
        new File(actpath.getParent()).mkdir();
        this.database = new MapHeap(actpath, 64, NaturalOrder.naturalOrder, 65536, 500, '_');
    }

    public int size() {
        return this.database.size();
    }

    public synchronized void close() {
        this.database.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String dateString(Date date) {
        SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMATTER;
        synchronized (simpleDateFormat) {
            return SIMPLE_DATE_FORMATTER.format(date);
        }
    }

    private static String normalize(String key) {
        return key == null ? "null" : key.trim().toLowerCase();
    }

    public static String webalize(String key) {
        int p;
        if (key == null) {
            return "null";
        }
        Object ret = key.trim().toLowerCase();
        while ((p = ((String)ret).indexOf(32, 0)) >= 0) {
            ret = ((String)ret).substring(0, p) + "%20" + key.substring(p + 1);
        }
        return ret;
    }

    public String guessAuthor(String ip) {
        return WikiBoard.guessAuthor(ip);
    }

    public CommentEntry newEntry(String key, byte[] subject, byte[] author, String ip, Date date, byte[] page) {
        return new CommentEntry(BlogBoardComments.normalize(key), subject, author, ip, date, page);
    }

    public String write(CommentEntry page) {
        try {
            this.database.insert(UTF8.getBytes(page.key), page.record);
            return page.key;
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public CommentEntry read(String key) {
        return this.read(key, this.database);
    }

    private CommentEntry read(String key, MapHeap base) {
        Map<String, String> record;
        String copyOfKey = BlogBoardComments.normalize(key);
        copyOfKey = copyOfKey.substring(0, Math.min(copyOfKey.length(), 64));
        try {
            record = base.get(UTF8.getBytes(copyOfKey));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            record = null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            record = null;
        }
        return record == null ? this.newEntry(copyOfKey, new byte[0], UTF8.getBytes("anonymous"), "localhost", new Date(), new byte[0]) : new CommentEntry(copyOfKey, record);
    }

    public boolean importXML(String input) {
        boolean ret = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(UTF8.getBytes(input)));
            ret = this.parseXMLimport(doc);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    private boolean parseXMLimport(Document doc) {
        if (!"blog".equals(doc.getDocumentElement().getTagName())) {
            return false;
        }
        NodeList items = doc.getDocumentElement().getElementsByTagName("item");
        if (items.getLength() == 0) {
            return false;
        }
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            String key = null;
            String ip = null;
            String StrSubject = null;
            String StrAuthor = null;
            String StrPage = null;
            String StrDate = null;
            Date date = null;
            if (!"item".equals(items.item(i).getNodeName())) continue;
            NodeList currentNodeChildren = items.item(i).getChildNodes();
            int m = currentNodeChildren.getLength();
            for (int j = 0; j < m; ++j) {
                Node currentNode = currentNodeChildren.item(j);
                if ("id".equals(currentNode.getNodeName())) {
                    key = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if ("ip".equals(currentNode.getNodeName())) {
                    ip = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if ("timestamp".equals(currentNode.getNodeName())) {
                    StrDate = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if ("subject".equals(currentNode.getNodeName())) {
                    StrSubject = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if ("author".equals(currentNode.getNodeName())) {
                    StrAuthor = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (!"content".equals(currentNode.getNodeName())) continue;
                StrPage = currentNode.getFirstChild().getNodeValue();
            }
            try {
                date = SIMPLE_DATE_FORMATTER.parse(StrDate);
            }
            catch (ParseException ex) {
                date = new Date();
            }
            if (key == null || ip == null || StrSubject == null || StrAuthor == null || StrPage == null || date == null) {
                return false;
            }
            byte[] subject = UTF8.getBytes(StrSubject);
            byte[] author = UTF8.getBytes(StrAuthor);
            byte[] page = UTF8.getBytes(StrPage);
            this.write(this.newEntry(key, subject, author, ip, date, page));
        }
        return true;
    }

    public void delete(String key) {
        try {
            this.database.delete(UTF8.getBytes(BlogBoardComments.normalize(key)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Iterator<byte[]> keys(boolean up) throws IOException {
        return this.database.keys(up, false);
    }

    static {
        SIMPLE_DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static class CommentEntry {
        String key;
        Map<String, String> record;

        public CommentEntry(String nkey, byte[] subject, byte[] author, String ip, Date date, byte[] page) {
            this.record = new HashMap<String, String>();
            this.setKey(nkey);
            this.setDate(date);
            this.setSubject(subject);
            this.setAuthor(author);
            this.setIp(ip);
            this.setPage(page);
            WikiBoard.setAuthor(ip, UTF8.String(author));
        }

        CommentEntry(String key, Map<String, String> record) {
            this.key = key;
            this.record = record;
            if (this.record.get("comments") == null) {
                this.record.put("comments", ListManager.collection2string(new ArrayList<String>()));
            }
        }

        public String getKey() {
            return this.key;
        }

        private void setKey(String var) {
            this.key = var.substring(0, Math.min(var.length(), 64));
        }

        private void setSubject(byte[] subject) {
            if (subject == null) {
                this.record.put("subject", "");
            } else {
                this.record.put("subject", Base64Order.enhancedCoder.encode(subject));
            }
        }

        public byte[] getSubject() {
            String subject = this.record.get("subject");
            if (subject == null) {
                return new byte[0];
            }
            byte[] subject_bytes = Base64Order.enhancedCoder.decode(subject);
            if (subject_bytes == null) {
                return new byte[0];
            }
            return subject_bytes;
        }

        private void setDate(Date date) {
            if (date == null) {
                date = new Date();
            }
            this.record.put("date", BlogBoardComments.dateString(date));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date getDate() {
            try {
                String date = this.record.get("date");
                if (date == null) {
                    if (ConcurrentLog.isFinest("Blog")) {
                        ConcurrentLog.finest("Blog", "ERROR: date field missing in blogBoard");
                    }
                    return new Date();
                }
                SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMATTER;
                synchronized (simpleDateFormat) {
                    return SIMPLE_DATE_FORMATTER.parse(date);
                }
            }
            catch (ParseException e) {
                return new Date();
            }
        }

        public String getTimestamp() {
            String timestamp = this.record.get("date");
            if (timestamp == null) {
                if (ConcurrentLog.isFinest("Blog")) {
                    ConcurrentLog.finest("Blog", "ERROR: date field missing in blogBoard");
                }
                return BlogBoardComments.dateString(new Date());
            }
            return timestamp;
        }

        private void setAuthor(byte[] author) {
            if (author == null) {
                this.record.put("author", "");
            } else {
                this.record.put("author", Base64Order.enhancedCoder.encode(author));
            }
        }

        public byte[] getAuthor() {
            String author = this.record.get("author");
            if (author == null) {
                return new byte[0];
            }
            byte[] author_byte = Base64Order.enhancedCoder.decode(author);
            if (author_byte == null) {
                return new byte[0];
            }
            return author_byte;
        }

        private void setIp(String ip) {
            if (ip == null || ip.isEmpty()) {
                ip = "";
            }
            this.record.put("ip", ip);
        }

        public String getIp() {
            String ip = this.record.get("ip");
            if (ip == null) {
                return "localhost";
            }
            return ip;
        }

        private void setPage(byte[] page) {
            if (page == null) {
                this.record.put("page", "");
            } else {
                this.record.put("page", Base64Order.enhancedCoder.encode(page));
            }
        }

        public byte[] getPage() {
            String page = this.record.get("page");
            if (page == null) {
                return new byte[0];
            }
            byte[] page_byte = Base64Order.enhancedCoder.decode(page);
            if (page_byte == null) {
                return new byte[0];
            }
            return page_byte;
        }

        public boolean isAllowed() {
            return "true".equals(this.record.get("moderated"));
        }

        public void allow() {
            this.record.put("moderated", "true");
        }
    }
}

