/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.storage.Files;
import net.yacy.cora.util.ConcurrentLog;

public class URLRewriterLibrary {
    private static final ConcurrentLog log = new ConcurrentLog(URLRewriterLibrary.class.getName());
    private final File rewritingPath;
    private final Map<Pattern, String> rewriters = new HashMap<Pattern, String>();

    public URLRewriterLibrary(File rewritingPath) {
        String[] files;
        this.rewritingPath = rewritingPath;
        if (this.rewritingPath == null || !this.rewritingPath.exists()) {
            return;
        }
        for (String f : files = this.rewritingPath.list()) {
            File ff = new File(this.rewritingPath, f);
            try {
                String line;
                BlockingQueue<String> list2 = Files.concurentLineReader(ff);
                while ((line = list2.take()) != "__@POISON__") {
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || line.startsWith("s/")) continue;
                    int p = line.indexOf(61);
                    if (p < 0) {
                        p = line.indexOf(58);
                    }
                    if (p <= 0) continue;
                    try {
                        this.rewriters.put(Pattern.compile(line.substring(0, p)), line.substring(p + 1));
                    }
                    catch (PatternSyntaxException e) {
                        log.warn("bad pattern: " + line.substring(0, p));
                    }
                }
            }
            catch (Throwable e) {
                log.warn("cannot read stemming file " + f, e);
            }
        }
    }

    public URLRewriterLibrary() {
        this.rewritingPath = null;
    }

    public String apply(String s) {
        if (this.rewriters == null || this.rewriters.size() == 0) {
            return s;
        }
        for (Map.Entry<Pattern, String> entry2 : this.rewriters.entrySet()) {
            Matcher m = entry2.getKey().matcher(s);
            if (!m.matches()) continue;
            s = m.replaceAll(entry2.getValue());
        }
        return s;
    }

    public static void main(String[] args) {
        URLRewriterLibrary lib = new URLRewriterLibrary();
        lib.rewriters.put(Pattern.compile("cln_\\d+\\/"), "");
        lib.rewriters.put(Pattern.compile("&amp;administration=[0-9a-z]*"), "");
        lib.rewriters.put(Pattern.compile("\\?administration=[0-9a-z]*"), "");
        lib.rewriters.put(Pattern.compile("\\(X\\([1]\\"), "");
        lib.rewriters.put(Pattern.compile("\\(S\\([0-9a-z]+\\)\\)\\/"), "");
        lib.rewriters.put(Pattern.compile("&amp;ccm=[0-9]*"), "");
        lib.rewriters.put(Pattern.compile("&sid=[0-9]{14}.{8}"), "");
        String s = "";
        Pattern p = Pattern.compile("a");
        s = p.matcher(s).replaceAll("b");
    }
}

