/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.crawler.Balancer;
import net.yacy.crawler.CrawlSwitchboard;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.Latency;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.robots.RobotsTxt;
import net.yacy.kelondro.index.BufferedObjectIndex;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.OnDemandOpenFileIndex;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.table.Table;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.kelondroException;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;

public class HostQueue
implements Balancer {
    private static final ConcurrentLog log = new ConcurrentLog("HostQueue");
    public static final String indexSuffix = ".stack";
    private static final int EcoFSBufferSize = 1000;
    private static final int objectIndexBufferSize = 1000;
    private final File hostPath;
    private final String hostName;
    private final String hostHash;
    private final int port;
    private final boolean exceed134217727;
    private final boolean onDemand;
    private final NavigableMap<Integer, Index> depthStacks;

    public HostQueue(File hostsPath, DigestURL hostUrl, boolean onDemand, boolean exceed134217727) throws MalformedURLException {
        this.onDemand = onDemand;
        this.exceed134217727 = exceed134217727;
        this.hostName = hostUrl.getHost() == null ? "localhost" : hostUrl.getHost();
        this.port = hostUrl.getPort();
        this.hostHash = hostUrl.hosthash();
        if (this.hostName.startsWith("[") && this.hostName.endsWith("]") && this.hostName.contains(":")) {
            File path;
            try {
                path = new File(hostsPath, URLEncoder.encode(this.hostName, StandardCharsets.UTF_8.name()) + "-#" + this.hostHash + "." + this.port);
            }
            catch (UnsupportedEncodingException e) {
                path = new File(hostsPath, this.hostName + "-#" + this.hostHash + "." + this.port);
            }
            this.hostPath = path;
        } else {
            this.hostPath = new File(hostsPath, this.hostName + "-#" + this.hostHash + "." + this.port);
        }
        this.depthStacks = new ConcurrentSkipListMap<Integer, Index>();
        this.init();
    }

    public HostQueue(File hostPath, boolean onDemand, boolean exceed134217727) throws MalformedURLException {
        this.onDemand = onDemand;
        this.exceed134217727 = exceed134217727;
        this.hostPath = hostPath;
        String filename = hostPath.getName();
        int pdot = filename.lastIndexOf(46);
        if (pdot < 0) {
            throw new RuntimeException("hostPath name must contain a dot: " + filename);
        }
        this.port = Integer.parseInt(filename.substring(pdot + 1));
        int p1 = filename.lastIndexOf("-#");
        if (p1 >= 0) {
            String hostNameInFile = filename.substring(0, p1);
            if (hostNameInFile.startsWith("%5B") && hostNameInFile.endsWith("%5D") && hostNameInFile.contains("%3A")) {
                try {
                    hostNameInFile = URLDecoder.decode(hostNameInFile, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException | RuntimeException exception) {
                    // empty catch block
                }
                this.hostName = hostNameInFile;
            } else {
                this.hostName = hostNameInFile;
            }
        } else {
            throw new RuntimeException("hostPath name must contain -# followd by hosthash: " + filename);
        }
        this.hostHash = filename.substring(p1 + 2, pdot);
        this.depthStacks = new ConcurrentSkipListMap<Integer, Index>();
        this.init();
    }

    private final void init() throws MalformedURLException {
        if (!this.hostPath.exists()) {
            this.hostPath.mkdirs();
            if (!this.hostPath.exists()) {
                throw new MalformedURLException("hostPath could not be created: " + this.hostPath.toString());
            }
        }
        int size = this.openAllStacks();
        if (log.isInfo()) {
            log.info("opened HostQueue " + this.hostPath.getAbsolutePath() + " with " + size + " urls.");
        }
    }

    public String getHost() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostHash() {
        return this.hostHash;
    }

    private int openAllStacks() {
        String[] l = this.hostPath.list();
        int c = 0;
        if (l != null) {
            for (String s : l) {
                if (!s.endsWith(indexSuffix)) continue;
                try {
                    int depth = Integer.parseInt(s.substring(0, s.length() - indexSuffix.length()));
                    File stackFile = new File(this.hostPath, s);
                    Index depthStack = this.openStack(stackFile);
                    if (depthStack == null) continue;
                    int sz = depthStack.size();
                    if (sz == 0) {
                        depthStack.close();
                        FileUtils.deletedelete(stackFile);
                        continue;
                    }
                    this.depthStacks.put(depth, depthStack);
                    c += sz;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index getLowestStack() {
        while (this.depthStacks.size() > 0) {
            Map.Entry<Integer, Index> entry2;
            HostQueue hostQueue = this;
            synchronized (hostQueue) {
                entry2 = this.depthStacks.firstEntry();
            }
            if (entry2 == null) {
                return null;
            }
            if (entry2.getValue().size() == 0) {
                entry2.getValue().close();
                FileUtils.deletedelete(this.getFile(entry2.getKey()));
                this.depthStacks.remove(entry2.getKey());
                continue;
            }
            return entry2.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index getStack(int depth) {
        Index depthStack;
        HostQueue hostQueue = this;
        synchronized (hostQueue) {
            depthStack = (Index)this.depthStacks.get(depth);
            if (depthStack != null) {
                return depthStack;
            }
            File f = this.getFile(depth);
            depthStack = this.openStack(f);
            if (depthStack != null) {
                this.depthStacks.put(depth, depthStack);
            }
        }
        return depthStack;
    }

    private File getFile(int depth) {
        Object name = Integer.toString(depth);
        while (((String)name).length() < 4) {
            name = "0" + (String)name;
        }
        File f = new File(this.hostPath, (String)name + indexSuffix);
        return f;
    }

    private Index openStack(File f) {
        for (int i = 0; i < 10; ++i) {
            if (this.onDemand && (!f.exists() || f.length() < 10000L)) {
                try {
                    return new BufferedObjectIndex(new OnDemandOpenFileIndex(f, Request.rowdef, this.exceed134217727), 1000);
                }
                catch (kelondroException e) {
                    ConcurrentLog.logException(e);
                    continue;
                }
            }
            try {
                return new BufferedObjectIndex(new Table(f, Request.rowdef, 1000, 0, false, this.exceed134217727, true), 1000);
            }
            catch (SpaceExceededException e) {
                try {
                    return new BufferedObjectIndex(new Table(f, Request.rowdef, 0, 0, false, this.exceed134217727, true), 1000);
                }
                catch (SpaceExceededException e1) {
                    ConcurrentLog.logException(e1);
                    continue;
                }
            }
            catch (kelondroException e) {
                ConcurrentLog.logException(e);
            }
        }
        return null;
    }

    @Override
    public synchronized void close() {
        log.info("closing HostQueue, closing " + this.depthStacks.size() + " depthStacks for host " + this.hostName);
        for (Map.Entry entry2 : this.depthStacks.entrySet()) {
            int size = ((Index)entry2.getValue()).size();
            ((Index)entry2.getValue()).close();
            if (size != 0) continue;
            FileUtils.deletedelete(this.getFile((Integer)entry2.getKey()));
        }
        this.depthStacks.clear();
        String[] l = this.hostPath.list();
        if ((l == null || l.length == 0) && this.hostPath != null) {
            FileUtils.deletedelete(this.hostPath);
        }
    }

    @Override
    public void clear() {
        Set keys = this.depthStacks.keySet();
        for (Integer key : keys) {
            Index index2 = (Index)this.depthStacks.get(key);
            index2.close();
            FileUtils.deletedelete(this.getFile(key));
            this.depthStacks.remove(key);
        }
        String[] l = this.hostPath.list();
        if (l != null) {
            for (String s : l) {
                FileUtils.deletedelete(new File(this.hostPath, s));
            }
        }
        FileUtils.deletedelete(this.hostPath);
    }

    @Override
    public Request get(byte[] urlhash) throws IOException {
        assert (urlhash != null);
        if (this.depthStacks == null) {
            return null;
        }
        Iterator iterator = this.depthStacks.values().iterator();
        if (iterator.hasNext()) {
            Index depthStack = (Index)iterator.next();
            Row.Entry entry2 = depthStack.get(urlhash, false);
            if (entry2 == null) {
                return null;
            }
            return new Request(entry2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAllByProfileHandle(String profileHandle, long timeout) throws IOException, SpaceExceededException {
        long terminate = timeout == Long.MAX_VALUE ? Long.MAX_VALUE : (timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE);
        int count = 0;
        HostQueue hostQueue = this;
        synchronized (hostQueue) {
            for (Index depthStack : this.depthStacks.values()) {
                RowHandleSet urlHashes = new RowHandleSet(12, (ByteOrder)Base64Order.enhancedCoder, 100);
                CloneableIterator<Row.Entry> i = depthStack.rows();
                while (i.hasNext() && System.currentTimeMillis() < terminate) {
                    Row.Entry rowEntry = (Row.Entry)i.next();
                    Request crawlEntry = new Request(rowEntry);
                    if (crawlEntry.profileHandle().equals(profileHandle)) {
                        urlHashes.put(crawlEntry.url().hash());
                    }
                    if (System.currentTimeMillis() <= terminate) continue;
                }
                for (byte[] urlhash : urlHashes) {
                    depthStack.remove(urlhash);
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public int removeAllByHostHashes(Set<String> hosthashes) {
        for (String h : hosthashes) {
            if (!this.hostHash.equals(h)) continue;
            int s = this.size();
            this.clear();
            return s;
        }
        return 0;
    }

    @Override
    public synchronized int remove(HandleSet urlHashes) throws IOException {
        int removedCounter = 0;
        for (Index depthStack : this.depthStacks.values()) {
            int s = depthStack.size();
            for (byte[] urlhash : urlHashes) {
                Row.Entry entry2 = depthStack.remove(urlhash);
                if (entry2 == null) continue;
                ++removedCounter;
            }
            if (removedCounter == 0) {
                return 0;
            }
            assert (depthStack.size() + removedCounter == s) : "urlFileIndex.size() = " + depthStack.size() + ", s = " + s;
        }
        return removedCounter;
    }

    @Override
    public boolean has(byte[] urlhashb) {
        for (int retry = 0; retry < 3; ++retry) {
            try {
                for (Index depthStack : this.depthStacks.values()) {
                    if (!depthStack.has(urlhashb)) continue;
                    return true;
                }
                return false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        return false;
    }

    @Override
    public int size() {
        int size = 0;
        for (Index depthStack : this.depthStacks.values()) {
            size += depthStack.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Index depthStack : this.depthStacks.values()) {
            if (depthStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String push(Request entry2, CrawlProfile profile2, RobotsTxt robots2) throws IOException, SpaceExceededException {
        assert (entry2 != null);
        byte[] hash = entry2.url().hash();
        if (this.has(hash)) {
            return "double occurrence in urlFileIndex";
        }
        HostQueue hostQueue = this;
        synchronized (hostQueue) {
            int maxPages;
            if (this.has(hash)) {
                return "double occurrence in urlFileIndex";
            }
            if (profile2 != null && (maxPages = profile2.domMaxPages()) != Integer.MAX_VALUE && maxPages > 0) {
                String host = entry2.url().getHost();
                profile2.domInc(host);
            }
            Index depthStack = this.getStack(entry2.depth());
            int s = depthStack.size();
            depthStack.put(entry2.toRow());
            assert (s < depthStack.size()) : "hash = " + ASCII.String(hash) + ", s = " + s + ", size = " + depthStack.size();
            assert (depthStack.has(hash)) : "hash = " + ASCII.String(hash);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request pop(boolean delay, CrawlSwitchboard cs, RobotsTxt robots2) throws IOException {
        long sleeptime = 0L;
        Request crawlEntry = null;
        CrawlProfile profileEntry = null;
        HostQueue hostQueue = this;
        synchronized (hostQueue) {
            while (true) {
                Index depthStack;
                if ((depthStack = this.getLowestStack()) == null) {
                    return null;
                }
                Row.Entry rowEntry = null;
                while (depthStack.size() > 0 && (rowEntry = depthStack.removeOne()) == null) {
                }
                if (rowEntry == null) continue;
                crawlEntry = new Request(rowEntry);
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.CRAWLER, crawlEntry.url())) {
                    if (!log.isFine()) continue;
                    log.fine("URL '" + String.valueOf(crawlEntry.url()) + "' is in blacklist.");
                    continue;
                }
                profileEntry = cs.get(UTF8.getBytes(crawlEntry.profileHandle()));
                if (profileEntry != null) break;
                if (!log.isFine()) continue;
                log.fine("no profile entry for handle " + crawlEntry.profileHandle());
            }
            sleeptime = Latency.getDomainSleepTime(robots2, profileEntry, crawlEntry.url());
        }
        if (crawlEntry == null) {
            return null;
        }
        ClientIdentification.Agent agent = profileEntry == null ? ClientIdentification.yacyInternetCrawlerAgent : profileEntry.getAgent();
        long robotsTime = Latency.getRobotsTime(robots2, crawlEntry.url(), agent);
        Latency.updateAfterSelection(crawlEntry.url(), profileEntry == null ? 0L : robotsTime);
        if (delay && sleeptime > 0L) {
            if (log.isInfo()) {
                log.info("forcing crawl-delay of " + sleeptime + " milliseconds for " + crawlEntry.url().getHost() + ": " + Latency.waitingRemainingExplain(crawlEntry.url(), robots2, agent));
            }
            long loops = sleeptime / 1000L;
            long rest = sleeptime % 1000L;
            if (loops < 3L) {
                rest += 1000L * loops;
                loops = 0L;
            }
            String tname = Thread.currentThread().getName();
            Thread.currentThread().setName("Balancer waiting for " + crawlEntry.url().getHost() + ": " + sleeptime + " milliseconds");
            if (rest > 0L) {
                try {
                    Thread.sleep(rest);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int i = 0;
            while ((long)i < loops) {
                if (log.isInfo()) {
                    log.info("waiting for " + crawlEntry.url().getHost() + ": " + (loops - (long)i) + " seconds remaining...");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            Thread.currentThread().setName(tname);
            Latency.updateAfterSelection(crawlEntry.url(), robotsTime);
        }
        return crawlEntry;
    }

    @Override
    public Iterator<Request> iterator() throws IOException {
        final Iterator depthIterator = this.depthStacks.entrySet().iterator();
        final Iterator[] rowIterator2 = (Iterator[])Array.newInstance(Iterator.class, 1);
        rowIterator2[0] = null;
        return new Iterator<Request>(){
            final /* synthetic */ HostQueue this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return depthIterator.hasNext() || rowIterator2[0] != null && rowIterator2[0].hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Request next() {
                HostQueue hostQueue = this.this$0;
                synchronized (hostQueue) {
                    try {
                        while (rowIterator2[0] == null || !rowIterator2[0].hasNext()) {
                            Map.Entry entry2 = (Map.Entry)depthIterator.next();
                            rowIterator2[0] = ((Index)entry2.getValue()).iterator();
                        }
                        if (!rowIterator2[0].hasNext()) {
                            return null;
                        }
                        Row.Entry rowEntry = (Row.Entry)rowIterator2[0].next();
                        if (rowEntry == null) {
                            return null;
                        }
                        return new Request(rowEntry);
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            }

            @Override
            public void remove() {
                rowIterator2[0].remove();
            }
        };
    }

    @Override
    public Map<String, Integer[]> getDomainStackHosts(RobotsTxt robots2) {
        TreeMap<String, Integer[]> map = new TreeMap<String, Integer[]>();
        int delta = Latency.waitingRemainingGuessed(this.hostName, this.port, this.hostHash, robots2, ClientIdentification.yacyInternetCrawlerAgent);
        map.put(this.hostName, new Integer[]{this.size(), delta});
        return map;
    }

    @Override
    public List<Request> getDomainStackReferences(String host, int maxcount, long maxtime) {
        if (host == null) {
            return new ArrayList<Request>(0);
        }
        if (!this.hostName.equals(host)) {
            return new ArrayList<Request>(0);
        }
        ArrayList<Request> cel = new ArrayList<Request>(maxcount);
        long timeout = maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + maxtime;
        try {
            Iterator<Request> i = this.iterator();
            while (i.hasNext()) {
                Request r = i.next();
                if (r != null) {
                    cel.add(r);
                }
                if (System.currentTimeMillis() <= timeout && cel.size() < maxcount) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cel;
    }

    @Override
    public int getOnDemandLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getExceed134217727() {
        return this.exceed134217727;
    }
}

