/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.CrawlStacker;
import net.yacy.crawler.CrawlStarterFromScraper;
import net.yacy.crawler.IllegalCrawlProfileException;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.document.parser.html.ContentScraper;
import net.yacy.document.parser.html.TransformerWriter;
import net.yacy.kelondro.util.FileUtils;

public class FileCrawlStarterTask
extends Thread {
    private static final ConcurrentLog log = new ConcurrentLog(FileCrawlStarterTask.class.getSimpleName());
    private File crawlingFile;
    private String crawlingFileContent;
    private ContentScraper scraper;
    private CrawlProfile profile;
    private CrawlStacker crawlStacker;
    private final byte[] initiatorHash;

    public FileCrawlStarterTask(File crawlingFile, String crawlingFileContent, ContentScraper scraper, CrawlProfile profile2, CrawlStacker crawlStacker, byte[] initiatorHash) throws IllegalArgumentException, FileNotFoundException, IOException {
        super(FileCrawlStarterTask.class.getSimpleName());
        if (crawlingFile == null && crawlingFileContent == null) {
            throw new IllegalArgumentException("At least one of crawlingFile or crawlingFileContent parameter must not be null");
        }
        if ((crawlingFileContent == null || crawlingFileContent.isEmpty()) && crawlingFile != null) {
            if (!crawlingFile.exists()) {
                throw new FileNotFoundException(crawlingFile.getAbsolutePath() + " does not exists");
            }
            if (!crawlingFile.isFile()) {
                throw new FileNotFoundException(crawlingFile.getAbsolutePath() + " exists but is not a regular file");
            }
            if (!crawlingFile.canRead()) {
                throw new IOException("Can not read : " + crawlingFile.getAbsolutePath());
            }
        }
        this.crawlingFile = crawlingFile;
        this.crawlingFileContent = crawlingFileContent;
        if (scraper == null) {
            throw new IllegalArgumentException("scraper parameter must not be null");
        }
        this.scraper = scraper;
        if (profile2 == null) {
            throw new IllegalArgumentException("profile parameter must not be null");
        }
        this.profile = profile2;
        if (crawlStacker == null) {
            throw new IllegalArgumentException("crawlStacker parameter must not be null");
        }
        this.crawlStacker = crawlStacker;
        if (initiatorHash == null) {
            throw new IllegalArgumentException("initiatorHash parameter must not be null");
        }
        this.initiatorHash = initiatorHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CrawlStarterFromScraper anchorListener = new CrawlStarterFromScraper(this.crawlStacker, this.initiatorHash, this.profile, true);
        this.scraper.registerHtmlFilterEventListener(anchorListener);
        TransformerWriter writer = new TransformerWriter(null, null, this.scraper, false);
        FileInputStream inStream = null;
        try {
            if (this.crawlingFile != null && this.crawlingFile.exists()) {
                inStream = new FileInputStream(this.crawlingFile);
                FileUtils.copy((InputStream)inStream, (Writer)writer);
            } else {
                FileUtils.copy(this.crawlingFileContent, (Writer)writer);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            log.severe("Error parsing the crawlingFile " + this.crawlingFile.getAbsolutePath(), e);
        }
        catch (IllegalCrawlProfileException e) {
            log.info("Parsing crawlingFile " + this.crawlingFile.getAbsolutePath() + " terminated. Crawl profile " + this.profile.handle() + " is no more active.");
        }
        catch (Exception e) {
            log.warn("Error parsing the crawlingFile " + this.crawlingFile.getAbsolutePath(), e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.warn("Could not close crawlingFile : " + this.crawlingFile.getAbsolutePath());
                }
            }
        }
    }
}

