/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.regex.Pattern;

public class StringBuilderComparator
implements Comparator<StringBuilder> {
    public static final StringBuilderComparator CASE_SENSITIVE_ORDER = new StringBuilderComparator(false);
    public static final StringBuilderComparator CASE_INSENSITIVE_ORDER = new StringBuilderComparator(true);
    private final boolean caseInsensitive;

    public StringBuilderComparator(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int compare(StringBuilder sb0, StringBuilder sb1) {
        int l0 = sb0.length();
        int l1 = sb1.length();
        int ml = Math.min(l0, l1);
        for (int i = 0; i < ml; ++i) {
            char c1;
            char c0 = sb0.charAt(i);
            if (c0 == (c1 = sb1.charAt(i)) || this.caseInsensitive && ((c0 = Character.toUpperCase(c0)) == (c1 = Character.toUpperCase(c1)) || (c0 = Character.toLowerCase(c0)) == (c1 = Character.toLowerCase(c1)))) continue;
            return c0 - c1;
        }
        return l0 - l1;
    }

    public boolean equals(StringBuilder sb0, StringBuilder sb1) {
        int l1;
        int l0 = sb0.length();
        if (l0 != (l1 = sb1.length())) {
            return false;
        }
        return this.equals(sb0, sb1, 0, l1);
    }

    public boolean startsWith(StringBuilder sb0, StringBuilder sb1) {
        int l1;
        int l0 = sb0.length();
        if (l0 < (l1 = sb1.length())) {
            return false;
        }
        return this.equals(sb0, sb1, 0, l1);
    }

    public boolean endsWith(StringBuilder sb0, StringBuilder sb1) {
        int l1;
        int l0 = sb0.length();
        if (l0 < (l1 = sb1.length())) {
            return false;
        }
        return this.equals(sb0, sb1, l0 - l1, l1);
    }

    private boolean equals(StringBuilder sb0, StringBuilder sb1, int start, int l) {
        for (int i = start; i < l; ++i) {
            char c1;
            char c0 = sb0.charAt(i);
            if (c0 == (c1 = sb1.charAt(i)) || this.caseInsensitive && ((c0 = Character.toUpperCase(c0)) == (c1 = Character.toUpperCase(c1)) || (c0 = Character.toLowerCase(c0)) == (c1 = Character.toLowerCase(c1)))) continue;
            return false;
        }
        return true;
    }

    public int indexOf(StringBuilder sb, char ch) {
        int max = sb.length();
        for (int i = 0; i < max; ++i) {
            if (sb.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(StringBuilder sb, int off, char ch) {
        int max = sb.length();
        for (int i = off; i < max; ++i) {
            if (sb.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public StringBuilder[] split(StringBuilder sb, char c) {
        int resultSize;
        int next = 0;
        int off = 0;
        ArrayList<String> list2 = new ArrayList<String>();
        while ((next = this.indexOf(sb, off, c)) != -1) {
            list2.add(sb.substring(off, next));
            off = next + 1;
        }
        if (off == 0) {
            return new StringBuilder[]{sb};
        }
        list2.add(sb.substring(off, sb.length()));
        for (resultSize = list2.size(); resultSize > 0 && ((String)list2.get(resultSize - 1)).isEmpty(); --resultSize) {
        }
        StringBuilder[] result = new StringBuilder[resultSize];
        for (int i = 0; i < resultSize; ++i) {
            result[i] = new StringBuilder((String)list2.get(i));
        }
        return result;
    }

    public static StringBuilder[] split(StringBuilder sb, Pattern pattern) {
        String[] p = pattern.split(sb);
        StringBuilder[] h = new StringBuilder[p.length];
        for (int i = 0; i < p.length; ++i) {
            h[i] = new StringBuilder(p[i]);
        }
        return h;
    }

    public static void main(String[] args) {
        StringBuilder[] t;
        StringBuilder s = new StringBuilder("ene mene mu");
        for (StringBuilder u : t = CASE_INSENSITIVE_ORDER.split(s, ' ')) {
            System.out.println(u.toString());
        }
    }
}

