/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZIPReader
extends AbstractMap<String, ZipEntry>
implements Map<String, ZipEntry>,
Iterable<Map.Entry<String, ZipEntry>> {
    private final Set<String> filenames;
    private final ZipFile zipFile;

    public ZIPReader(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("ZIPWriter can only be used for existing files");
        }
        this.zipFile = new ZipFile(file);
        this.filenames = new HashSet<String>();
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry z = e.nextElement();
            this.filenames.add(z.getName());
        }
    }

    @Override
    public Iterator<Map.Entry<String, ZipEntry>> iterator() {
        final Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        return new Iterator<Map.Entry<String, ZipEntry>>(){
            final /* synthetic */ ZIPReader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public Map.Entry<String, ZipEntry> next() {
                ZipEntry z = (ZipEntry)e.nextElement();
                return new AbstractMap.SimpleImmutableEntry<String, ZipEntry>(z.getName(), z);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.zipFile.size();
    }

    @Override
    public boolean isEmpty() {
        return this.zipFile.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.filenames.contains(key);
    }

    @Override
    public ZipEntry get(Object key) {
        return this.zipFile.getEntry((String)key);
    }

    @Override
    public Set<String> keySet() {
        return this.filenames;
    }

    @Override
    public Set<Map.Entry<String, ZipEntry>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipIn, File outDir) throws IOException {
        ZipFile zfile = new ZipFile(zipIn);
        Enumeration<? extends ZipEntry> entries2 = zfile.entries();
        byte[] buffer = new byte[1024];
        while (entries2.hasMoreElements()) {
            ZipEntry entry2 = entries2.nextElement();
            File file = new File(outDir, entry2.getName());
            if (entry2.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            try (InputStream in = zfile.getInputStream(entry2);
                 FileOutputStream out = new FileOutputStream(file);){
                int readCount;
                while ((readCount = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, readCount);
                }
            }
        }
        zfile.close();
    }
}

