/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.storage.ARC;

abstract class SimpleARC<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>>,
ARC<K, V> {
    protected int cacheSize;
    protected Map<K, V> levelA;
    protected Map<K, V> levelB;

    SimpleARC() {
    }

    @Override
    public final synchronized void insert(K s, V v) {
        if (this.levelB.containsKey(s)) {
            this.levelB.put(s, v);
            assert (this.levelB.size() <= this.cacheSize);
        } else {
            this.levelA.put(s, v);
            assert (this.levelA.size() <= this.cacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertIfAbsent(K s, V v) {
        if (this.levelB.containsKey(s)) {
            return;
        }
        if (this.levelA.containsKey(s)) {
            return;
        }
        SimpleARC simpleARC = this;
        synchronized (simpleARC) {
            if (this.levelB.containsKey(s)) {
                return;
            }
            if (this.levelA.containsKey(s)) {
                return;
            }
            this.levelA.put(s, v);
            assert (this.levelA.size() <= this.cacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K s, V v) {
        SimpleARC simpleARC = this;
        synchronized (simpleARC) {
            V o = this.levelB.get(s);
            if (o != null) {
                return o;
            }
            o = this.levelA.get(s);
            if (o != null) {
                return o;
            }
            this.levelA.put(s, v);
            assert (this.levelA.size() <= this.cacheSize);
            return null;
        }
    }

    @Override
    public final synchronized V put(K s, V v) {
        if (this.levelB.containsKey(s)) {
            V r = this.levelB.put(s, v);
            assert (this.levelB.size() <= this.cacheSize);
            return r;
        }
        V r = this.levelA.put(s, v);
        assert (this.levelA.size() <= this.cacheSize);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(Object s) {
        V v = this.levelB.get(s);
        if (v != null) {
            return v;
        }
        SimpleARC simpleARC = this;
        synchronized (simpleARC) {
            v = this.levelB.get(s);
            if (v != null) {
                return v;
            }
            v = this.levelA.remove(s);
            if (v == null) {
                return null;
            }
            this.levelB.put(s, v);
            assert (this.levelB.size() <= this.cacheSize);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<K> getKeys(V value) {
        ArrayList<K> keys = new ArrayList<K>();
        SimpleARC simpleARC = this.levelB;
        synchronized (simpleARC) {
            for (Map.Entry<K, V> entry2 : this.levelB.entrySet()) {
                if (!value.equals(entry2.getValue())) continue;
                keys.add(entry2.getKey());
            }
        }
        simpleARC = this;
        synchronized (simpleARC) {
            for (Map.Entry<K, V> entry2 : this.levelA.entrySet()) {
                if (!value.equals(entry2.getValue())) continue;
                keys.add(entry2.getKey());
            }
        }
        return keys;
    }

    @Override
    public final boolean containsKey(Object s) {
        if (this.levelB.containsKey(s)) {
            return true;
        }
        return this.levelA.containsKey(s);
    }

    @Override
    public final synchronized V remove(Object s) {
        V r = this.levelB.remove(s);
        if (r != null) {
            return r;
        }
        return this.levelA.remove(s);
    }

    @Override
    public final synchronized void clear() {
        this.levelA.clear();
        this.levelB.clear();
    }

    @Override
    public final synchronized int size() {
        return this.levelA.size() + this.levelB.size();
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public final synchronized Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> m = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry2 : this.levelA.entrySet()) {
            m.add(entry2);
        }
        for (Map.Entry<K, V> entry2 : this.levelB.entrySet()) {
            m.add(entry2);
        }
        return m;
    }

    @Override
    public final int hashCode() {
        return this.levelA.hashCode();
    }
}

