/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.yacy.cora.storage.ARC;
import net.yacy.cora.storage.ComparableARC;
import net.yacy.cora.storage.HashARC;

public final class ConcurrentARC<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>>,
ARC<K, V> {
    private final int mask;
    private final ARC<K, V>[] arc;

    public ConcurrentARC(int cacheSize, int partitions) {
        int m;
        for (m = 1; m < partitions; m *= 2) {
        }
        int partitionSize = cacheSize / m;
        if (partitionSize < 4) {
            partitionSize = 4;
        }
        this.arc = (ARC[])Array.newInstance(HashARC.class, m);
        for (int i = 0; i < this.arc.length; ++i) {
            this.arc[i] = new HashARC(partitionSize);
        }
        this.mask = --m;
    }

    public ConcurrentARC(int cacheSize, int partitions, Comparator<? super K> comparator) {
        int m;
        for (m = 1; m < partitions; m *= 2) {
        }
        int partitionSize = cacheSize / m;
        if (partitionSize < 4) {
            partitionSize = 4;
        }
        this.arc = (ARC[])Array.newInstance(ComparableARC.class, m);
        for (int i = 0; i < this.arc.length; ++i) {
            this.arc[i] = new ComparableARC<K, V>(partitionSize, comparator);
        }
        this.mask = --m;
    }

    @Override
    public final void insert(K s, V v) {
        this.arc[this.getPartition(s)].insert(s, v);
    }

    @Override
    public void insertIfAbsent(K s, V v) {
        this.arc[this.getPartition(s)].insertIfAbsent(s, v);
    }

    @Override
    public V putIfAbsent(K s, V v) {
        return this.arc[this.getPartition(s)].putIfAbsent(s, v);
    }

    @Override
    public final V put(K s, V v) {
        return this.arc[this.getPartition(s)].put(s, v);
    }

    @Override
    public final V get(Object s) {
        return this.arc[this.getPartition(s)].get(s);
    }

    @Override
    public Collection<K> getKeys(V value) {
        ArrayList<K> keys = new ArrayList<K>();
        for (ARC<K, V> element : this.arc) {
            keys.addAll(element.getKeys(value));
        }
        return keys;
    }

    @Override
    public final boolean containsKey(Object s) {
        return this.arc[this.getPartition(s)].containsKey(s);
    }

    @Override
    public final V remove(Object s) {
        return this.arc[this.getPartition(s)].remove(s);
    }

    @Override
    public final void clear() {
        for (ARC<K, V> a : this.arc) {
            a.clear();
        }
    }

    @Override
    public final int size() {
        int s = 0;
        for (ARC<K, V> a : this.arc) {
            s += a.size();
        }
        return s;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> m = new HashSet<Map.Entry<K, V>>();
        for (ARC<K, V> a : this.arc) {
            for (Map.Entry<K, V> entry2 : a.entrySet()) {
                m.add(entry2);
            }
        }
        return m;
    }

    @Override
    public int hashCode() {
        return this.arc.hashCode();
    }

    private int getPartition(Object x) {
        if (x instanceof byte[]) {
            int h = 0;
            for (byte c : (byte[])x) {
                h = 31 * h + (c & 0xFF);
            }
            int p = h & this.mask;
            return p;
        }
        int p = x.hashCode() & this.mask;
        return p;
    }

    public static void main(String[] args) {
        Random r = new Random();
        int testsize = 10000;
        ConcurrentARC<Object, Object> a = new ConcurrentARC<Object, Object>(30000, Runtime.getRuntime().availableProcessors());
        HashMap<CallSite, CallSite> b = new HashMap<CallSite, CallSite>();
        for (int i = 0; i < 10000; ++i) {
            String key = "k" + r.nextInt();
            String value = "v" + r.nextInt();
            a.insertIfAbsent(key, value);
            b.put((CallSite)((Object)key), (CallSite)((Object)value));
        }
        int h = 5000;
        for (Map.Entry entry2 : b.entrySet()) {
            a.put((String)entry2.getKey(), (String)entry2.getValue());
            if (h-- > 0) continue;
            break;
        }
        for (Map.Entry entry2 : b.entrySet()) {
            if (!a.containsKey((Object)((String)entry2.getKey()))) {
                System.out.println("missing: " + (String)entry2.getKey());
                continue;
            }
            if (((String)a.get((Object)((String)entry2.getKey()))).equals(entry2.getValue())) continue;
            System.out.println("wrong: a = " + (String)entry2.getKey() + "," + (String)a.get((Object)((String)entry2.getKey())) + "; v = " + (String)entry2.getValue());
        }
        System.out.println("finished test!");
    }
}

