/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol.http;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;

public final class ProxySettings {
    private static final Object PRESENT = new Object();
    private static boolean use = false;
    private static boolean use4ssl = false;
    public static String host = null;
    public static String user = "";
    public static String password = "";
    public static int port = 0;
    public static String[] noProxy = null;
    public static final Map<String, Object> allowProxy = new ConcurrentHashMap<String, Object>();
    public static final Map<String, Object> disallowProxy = new ConcurrentHashMap<String, Object>();
    public static HttpRoutePlanner RoutePlanner = new HttpRoutePlanner(){

        public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
            if (use) {
                Protocol protocol;
                Protocol protocol2 = protocol = "https".equalsIgnoreCase(target.getSchemeName()) ? Protocol.HTTPS : Protocol.HTTP;
                if (ProxySettings.useForHost(target.getHostName(), protocol)) {
                    return new HttpRoute(target, null, ProxySettings.getProxyHost(), protocol == Protocol.HTTPS);
                }
            }
            return new HttpRoute(target);
        }
    };
    public static CredentialsProvider CredsProvider = new CredentialsProvider(){

        public void clear() {
        }

        public Credentials getCredentials(AuthScope scope) {
            if (host != null && host.equals(scope.getHost()) && port == scope.getPort()) {
                return new UsernamePasswordCredentials(user, password);
            }
            return null;
        }

        public void setCredentials(AuthScope arg0, Credentials arg1) {
        }
    };

    public static void setProxyUse4HTTP(boolean use4http0) {
        use = use4http0;
    }

    public static void setProxyUse4HTTPS(boolean use4https0) {
        use4ssl = use4https0;
    }

    public static HttpHost getProxyHost() {
        if (!use) {
            return null;
        }
        return new HttpHost(host, port);
    }

    public static boolean useForHost(String host, Protocol protocol) {
        assert (protocol != null);
        if (!use) {
            return false;
        }
        if (protocol == Protocol.HTTPS && !use4ssl) {
            return false;
        }
        if (allowProxy.containsKey(host)) {
            return true;
        }
        if (disallowProxy.containsKey(host)) {
            return false;
        }
        for (String pattern : noProxy) {
            if (!host.matches(pattern)) continue;
            disallowProxy.put(host, PRESENT);
            return false;
        }
        allowProxy.put(host, PRESENT);
        return true;
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }
}

