/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class ClientIdentification {
    public static final int clientTimeoutInit = 30000;
    public static final int minimumLocalDeltaInit = 10;
    public static final int minimumGlobalDeltaInit = 250;
    private static final String[] browserAgents = new String[]{"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.3", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.3", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.3", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.81 Safari/537.36"};
    private static final Random random = new Random(System.currentTimeMillis());
    private static Map<String, Agent> agents = new ConcurrentHashMap<String, Agent>();
    public static final String yacyInternetCrawlerAgentName = "YaCy Internet (cautious)";
    public static Agent yacyInternetCrawlerAgent = null;
    public static final String yacyIntranetCrawlerAgentName = "YaCy Intranet (greedy)";
    public static Agent yacyIntranetCrawlerAgent = null;
    public static final String googleAgentName = "Googlebot";
    public static final Agent googleAgentAgent = new Agent(new String[]{"Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"}, new String[]{"Googlebot", "Googlebot-Mobile"}, 25, 30000);
    public static final String yacyProxyAgentName = "YaCyProxy";
    public static final Agent yacyProxyAgent = new Agent(new String[]{"yacy - this is a proxy access through YaCy from a browser, not a robot (the yacy bot user agent is 'yacybot')"}, new String[]{"yacy"}, 250, 30000);
    public static final String customAgentName = "Custom Agent";
    public static final String browserAgentName = "Random Browser";
    public static Agent browserAgent;
    public static final String yacySystem;

    public static void generateYaCyBot(String addinfo) {
        String agentString = "yacybot (" + addinfo + "; " + yacySystem + ") https://yacy.net/bot.html";
        yacyInternetCrawlerAgent = new Agent(new String[]{agentString}, new String[]{"yacybot"}, 250, 30000);
        yacyIntranetCrawlerAgent = new Agent(new String[]{agentString}, new String[]{"yacybot"}, 10, 30000);
        agents.put(yacyInternetCrawlerAgentName, yacyInternetCrawlerAgent);
        agents.put(yacyIntranetCrawlerAgentName, yacyIntranetCrawlerAgent);
    }

    public static void generateCustomBot(String name, String string, int minimumdelta, int clienttimeout) {
        if (name.toLowerCase().indexOf("yacy") >= 0 || string.toLowerCase().indexOf("yacy") >= 0) {
            return;
        }
        String agentString = string.replace("$$SYSTEM$$", yacySystem.replace("java", "O"));
        agents.put(customAgentName, new Agent(new String[]{agentString}, new String[]{name}, minimumdelta, clienttimeout));
    }

    public static Agent getAgent(String agentName) {
        if (agentName == null || agentName.length() == 0) {
            return yacyInternetCrawlerAgent;
        }
        Agent agent = agents.get(agentName);
        return agent == null ? yacyInternetCrawlerAgent : agent;
    }

    public static String generateLocation() {
        Object loc = System.getProperty("user.timezone", "nowhere");
        int p = ((String)loc).indexOf(47);
        if (p > 0) {
            loc = ((String)loc).substring(0, p);
        }
        loc = (String)loc + "/" + System.getProperty("user.language", "dumb");
        return loc;
    }

    public static String parseLocationInUserAgent(String userAgent) {
        int firstClosedParenthesis;
        int firstOpenParenthesis = userAgent.indexOf(40);
        int lastSemicolon = userAgent.lastIndexOf(59);
        String location = lastSemicolon < (firstClosedParenthesis = userAgent.indexOf(41)) ? (firstClosedParenthesis > 0 ? userAgent.substring(lastSemicolon + 1, firstClosedParenthesis).trim() : userAgent.substring(lastSemicolon + 1).trim()) : (firstOpenParenthesis < userAgent.length() ? (firstClosedParenthesis > firstOpenParenthesis ? userAgent.substring(firstOpenParenthesis + 1, firstClosedParenthesis).trim() : userAgent.substring(firstOpenParenthesis + 1).trim()) : "");
        return location;
    }

    static {
        yacySystem = System.getProperty("os.arch", "no-os-arch") + " " + System.getProperty("os.name", "no-os-name") + " " + System.getProperty("os.version", "no-os-version") + "; java " + System.getProperty("java.version", "no-java-version") + "; " + ClientIdentification.generateLocation();
        ClientIdentification.generateYaCyBot("new");
        browserAgent = new Agent(browserAgents, new String[0], 250, 30000);
        agents.put(googleAgentName, googleAgentAgent);
        agents.put(browserAgentName, browserAgent);
        agents.put(yacyProxyAgentName, yacyProxyAgent);
    }

    public static class Agent {
        private final String[] userAgents;
        private final String[] robotIDs;
        private final int minimumDelta;
        private final int clientTimeout;

        public Agent(String[] userAgents, String[] robotIDs, int minimumDelta, int clientTimeout) {
            this.userAgents = userAgents;
            this.robotIDs = robotIDs;
            this.minimumDelta = minimumDelta;
            this.clientTimeout = clientTimeout;
        }

        public String userAgent() {
            return this.userAgents.length == 1 ? this.userAgents[0] : this.userAgents[random.nextInt(this.userAgents.length)];
        }

        public boolean isRobot() {
            return this.robotIDs != null && this.robotIDs.length > 0;
        }

        public String[] robotIDs() {
            String[] stringArray;
            if (this.robotIDs == null || this.robotIDs.length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "Mozilla";
            } else {
                stringArray = this.robotIDs;
            }
            return stringArray;
        }

        public int minimumDelta() {
            return this.minimumDelta;
        }

        public int clientTimeout() {
            return this.clientTimeout;
        }
    }
}

