/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.order;

import net.yacy.cora.order.Order;

public abstract class AbstractOrder<A>
implements Order<A> {
    protected A zero = null;
    protected boolean asc = true;

    @Override
    public abstract Order<A> clone();

    @Override
    public A zero() {
        return this.zero;
    }

    @Override
    public void direction(boolean ascending) {
        this.asc = ascending;
    }

    @Override
    public long partition(A key, int forks) {
        long d = Long.MAX_VALUE / (long)forks + (Long.MAX_VALUE % (long)forks + 1L) / (long)forks;
        return this.cardinal(key) / d;
    }

    @Override
    public void rotate(A newzero) {
        this.zero = newzero;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        String thisSig = this.signature();
        String otherSig = other.signature();
        if (thisSig == null || otherSig == null) {
            return false;
        }
        return thisSig.equals(otherSig);
    }

    @Override
    public int hashCode() {
        return this.signature().hashCode();
    }

    public A smallest(A a, A b) {
        return this.compare(a, b) > 0 ? b : a;
    }

    public A largest(A a, A b) {
        return this.compare(a, b) > 0 ? a : b;
    }
}

