/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.federate.solr.responsewriter.SolrjResponseWriter;
import net.yacy.cora.util.CommonPattern;
import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;

public class SnapshotImagesReponseWriter
implements QueryResponseWriter,
SolrjResponseWriter {
    private static final Set<String> DEFAULT_FIELD_LIST = new HashSet<String>();
    private static final int DEFAULT_WIDTH = 256;
    private static final int DEFAULT_HEIGTH = 256;

    public String getContentType(SolrQueryRequest arg0, SolrQueryResponse arg1) {
        return "text/html";
    }

    public void init(NamedList n) {
    }

    private String getRootPath(SolrQueryRequest request) {
        String[] pathParts;
        String servletRequestUri;
        Object requestUriObj;
        Map context;
        String rootPath = "/";
        if (request != null && (context = request.getContext()) != null && (requestUriObj = context.get("requestURI")) instanceof String && (servletRequestUri = (String)requestUriObj).startsWith("/") && (pathParts = CommonPattern.SLASH.split(servletRequestUri = servletRequestUri.substring(1))).length > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < pathParts.length; ++i) {
                sb.append("../");
            }
            rootPath = sb.toString();
        }
        return rootPath;
    }

    private void writeHtmlHead(Writer writer, SolrQueryRequest request) throws IOException {
        String rootPath = this.getRootPath(request);
        writer.write("<!DOCTYPE html>\n");
        writer.write("<html lang=\"en\">");
        writer.write("<head>\n");
        writer.write("<meta charset=\"UTF-8\">");
        writer.write("<title>Documents snapshots</title>\n");
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"" + rootPath + "env/base.css\" />\n");
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" + rootPath + "env/style.css\" />\n");
        writer.write("</head>\n");
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse rsp) throws IOException {
        NamedList values = rsp.getValues();
        assert (values.get("responseHeader") != null);
        assert (values.get("response") != null);
        this.writeHtmlHead(writer, request);
        writer.write("<body id=\"SnapshotImagesReponseWriter\">\n");
        SolrParams originalParams = request.getOriginalParams();
        int width = originalParams != null ? originalParams.getInt("width", 256) : 256;
        int height = originalParams != null ? originalParams.getInt("height", 256) : 256;
        DocList response = ((ResultContext)values.get("response")).getDocList();
        int sz = response.size();
        if (sz > 0) {
            SolrIndexSearcher searcher = request.getSearcher();
            DocIterator iterator = response.iterator();
            while (iterator.hasNext()) {
                int id = iterator.nextDoc();
                Document doc = searcher.doc(id, DEFAULT_FIELD_LIST);
                IndexableField docId = doc.getField(CollectionSchema.id.getSolrFieldName());
                IndexableField docSku = doc.getField(CollectionSchema.sku.getSolrFieldName());
                if (docId == null || docSku == null) continue;
                this.writeDoc(writer, width, height, docId.stringValue(), docSku.stringValue());
            }
        }
        writer.write("</body></html>\n");
    }

    private void writeDoc(Writer writer, int width, int height, String docId, String docUrl) throws IOException {
        if (docId != null && docUrl != null) {
            writer.write("<a href=\"");
            writer.write(docUrl);
            writer.write("\" class=\"forceNoExternalIcon\"><img width=\"");
            writer.write(String.valueOf(width));
            writer.write("\" height=\"");
            writer.write(String.valueOf(height));
            writer.write("\" src=\"/api/snapshot.jpg?urlhash=");
            writer.write(docId);
            writer.write("&amp;width=");
            writer.write(String.valueOf(width));
            writer.write("&amp;height=");
            writer.write(String.valueOf(height));
            writer.write("\" alt=\"");
            writer.write(docUrl);
            writer.write("\"></a>\n");
        }
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, String coreName, QueryResponse rsp) throws IOException {
        this.writeHtmlHead(writer, request);
        writer.write("<body id=\"SnapshotImagesReponseWriter\">\n");
        SolrParams originalParams = request.getOriginalParams();
        int width = originalParams != null ? originalParams.getInt("width", 256) : 256;
        int height = originalParams != null ? originalParams.getInt("height", 256) : 256;
        SolrDocumentList docList = rsp.getResults();
        int sz = docList.size();
        if (sz > 0) {
            for (SolrDocument doc : docList) {
                Object docId = doc.getFieldValue(CollectionSchema.id.getSolrFieldName());
                Object docSku = doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
                if (docId == null || docSku == null) continue;
                this.writeDoc(writer, width, height, docId.toString(), docSku.toString());
            }
        }
        writer.write("</body></html>\n");
    }

    static {
        DEFAULT_FIELD_LIST.add(CollectionSchema.id.getSolrFieldName());
        DEFAULT_FIELD_LIST.add(CollectionSchema.sku.getSolrFieldName());
    }
}

