/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.logic;

import net.yacy.cora.federate.solr.SchemaDeclaration;
import net.yacy.cora.federate.solr.logic.Literal;
import net.yacy.cora.federate.solr.logic.Term;
import org.apache.solr.common.SolrDocument;

public class StringLiteral
extends Literal
implements Term {
    private SchemaDeclaration key;
    private String value;

    public StringLiteral(SchemaDeclaration key, String value) {
        this.key = key;
        this.value = value;
    }

    public Object clone() {
        return new StringLiteral(this.key, this.value);
    }

    @Override
    public boolean equals(Object otherTerm) {
        if (!(otherTerm instanceof StringLiteral)) {
            return false;
        }
        StringLiteral o = (StringLiteral)otherTerm;
        return this.key.equals(o.key) && this.value.equals(o.value);
    }

    public int hashCode() {
        return this.key.hashCode() + this.value.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.getSolrFieldName());
        sb.append(':').append('\"').append(this.value).append('\"');
        return sb.toString();
    }

    @Override
    public boolean matches(SolrDocument doc) {
        Object v = doc.getFieldValue(this.key.getSolrFieldName());
        if (v == null) {
            return false;
        }
        return this.value.equals("[* TO *]") || v.toString().matches(this.value);
    }
}

