/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.logic;

import net.yacy.cora.federate.solr.SchemaDeclaration;
import net.yacy.cora.federate.solr.logic.Literal;
import net.yacy.cora.federate.solr.logic.Term;
import org.apache.solr.common.SolrDocument;

public class LongLiteral
extends Literal
implements Term {
    private SchemaDeclaration key;
    private long value;

    public LongLiteral(SchemaDeclaration key, long value) {
        this.key = key;
        this.value = value;
    }

    public Object clone() {
        return new LongLiteral(this.key, this.value);
    }

    @Override
    public boolean equals(Object otherTerm) {
        if (!(otherTerm instanceof LongLiteral)) {
            return false;
        }
        LongLiteral o = (LongLiteral)otherTerm;
        return this.key.equals(o.key) && this.value == o.value;
    }

    public int hashCode() {
        return this.key.hashCode() + (int)(this.value & Integer.MAX_VALUE);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.getSolrFieldName());
        sb.append(':').append('\"').append(this.value).append('\"');
        return sb.toString();
    }

    @Override
    public boolean matches(SolrDocument doc) {
        Object v = doc.getFieldValue(this.key.getSolrFieldName());
        if (v == null) {
            return false;
        }
        return v.toString().matches(Long.toString(this.value));
    }
}

