/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.instance;

import java.util.Collection;
import java.util.Map;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class ResponseAccumulator {
    final SimpleOrderedMap<Object> fieldsAcc = new SimpleOrderedMap();
    final SimpleOrderedMap<Object> index_countsAcc = new SimpleOrderedMap();
    final SimpleOrderedMap<Object> facet_countsAcc = new SimpleOrderedMap();
    final SimpleOrderedMap<Object> highlightingAcc = new SimpleOrderedMap();
    final SimpleOrderedMap<Object> headerAcc = new SimpleOrderedMap();
    final SolrDocumentList resultsAcc = new SolrDocumentList();

    public void addResponse(NamedList<Object> response) {
        SimpleOrderedMap fields;
        SimpleOrderedMap schema2;
        SimpleOrderedMap index_counts;
        SimpleOrderedMap facet_counts;
        SimpleOrderedMap highlighting;
        SolrDocumentList results;
        Object headerObj = response.get("responseHeader");
        if (headerObj instanceof SimpleOrderedMap) {
            SimpleOrderedMap header = (SimpleOrderedMap)headerObj;
            if (this.headerAcc.size() == 0) {
                for (Object e : header) {
                    this.headerAcc.add((String)e.getKey(), e.getValue());
                }
            }
        }
        if ((results = (SolrDocumentList)response.get("response")) != null) {
            long found = results.size();
            int i = 0;
            while ((long)i < found) {
                this.resultsAcc.add((Object)((SolrDocument)results.get(i)));
                ++i;
            }
            this.resultsAcc.setNumFound(this.resultsAcc.getNumFound() + results.getNumFound());
            this.resultsAcc.setMaxScore(Float.valueOf(Math.max(this.resultsAcc.getMaxScore() == null ? 0.0f : this.resultsAcc.getMaxScore().floatValue(), results.getMaxScore() == null ? 0.0f : results.getMaxScore().floatValue())));
        }
        if ((highlighting = (SimpleOrderedMap)response.get("highlighting")) != null) {
            for (Map.Entry e : highlighting) {
                this.highlightingAcc.add((String)e.getKey(), e.getValue());
            }
        }
        if ((facet_counts = (SimpleOrderedMap)response.get("facet_counts")) != null) {
            for (Object e : facet_counts) {
                this.facet_countsAcc.add((String)e.getKey(), e.getValue());
            }
        }
        if ((index_counts = (SimpleOrderedMap)response.get("index")) != null) {
            for (Map.Entry e : index_counts) {
                this.index_countsAcc.add((String)e.getKey(), e.getValue());
            }
        }
        if ((schema2 = (SimpleOrderedMap)response.get("schema")) != null && (fields = (SimpleOrderedMap)schema2.get("fields")) != null) {
            for (Map.Entry e : fields) {
                this.fieldsAcc.add((String)e.getKey(), e.getValue());
            }
        }
        if ((fields = (SimpleOrderedMap)response.get("fields")) != null) {
            for (Map.Entry e : fields) {
                this.fieldsAcc.add((String)e.getKey(), e.getValue());
            }
        }
    }

    public NamedList<Object> getAccumulatedResponse() {
        NamedList responsesAcc = new NamedList();
        responsesAcc.add("responseHeader", this.headerAcc);
        responsesAcc.add("response", (Object)this.resultsAcc);
        if (this.highlightingAcc != null && this.highlightingAcc.size() > 0) {
            responsesAcc.add("highlighting", this.highlightingAcc);
        }
        if (this.facet_countsAcc != null && this.facet_countsAcc.size() > 0) {
            responsesAcc.add("facet_counts", this.facet_countsAcc);
        }
        if (this.index_countsAcc != null && this.index_countsAcc.size() > 0) {
            responsesAcc.add("index", this.index_countsAcc);
        }
        if (this.fieldsAcc != null && this.fieldsAcc.size() > 0) {
            responsesAcc.add("fields", this.fieldsAcc);
        }
        return responsesAcc;
    }

    public static QueryResponse combineResponses(Collection<QueryResponse> qrl) {
        ResponseAccumulator acc = new ResponseAccumulator();
        for (QueryResponse rsp : qrl) {
            NamedList response = rsp.getResponse();
            acc.addResponse((NamedList<Object>)response);
        }
        QueryResponse rspAcc = new QueryResponse();
        rspAcc.setResponse(acc.getAccumulatedResponse());
        return rspAcc;
    }
}

