/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.connector;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;

public class ShardSelection
implements Iterable<SolrClient> {
    private final Method method;
    private final AtomicLong shardID;
    private final int dimension;
    private final ArrayList<SolrClient> server;

    public ShardSelection(ArrayList<SolrClient> server, Method method) {
        this.server = server;
        this.method = method;
        this.dimension = server.size();
        this.shardID = new AtomicLong(0L);
    }

    public Method getMethod() {
        return this.method;
    }

    private int selectRoundRobin() {
        int rr = (int)(this.shardID.getAndIncrement() % (long)this.dimension);
        if (this.shardID.get() < 0L) {
            this.shardID.set(0L);
        }
        return rr;
    }

    public SolrClient server4write(SolrInputDocument solrdoc) throws IOException {
        if (this.method == Method.MODULO_HOST_MD5) {
            String url;
            String host;
            SolrInputField sif = solrdoc.getField(CollectionSchema.host_s.getSolrFieldName());
            if (sif != null && (host = (String)sif.getValue()) != null && host.length() > 0) {
                return this.server4write(host);
            }
            sif = solrdoc.getField(CollectionSchema.sku.getSolrFieldName());
            if (sif != null && (url = (String)sif.getValue()) != null && url.length() > 0) {
                try {
                    return this.server4write(new URI(url).toURL());
                }
                catch (IOException | URISyntaxException e) {
                    ConcurrentLog.logException(e);
                    return this.server.get(0);
                }
            }
            return this.server.get(0);
        }
        return this.server.get(this.selectRoundRobin());
    }

    public SolrClient server4write(String host) throws IOException {
        if (host == null) {
            throw new IOException("sharding - host url, host empty: " + host);
        }
        if (host.indexOf("://") >= 0) {
            try {
                return this.server4write(new URI(host).toURL());
            }
            catch (URISyntaxException e) {
                throw new IOException("sharding - host url, host invalid: " + host);
            }
        }
        if (this.method == Method.MODULO_HOST_MD5) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.update(ASCII.getBytes(host));
                byte[] md5 = digest.digest();
                return this.server.get((0xFF & md5[0]) % this.dimension);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("sharding - no md5 available: " + e.getMessage());
            }
        }
        return this.server.get(this.selectRoundRobin());
    }

    public SolrClient server4write(URL url) throws IOException {
        return this.server4write(url.getHost());
    }

    public List<SolrClient> server4read() {
        if (this.method == Method.MODULO_HOST_MD5 || this.method == Method.ROUND_ROBIN) {
            return this.server;
        }
        ArrayList<SolrClient> a = new ArrayList<SolrClient>(1);
        a.add(this.server.get(this.selectRoundRobin()));
        return a;
    }

    @Override
    public Iterator<SolrClient> iterator() {
        return this.server.iterator();
    }

    public static enum Method {
        MODULO_HOST_MD5("hash-based calculation of storage targets, select all for retrieval"),
        ROUND_ROBIN("round-robin of storage targets, select all for retrieval"),
        SOLRCLOUD("round-robin of storage targets and round-robin for retrieval");

        public final String description;

        private Method(String description) {
            this.description = description;
        }
    }
}

