/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import net.yacy.cora.date.AbstractFormatter;
import net.yacy.cora.date.DateFormatter;

public class ISO8601Formatter
extends AbstractFormatter
implements DateFormatter {
    private static final String PATTERN_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final SimpleDateFormat FORMAT_ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    public static final ISO8601Formatter FORMATTER;

    public ISO8601Formatter() {
        this.last_time = 0L;
        this.last_format = "";
    }

    @Override
    public Calendar parse(String s, int timezoneOffset) throws ParseException {
        int p;
        s = ((String)s).trim();
        while (!((String)s).isEmpty() && ((String)s).endsWith("?")) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        if (((String)s).startsWith("{")) {
            s = ((String)s).substring(1);
        }
        if (((String)s).endsWith("}")) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        if (((String)s).startsWith("[")) {
            s = ((String)s).substring(1);
        }
        if (((String)s).endsWith("]")) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        while (!(((String)s).isEmpty() || ((String)s).charAt(0) <= '9' && ((String)s).charAt(0) >= '0')) {
            s = ((String)s).substring(1);
        }
        if (((String)s).endsWith("--")) {
            s = ((String)s).substring(0, ((String)s).length() - 2) + "00";
        }
        if ((p = ((String)s).indexOf(59)) >= 0) {
            s = ((String)s).substring(0, p);
        }
        if ((p = ((String)s).indexOf(44)) >= 0) {
            s = ((String)s).substring(0, p);
        }
        while (!((String)s).isEmpty() && ((String)s).endsWith("?")) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        Calendar cal = Calendar.getInstance(AbstractFormatter.UTCtimeZone, Locale.US);
        cal.clear();
        StringTokenizer t = new StringTokenizer((String)s, "-T:.Z+", true);
        if (s == null || t.countTokens() == 0) {
            throw new ParseException("parseISO8601: Cannot parse '" + (String)s + "'", 0);
        }
        try {
            cal.set(1, Integer.parseInt(t.nextToken()));
            if (!t.nextToken().equals("-")) {
                return cal;
            }
            cal.set(2, Integer.parseInt(t.nextToken()) - 1);
            if (!t.nextToken().equals("-")) {
                return cal;
            }
            cal.set(5, Integer.parseInt(t.nextToken()));
            if (this.getTimeSeparator().contains(t.nextToken())) {
                int hour = Integer.parseInt(t.nextToken());
                int min = 0;
                int sec = 0;
                int msec = 0;
                if (t.nextToken().equals(":")) {
                    int offset;
                    min = Integer.parseInt(t.nextToken());
                    String token = t.nextToken();
                    if (token.equals(":")) {
                        sec = Integer.parseInt(t.nextToken());
                        token = t.nextToken();
                        if (token.equals(".")) {
                            msec = Integer.parseInt(t.nextToken());
                            token = t.nextToken();
                        }
                    }
                    if (token.equals("Z")) {
                        offset = 0;
                    } else {
                        int sign = 0;
                        if (token.equals("+")) {
                            sign = 1;
                        } else if (token.equals("-")) {
                            sign = -1;
                        } else {
                            return cal;
                        }
                        offset = this.getOffset(t, sign);
                    }
                    cal.set(15, offset);
                }
                cal.set(11, hour);
                cal.set(12, min);
                cal.set(13, sec);
                cal.set(14, msec);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!cal.isSet(1)) {
            throw new ParseException("parseISO8601: Cannot parse '" + (String)s + "'", 0);
        }
        return cal;
    }

    public int getOffset(StringTokenizer t, int sign) {
        String offset = t.nextToken();
        return sign * Integer.parseInt(offset) * 10 * 3600;
    }

    public Collection<String> getTimeSeparator() {
        return Set.of("T");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String format(Date date) {
        if (date == null) {
            return "";
        }
        if (Math.abs(date.getTime() - this.last_time) < 1000L) {
            return this.last_format;
        }
        SimpleDateFormat simpleDateFormat = FORMAT_ISO8601;
        synchronized (simpleDateFormat) {
            this.last_format = FORMAT_ISO8601.format(date);
            this.last_time = date.getTime();
        }
        return this.last_format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String format() {
        long time = System.currentTimeMillis();
        if (Math.abs(time - this.last_time) < 1000L) {
            return this.last_format;
        }
        SimpleDateFormat simpleDateFormat = FORMAT_ISO8601;
        synchronized (simpleDateFormat) {
            this.last_format = FORMAT_ISO8601.format(new Date(time));
            this.last_time = time;
        }
        return this.last_format;
    }

    static {
        FORMAT_ISO8601.setTimeZone(AbstractFormatter.UTCtimeZone);
        FORMATTER = new ISO8601Formatter();
    }
}

