/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.bayes;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.bayes.Classification;

public abstract class Classifier<T, K> {
    private static final int INITIAL_CATEGORY_DICTIONARY_CAPACITY = 16;
    private static final int INITIAL_FEATURE_DICTIONARY_CAPACITY = 32;
    private int memoryCapacity = 1000;
    private Map<K, Map<T, Integer>> featureCountPerCategory;
    private Map<T, Integer> totalFeatureCount;
    private Map<K, Integer> totalCategoryCount;
    private Queue<Classification<T, K>> memoryQueue;

    public Classifier() {
        this.reset();
    }

    public void reset() {
        this.featureCountPerCategory = new ConcurrentHashMap<K, Map<T, Integer>>(16);
        this.totalFeatureCount = new ConcurrentHashMap<T, Integer>(32);
        this.totalCategoryCount = new ConcurrentHashMap<K, Integer>(16);
        this.memoryQueue = new LinkedList<Classification<T, K>>();
    }

    public Set<T> getFeatures() {
        return this.totalFeatureCount.keySet();
    }

    public Set<K> getCategories() {
        return this.totalCategoryCount.keySet();
    }

    public int getCategoriesTotal() {
        int toReturn = 0;
        for (Integer c : this.totalCategoryCount.values()) {
            toReturn += c.intValue();
        }
        return toReturn;
    }

    public int getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public void setMemoryCapacity(int memoryCapacity) {
        for (int i = this.memoryCapacity; i > memoryCapacity; --i) {
            this.memoryQueue.poll();
        }
        this.memoryCapacity = memoryCapacity;
    }

    public void incrementFeature(T feature, K category) {
        Integer count;
        Map<T, Integer> features = this.featureCountPerCategory.get(category);
        if (features == null) {
            this.featureCountPerCategory.put(category, new ConcurrentHashMap(32));
            features = this.featureCountPerCategory.get(category);
        }
        if ((count = features.get(feature)) == null) {
            features.put(feature, 0);
            count = features.get(feature);
        }
        count = count + 1;
        features.put(feature, count);
        Integer totalCount = this.totalFeatureCount.get(feature);
        if (totalCount == null) {
            this.totalFeatureCount.put(feature, 0);
            totalCount = this.totalFeatureCount.get(feature);
        }
        totalCount = totalCount + 1;
        this.totalFeatureCount.put(feature, totalCount);
    }

    public void incrementCategory(K category) {
        Integer count = this.totalCategoryCount.get(category);
        if (count == null) {
            this.totalCategoryCount.put(category, 0);
            count = this.totalCategoryCount.get(category);
        }
        count = count + 1;
        this.totalCategoryCount.put(category, count);
    }

    public void decrementFeature(T feature, K category) {
        Integer totalCount;
        Map<T, Integer> features = this.featureCountPerCategory.get(category);
        if (features == null) {
            return;
        }
        Integer count = features.get(feature);
        if (count == null) {
            return;
        }
        if (count == 1) {
            features.remove(feature);
            if (features.size() == 0) {
                this.featureCountPerCategory.remove(category);
            }
        } else {
            count = count - 1;
            features.put(feature, count);
        }
        if ((totalCount = this.totalFeatureCount.get(feature)) == null) {
            return;
        }
        if (totalCount == 1) {
            this.totalFeatureCount.remove(feature);
        } else {
            totalCount = totalCount - 1;
            this.totalFeatureCount.put(feature, totalCount);
        }
    }

    public void decrementCategory(K category) {
        Integer count = this.totalCategoryCount.get(category);
        if (count == null) {
            return;
        }
        if (count == 1) {
            this.totalCategoryCount.remove(category);
        } else {
            count = count - 1;
            this.totalCategoryCount.put(category, count);
        }
    }

    public int featureCount(T feature, K category) {
        Map<T, Integer> features = this.featureCountPerCategory.get(category);
        if (features == null) {
            return 0;
        }
        Integer count = features.get(feature);
        return count == null ? 0 : count;
    }

    public int categoryCount(K category) {
        Integer count = this.totalCategoryCount.get(category);
        return count == null ? 0 : count;
    }

    public float featureProbability(T feature, K category) {
        if (this.categoryCount(category) == 0) {
            return 0.0f;
        }
        return (float)this.featureCount(feature, category) / (float)this.categoryCount(category);
    }

    public float featureWeighedAverage(T feature, K category) {
        return this.featureWeighedAverage(feature, category, null, 1.0f, 0.5f);
    }

    public float featureWeighedAverage(T feature, K category, Classifier<T, K> calculator) {
        return this.featureWeighedAverage(feature, category, calculator, 1.0f, 0.5f);
    }

    public float featureWeighedAverage(T feature, K category, Classifier<T, K> calculator, float weight) {
        return this.featureWeighedAverage(feature, category, calculator, weight, 0.5f);
    }

    public float featureWeighedAverage(T feature, K category, Classifier<T, K> calculator, float weight, float assumedProbability) {
        float basicProbability = calculator == null ? this.featureProbability(feature, category) : calculator.featureProbability(feature, category);
        Integer totals = this.totalFeatureCount.get(feature);
        if (totals == null) {
            totals = 0;
        }
        return (weight * assumedProbability + (float)totals.intValue() * basicProbability) / (weight + (float)totals.intValue());
    }

    public void learn(K category, Collection<T> features) {
        this.learn(new Classification<T, K>(features, category));
    }

    public void learn(Classification<T, K> classification) {
        for (T feature : classification.getFeatureset()) {
            this.incrementFeature(feature, classification.getCategory());
        }
        this.incrementCategory(classification.getCategory());
        this.memoryQueue.offer(classification);
        if (this.memoryQueue.size() > this.memoryCapacity) {
            Classification<T, K> toForget = this.memoryQueue.remove();
            for (T feature : toForget.getFeatureset()) {
                this.decrementFeature(feature, toForget.getCategory());
            }
            this.decrementCategory(toForget.getCategory());
        }
    }

    public abstract Classification<T, K> classify(Collection<T> var1);
}

