/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai.llama3.Tensor;

import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.yacy.ai.llama3.Model.GGMLType;

public abstract class FloatTensor {
    public static final float float16ToFloat(short h) {
        int fBits;
        int hBits = h & 0xFFFF;
        int sign = hBits >>> 15 & 1;
        int exp = hBits >>> 10 & 0x1F;
        int mant = hBits & 0x3FF;
        if (exp == 0) {
            if (mant == 0) {
                fBits = sign << 31;
            } else {
                while ((mant & 0x400) == 0) {
                    mant <<= 1;
                    --exp;
                }
                fBits = sign << 31 | ++exp + 127 - 15 << 23 | (mant &= 0xFFFFFBFF) << 13;
            }
        } else {
            fBits = exp == 31 ? sign << 31 | 0x7F800000 | mant << 13 : sign << 31 | exp + 127 - 15 << 23 | mant << 13;
        }
        return Float.intBitsToFloat(fBits);
    }

    public static final short floatToFloat16(float f) {
        int fBits = Float.floatToIntBits(f);
        int sign = fBits >>> 31 & 1;
        int exp = fBits >>> 23 & 0xFF;
        int mant = fBits & 0x7FFFFF;
        short hBits = exp == 255 ? (short)(sign << 15 | 0x7C00 | mant >>> 13) : (exp < 112 ? (short)(sign << 15) : (exp > 143 ? (short)(sign << 15 | 0x7C00) : (short)(sign << 15 | exp - 112 << 10 | mant >>> 13)));
        return hBits;
    }

    public static void parallelFor(int startInclusive, int endExclusive, IntConsumer action) {
        if (startInclusive == 0 && endExclusive == 1) {
            action.accept(0);
            return;
        }
        IntStream.range(startInclusive, endExclusive).parallel().forEach(action);
    }

    public static void parallelForLong(long startInclusive, long endExclusive, LongConsumer action) {
        if (startInclusive == 0L && endExclusive == 1L) {
            action.accept(0L);
            return;
        }
        LongStream.range(startInclusive, endExclusive).parallel().forEach(action);
    }

    public abstract int size();

    public abstract float getFloat(int var1);

    public abstract void setFloat(int var1, float var2);

    abstract GGMLType type();

    public static int numberOfElements(int ... dimensions) {
        assert (Arrays.stream(dimensions).allMatch(i -> i > 0));
        return Arrays.stream(dimensions).reduce(Math::multiplyExact).orElseThrow();
    }

    public static float scalarDot(FloatTensor thiz, int thisOffset, FloatTensor that, int thatOffset, int size) {
        float result = 0.0f;
        for (int j = 0; j < size; ++j) {
            result += thiz.getFloat(thisOffset + j) * that.getFloat(thatOffset + j);
        }
        return result;
    }

    public float dot(int thisOffset, FloatTensor that, int thatOffset, int size) {
        return FloatTensor.scalarDot(this, thisOffset, that, thatOffset, size);
    }

    public void matmul(FloatTensor that, FloatTensor out, int dim0, int dim1) {
        FloatTensor.parallelFor(0, dim0, i -> out.setFloat(i, this.dot(i * dim1, that, 0, dim1)));
    }

    public void matmul(int context, FloatTensor[] that, FloatTensor[] out, int dim0, int dim1) {
        if (that.length != out.length) {
            throw new IllegalArgumentException(String.format("that.len=%d, out.len=%d", that.length, out.length));
        }
        FloatTensor.parallelForLong(0L, dim0 * context, ti -> {
            int idxArr = (int)(ti / (long)dim0);
            int i = (int)(ti % (long)dim0);
            out[idxArr].setFloat(i, this.dot(i * dim1, that[idxArr], 0, dim1));
        });
    }

    public float reduce(int thisOffset, int size, float seed, AggregateFunction reduce) {
        float result = seed;
        for (int i = 0; i < size; ++i) {
            result = reduce.apply(result, this.getFloat(thisOffset + i));
        }
        return result;
    }

    private float sum(int thisOffset, int size) {
        return this.reduce(thisOffset, size, 0.0f, Float::sum);
    }

    private float max(int thisOffset, int size) {
        return this.reduce(thisOffset, size, Float.NEGATIVE_INFINITY, Float::max);
    }

    public void copyTo(int thisOffset, FloatTensor that, int thatOffset, int size) {
        int endOffset = thatOffset + size;
        for (int i = thatOffset; i < endOffset; ++i) {
            that.setFloat(i, this.getFloat(i - thatOffset + thisOffset));
        }
    }

    private int argmax(int thisOffset, int size) {
        assert (size > 0);
        int maxIndex = thisOffset;
        float maxValue = this.getFloat(maxIndex);
        int endIndex = thisOffset + size;
        for (int i = thisOffset; i < endIndex; ++i) {
            float f = this.getFloat(i);
            if (!(f > maxValue)) continue;
            maxValue = f;
            maxIndex = i;
        }
        return maxIndex;
    }

    public int argmax() {
        return this.argmax(0, this.size());
    }

    public FloatTensor mapInPlace(int thisOffset, int size, MapFunction mapFunction) {
        int endIndex = thisOffset + size;
        for (int i = thisOffset; i < endIndex; ++i) {
            this.setFloat(i, mapFunction.apply(this.getFloat(i)));
        }
        return this;
    }

    public final FloatTensor mapInPlace(MapFunction mapFunction) {
        return this.mapInPlace(0, this.size(), mapFunction);
    }

    public final FloatTensor mapWithIndexInPlace(int thisOffset, int size, MapWithIndexFunction mapWithIndexFunction) {
        int endOffset = thisOffset + size;
        for (int i = thisOffset; i < endOffset; ++i) {
            this.setFloat(i, mapWithIndexFunction.apply(this.getFloat(i), i));
        }
        return this;
    }

    private final FloatTensor addInPlace(int thisOffset, FloatTensor that, int thatOffset, int size) {
        return this.mapWithIndexInPlace(thisOffset, size, (value, index2) -> value + that.getFloat(index2 - thisOffset + thatOffset));
    }

    public final FloatTensor addInPlace(FloatTensor that) {
        return this.addInPlace(0, that, 0, this.size());
    }

    private final FloatTensor multiplyInPlace(int thisOffset, FloatTensor that, int thatOffset, int size) {
        return this.mapWithIndexInPlace(thisOffset, size, (value, index2) -> value * that.getFloat(index2 - thisOffset + thatOffset));
    }

    public final FloatTensor multiplyInPlace(FloatTensor that) {
        return this.multiplyInPlace(0, that, 0, this.size());
    }

    public final FloatTensor divideInPlace(int thisOffset, int size, float value) {
        return this.mapInPlace(thisOffset, size, f -> f / value);
    }

    public FloatTensor fillInPlace(int thisOffset, int size, float value) {
        return this.mapInPlace(thisOffset, size, unused -> value);
    }

    public final FloatTensor softmaxInPlace(int thisOffset, int size) {
        float maxVal = this.max(thisOffset, size);
        this.mapInPlace(thisOffset, size, f -> (float)Math.exp(f - maxVal));
        float sum = this.sum(thisOffset, size);
        return this.divideInPlace(thisOffset, size, sum);
    }

    public FloatTensor saxpyInPlace(int thisOffset, FloatTensor that, int thatOffset, int size, float a) {
        for (int i = 0; i < size; ++i) {
            this.setFloat(thisOffset + i, a * that.getFloat(thatOffset + i) + this.getFloat(thisOffset + i));
        }
        return this;
    }

    @FunctionalInterface
    public static interface AggregateFunction {
        public float apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface MapFunction {
        public float apply(float var1);
    }

    @FunctionalInterface
    public static interface MapWithIndexFunction {
        public float apply(float var1, int var2);
    }
}

