/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai.llama3.Tensor;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import net.yacy.ai.llama3.Model.GGMLType;
import net.yacy.ai.llama3.Tensor.FloatTensor;

public class DirectBufferFloatTensor
extends FloatTensor {
    final FloatBuffer floatBuffer;

    public DirectBufferFloatTensor(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            this.floatBuffer = byteBuffer.asFloatBuffer();
        } else {
            int capacityBytes = byteBuffer.remaining();
            ByteBuffer directByteBuffer = ByteBuffer.allocateDirect(capacityBytes).order(byteBuffer.order());
            directByteBuffer.put(byteBuffer.duplicate());
            directByteBuffer.flip();
            this.floatBuffer = directByteBuffer.asFloatBuffer();
        }
    }

    public DirectBufferFloatTensor(float[] values) {
        int capacityBytes = values.length * 4;
        ByteBuffer directByteBuffer = ByteBuffer.allocateDirect(capacityBytes).order(ByteOrder.nativeOrder());
        this.floatBuffer = directByteBuffer.asFloatBuffer();
        this.floatBuffer.put(values);
    }

    public static FloatTensor allocate(int ... dims) {
        int numberOfElements = FloatTensor.numberOfElements(dims);
        int bytesNeeded = numberOfElements * 4;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytesNeeded).order(ByteOrder.nativeOrder());
        return new DirectBufferFloatTensor(buffer);
    }

    @Override
    public final int size() {
        return this.floatBuffer.capacity();
    }

    @Override
    public final float getFloat(int index2) {
        return this.floatBuffer.get(index2);
    }

    @Override
    public final void setFloat(int index2, float value) {
        this.floatBuffer.put(index2, value);
    }

    @Override
    public final GGMLType type() {
        return GGMLType.F32;
    }

    @Override
    public final float dot(int thisOffset, FloatTensor that, int thatOffset, int size) {
        float result = 0.0f;
        for (int j = 0; j < size; ++j) {
            result += this.floatBuffer.get(thisOffset + j) * that.getFloat(thatOffset + j);
        }
        return result;
    }

    @Override
    public final FloatTensor fillInPlace(int thisOffset, int size, float value) {
        int end = thisOffset + size;
        for (int i = thisOffset; i < end; ++i) {
            this.floatBuffer.put(i, value);
        }
        return this;
    }

    @Override
    public final FloatTensor mapInPlace(int thisOffset, int size, FloatTensor.MapFunction mapFunction) {
        int end = thisOffset + size;
        for (int i = thisOffset; i < end; ++i) {
            float current = this.floatBuffer.get(i);
            this.floatBuffer.put(i, mapFunction.apply(current));
        }
        return this;
    }
}

