/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai.llama3.Model;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Objects;
import net.yacy.ai.llama3.Model.GGMLType;
import net.yacy.ai.llama3.Tensor.FloatTensor;
import net.yacy.ai.llama3.Tensor.Q4_0FloatTensor;
import net.yacy.ai.llama3.Tensor.Q8_0FloatTensor;

public final class GGMLTensorEntry {
    private final ByteBuffer buffer;
    private final String name;
    private final GGMLType ggmlType;
    private final int[] shape;

    public GGMLTensorEntry(String name, GGMLType ggmlType, int[] shape, ByteBuffer buffer) throws IOException {
        assert (buffer.isDirect()) : "Buffer must be a direct ByteBuffer";
        this.buffer = buffer;
        buffer.order(ByteOrder.nativeOrder());
        this.name = Objects.requireNonNull(name);
        this.ggmlType = Objects.requireNonNull(ggmlType);
        this.shape = Arrays.copyOf(Objects.requireNonNull(shape), shape.length);
    }

    public float getFloat(int index2) {
        return this.buffer.getFloat(index2 * 4);
    }

    public String name() {
        return this.name;
    }

    public GGMLType ggmlType() {
        return this.ggmlType;
    }

    public int[] shape() {
        return Arrays.copyOf(this.shape, this.shape.length);
    }

    public FloatBuffer toFloatBuffer() {
        switch (this.ggmlType) {
            case F32: {
                return this.buffer.order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
            }
        }
        throw new UnsupportedOperationException("Conversion to " + String.valueOf((Object)this.ggmlType));
    }

    public FloatTensor loadQuantized() {
        FloatTensor tensor = null;
        switch (this.ggmlType) {
            case Q8_0: {
                tensor = new Q8_0FloatTensor(FloatTensor.numberOfElements(this.shape()), this.buffer);
                break;
            }
            case Q4_0: {
                tensor = new Q4_0FloatTensor(FloatTensor.numberOfElements(this.shape()), this.buffer);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Quantization format " + String.valueOf((Object)this.ggmlType));
            }
        }
        return tensor;
    }
}

