/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai.llama3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.yacy.ai.llama3.Model.Tokenizer;

public class ChatFormat {
    final Tokenizer tokenizer;
    final int beginOfText;
    final int endHeader;
    final int startHeader;
    final int endOfTurn;
    final int endOfText;
    final int endOfMessage;
    final Set<Integer> stopTokens;

    public ChatFormat(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        Map<String, Integer> specialTokens = this.tokenizer.getSpecialTokens();
        this.beginOfText = specialTokens.get("<|begin_of_text|>");
        this.startHeader = specialTokens.get("<|start_header_id|>");
        this.endHeader = specialTokens.get("<|end_header_id|>");
        this.endOfTurn = specialTokens.get("<|eot_id|>");
        this.endOfText = specialTokens.get("<|end_of_text|>");
        this.endOfMessage = specialTokens.getOrDefault("<|eom_id|>", -1);
        this.stopTokens = Set.of(Integer.valueOf(this.endOfText), Integer.valueOf(this.endOfTurn));
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public Set<Integer> getStopTokens() {
        return this.stopTokens;
    }

    public List<Integer> encodeHeader(Message message2) {
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        tokens.add(this.startHeader);
        tokens.addAll(this.tokenizer.encodeAsList(message2.role().name()));
        tokens.add(this.endHeader);
        tokens.addAll(this.tokenizer.encodeAsList("\n"));
        return tokens;
    }

    public List<Integer> encodeMessage(Message message2) {
        List<Integer> tokens = this.encodeHeader(message2);
        tokens.addAll(this.tokenizer.encodeAsList(message2.content().strip()));
        tokens.add(this.endOfTurn);
        return tokens;
    }

    public List<Integer> encodeDialogPrompt(boolean appendAssistantTurn, List<Message> dialog) {
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        tokens.add(this.beginOfText);
        for (Message message2 : dialog) {
            tokens.addAll(this.encodeMessage(message2));
        }
        if (appendAssistantTurn) {
            tokens.addAll(this.encodeHeader(new Message(Role.ASSISTANT, "")));
        }
        return tokens;
    }

    public static final class Message {
        private final Role role;
        private final String content;

        public Message(Role role, String content) {
            this.role = role;
            this.content = content;
        }

        public Role role() {
            return this.role;
        }

        public String content() {
            return this.content;
        }
    }

    public static final class Role {
        private final String name;
        public static final Role SYSTEM = new Role("system");
        public static final Role USER = new Role("user");
        public static final Role ASSISTANT = new Role("assistant");

        public Role(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }
}

