/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.yacy.ai.LLM;

public class LLMSwarm {
    Random random = new Random();
    List<LLM> swarm = new ArrayList<LLM>();

    public void addOllamaClient(LLM client) {
        this.swarm.add(client);
    }

    public List<String> getSwarm() {
        ArrayList<String> hoststubs = new ArrayList<String>();
        for (LLM client : this.swarm) {
            hoststubs.add(client.getHoststub());
        }
        return hoststubs;
    }

    public LinkedHashMap<String, Integer> listOllamaModels() {
        LinkedHashMap<String, Integer> modelCountMap = new LinkedHashMap<String, Integer>();
        for (LLM client : this.swarm) {
            LinkedHashMap<String, Long> models = client.listOllamaModels();
            for (Map.Entry<String, Long> entry2 : models.entrySet()) {
                modelCountMap.merge(entry2.getKey(), 1, Integer::sum);
            }
        }
        return modelCountMap;
    }

    public boolean ollamaModelExists(String name) {
        for (LLM client : this.swarm) {
            if (!client.ollamaModelExists(name)) continue;
            return true;
        }
        return false;
    }

    public boolean pullOllamaModel(String name, boolean all2) {
        boolean pulled = false;
        if (all2) {
            for (LLM client : this.swarm) {
                if (!client.pullOllamaModel(name)) continue;
                pulled = true;
            }
        } else {
            for (int i = 0; i < this.swarm.size(); ++i) {
                int index2 = this.random.nextInt(this.swarm.size());
                LLM client = this.swarm.get(index2);
                pulled = client.pullOllamaModel(name);
                if (!pulled) continue;
                return true;
            }
        }
        return pulled;
    }

    public List<LLM> getSwarm(String name) {
        ArrayList<LLM> clientsWithModel = new ArrayList<LLM>();
        for (LLM client : this.swarm) {
            if (!client.ollamaModelExists(name)) continue;
            clientsWithModel.add(client);
        }
        return clientsWithModel;
    }

    public String getAnswer(String model, String systemPrompt, String userPrompt) throws IOException {
        List<LLM> clientsWithModel = this.getSwarm(model);
        if (clientsWithModel.isEmpty()) {
            return "No client with model " + model + " found.";
        }
        LLM client = clientsWithModel.get(this.random.nextInt(clientsWithModel.size()));
        return client.chat(model, systemPrompt, userPrompt, 4096);
    }
}

