/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LLM {
    private static String[] STOPTOKENS = new String[]{"[/INST]", "<|im_end|>", "<|end_of_turn|>", "<|eot_id|>", "<|end_header_id|>", "<EOS_TOKEN>", "</s>", "<|end|>"};
    public final String hoststub;
    public final String key;
    public final int max_tokens;
    public final LLMType type;
    public static final JSONObject listSchema = new JSONObject(Map.of("title", "Answer List", "type", "array", "properties", Map.of("answer", Map.of("type", "string")), "required", List.of("answer")));

    public LLM(String hoststub, String key, int max_tokens, LLMType type) {
        this.hoststub = hoststub.endsWith("/") ? hoststub.substring(0, hoststub.length() - 1) : hoststub;
        this.key = key == null ? "" : key;
        this.max_tokens = max_tokens <= 0 ? 4096 : max_tokens;
        this.type = type;
    }

    public String getHoststub() {
        return this.hoststub;
    }

    public static String sendPostRequest(String urls2, JSONObject data) throws IOException, URISyntaxException {
        URL url = new URI(urls2).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = data.toString().getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                String string = response.toString();
                return string;
            }
        }
        throw new IOException("Request failed with response code " + responseCode);
    }

    public static String sendGetRequest(String urls2) throws IOException, URISyntaxException {
        URL url = new URI(urls2).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                String string = response.toString();
                return string;
            }
        }
        throw new IOException("Request failed with response code " + responseCode);
    }

    public LinkedHashMap<String, Long> listOllamaModels() {
        LinkedHashMap<String, Long> sortedMap = new LinkedHashMap<String, Long>();
        try {
            String response = LLM.sendGetRequest(this.hoststub + "/api/tags");
            JSONObject responseObject = new JSONObject(response);
            JSONArray models = responseObject.getJSONArray("models");
            ArrayList<AbstractMap.SimpleEntry<String, Long>> list2 = new ArrayList<AbstractMap.SimpleEntry<String, Long>>();
            for (int i = 0; i < models.length(); ++i) {
                JSONObject jSONObject = models.getJSONObject(i);
                String name = jSONObject.optString("name", "");
                long size = jSONObject.optLong("size", 0L);
                list2.add(new AbstractMap.SimpleEntry<String, Long>(name, size));
            }
            list2.sort((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue()));
            for (Map.Entry entry2 : list2) {
                sortedMap.put((String)entry2.getKey(), (Long)entry2.getValue());
            }
        }
        catch (IOException | URISyntaxException | JSONException e) {
            e.printStackTrace();
        }
        return sortedMap;
    }

    public boolean ollamaModelExists(String name) {
        JSONObject data = new JSONObject();
        try {
            data.put("name", name);
            LLM.sendPostRequest(this.hoststub + "/api/show", data);
            return true;
        }
        catch (IOException | URISyntaxException | JSONException e) {
            return false;
        }
    }

    public boolean pullOllamaModel(String name) {
        JSONObject data = new JSONObject();
        try {
            data.put("name", name);
            data.put("stream", false);
            String response = LLM.sendPostRequest(this.hoststub + "/api/pull", data);
            JSONObject responseObject = new JSONObject(response);
            String status = responseObject.optString("status", "");
            return status.equals("success");
        }
        catch (IOException | URISyntaxException | JSONException e) {
            return false;
        }
    }

    public String chat(String model, Context context, JSONObject schema2, int max_tokens) throws IOException {
        JSONObject data = new JSONObject();
        try {
            data.put("model", model);
            data.put("temperature", 0.1);
            data.put("max_tokens", max_tokens);
            data.put("messages", context);
            data.put("stop", new JSONArray(STOPTOKENS));
            data.put("stream", false);
            if (schema2 != null) {
                System.out.println(schema2.toString());
                JSONObject json_schema = new JSONObject(true);
                json_schema.put("strict", true);
                json_schema.put("schema", schema2);
                JSONObject response_format = new JSONObject();
                response_format.put("type", "json_schema");
                response_format.put("json_schema", json_schema);
                data.put("response_format", response_format);
            }
            String response = LLM.sendPostRequest(this.hoststub + "/v1/chat/completions", data);
            JSONObject responseObject = new JSONObject(response);
            JSONArray choices = responseObject.getJSONArray("choices");
            JSONObject choice = choices.getJSONObject(0);
            JSONObject message2 = choice.getJSONObject("message");
            String content = message2.optString("content", "");
            return content;
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String chat(String model, String systemPrompt, String userPrompt, int max_tokens) throws IOException {
        try {
            Context context = new Context(systemPrompt);
            context.addPrompt(userPrompt);
            return this.chat(model, context, null, max_tokens);
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static String[] stringsFromChat(String chatanswer) throws JSONException {
        JSONArray ja = new JSONArray(chatanswer);
        ArrayList<String> list2 = new ArrayList<String>();
        block0: for (int i = 0; i < ja.length(); ++i) {
            Object item = ja.get(i);
            if (item instanceof String) {
                list2.add((String)item);
                continue;
            }
            if (!(item instanceof JSONObject)) continue;
            JSONObject jo = (JSONObject)item;
            String answer = jo.optString("answer", null);
            if (answer != null) {
                list2.add(answer);
                continue;
            }
            for (String key : jo.keySet()) {
                String value = jo.optString(key, null);
                if (value == null || !(value instanceof String)) continue;
                list2.add(value);
                continue block0;
            }
        }
        String[] result = new String[list2.size()];
        return list2.toArray(result);
    }

    public static void main(String[] args) {
        LLM llm = new LLM(LLMType.OLLAMA.hoststub, null, 4069, LLMType.OLLAMA);
        LinkedHashMap<String, Long> models = llm.listOllamaModels();
        System.out.println(models.toString());
        String model = "qwen2.5:0.5b";
        if (llm.ollamaModelExists("qwen2.5:0.5b")) {
            System.out.println("model qwen2.5:0.5b exists");
        } else {
            System.out.println("model qwen2.5:0.5b does not exist");
        }
        boolean success = llm.pullOllamaModel("qwen2.5:0.5b");
        System.out.println("pulled model: qwen2.5:0.5b: " + success);
        try {
            String response = llm.chat("qwen2.5:0.5b", "You are a helpful assistant.", "What is the capital of France?", 1000);
            System.out.println("Chat response: " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String question = "Who invented the wheel?";
        try {
            String answer = llm.chat("qwen2.5:0.5b", "Make short answers.", question, 200);
            System.out.println(answer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        question = "Make a list of four names from Star Wars movies. Use a JSON Array.";
        try {
            String[] a;
            Context context = new Context("Make short answers");
            context.addPrompt(question);
            for (String s : a = LLM.stringsFromChat(llm.chat("qwen2.5:0.5b", context, listSchema, 1000))) {
                System.out.println(s);
            }
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
    }

    public static enum LLMType {
        OPENAI("https://api.openai.com"),
        OLLAMA("http://localhost:11434"),
        LMSTUDIO("http://localhost:1234"),
        OPENROUTER("https://openrouter.ai/api"),
        OTHER(null);

        public String hoststub;

        private LLMType(String hoststub) {
            this.hoststub = hoststub;
        }
    }

    public static class Context
    extends JSONArray {
        public Context(String systemPrompt) throws JSONException {
            JSONObject systemPromptObject = new JSONObject(true);
            systemPromptObject.put("role", "system");
            systemPromptObject.put("content", systemPrompt);
            this.put(systemPromptObject);
        }

        public void addDialog(String user, String assistant) throws JSONException {
            JSONObject userPromptObject = new JSONObject(true);
            userPromptObject.put("role", "user");
            userPromptObject.put("content", user);
            this.put(userPromptObject);
            JSONObject assistantPromptObject = new JSONObject(true);
            assistantPromptObject.put("role", "assistant");
            assistantPromptObject.put("content", assistant);
            this.put(assistantPromptObject);
        }

        public void addPrompt(String userPrompt) throws JSONException {
            JSONObject userPromptObject = new JSONObject(true);
            userPromptObject.put("role", "user");
            userPromptObject.put("content", userPrompt);
            this.put(userPromptObject);
        }
    }
}

