/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrRequestInfo;

public class DateMathParser {
    public static final TimeZone UTC;
    public static final TimeZone DEFAULT_MATH_TZ;
    public static final DateTimeFormatter PARSER;
    public static final Map<String, ChronoUnit> CALENDAR_UNITS;
    private TimeZone zone;
    private Locale loc;
    private Date now;
    private static Pattern splitter;

    private static Map<String, ChronoUnit> makeUnitsMap() {
        HashMap<String, ChronoUnit> units = new HashMap<String, ChronoUnit>(13);
        units.put("YEAR", ChronoUnit.YEARS);
        units.put("YEARS", ChronoUnit.YEARS);
        units.put("MONTH", ChronoUnit.MONTHS);
        units.put("MONTHS", ChronoUnit.MONTHS);
        units.put("DAY", ChronoUnit.DAYS);
        units.put("DAYS", ChronoUnit.DAYS);
        units.put("DATE", ChronoUnit.DAYS);
        units.put("HOUR", ChronoUnit.HOURS);
        units.put("HOURS", ChronoUnit.HOURS);
        units.put("MINUTE", ChronoUnit.MINUTES);
        units.put("MINUTES", ChronoUnit.MINUTES);
        units.put("SECOND", ChronoUnit.SECONDS);
        units.put("SECONDS", ChronoUnit.SECONDS);
        units.put("MILLI", ChronoUnit.MILLIS);
        units.put("MILLIS", ChronoUnit.MILLIS);
        units.put("MILLISECOND", ChronoUnit.MILLIS);
        units.put("MILLISECONDS", ChronoUnit.MILLIS);
        return units;
    }

    private static LocalDateTime add(LocalDateTime t, int val, String unit) {
        ChronoUnit uu = CALENDAR_UNITS.get(unit);
        if (null == uu) {
            throw new IllegalArgumentException("Adding Unit not recognized: " + unit);
        }
        return t.plus(val, uu);
    }

    private static LocalDateTime round(LocalDateTime t, String unit) {
        ChronoUnit uu = CALENDAR_UNITS.get(unit);
        if (null == uu) {
            throw new IllegalArgumentException("Rounding Unit not recognized: " + unit);
        }
        switch (uu) {
            case YEARS: {
                return LocalDateTime.of(LocalDate.of(t.getYear(), 1, 1), LocalTime.MIDNIGHT);
            }
            case MONTHS: {
                return LocalDateTime.of(LocalDate.of(t.getYear(), t.getMonth(), 1), LocalTime.MIDNIGHT);
            }
            case DAYS: {
                return LocalDateTime.of(t.toLocalDate(), LocalTime.MIDNIGHT);
            }
        }
        assert (!uu.isDateBased());
        return t.truncatedTo(uu);
    }

    public static Date parseMath(Date now, String val) {
        return DateMathParser.parseMath(now, val, null);
    }

    public static Date parseMath(Date now, String val, TimeZone zone) {
        String math;
        DateMathParser p = new DateMathParser(zone);
        if (null != now) {
            p.setNow(now);
        }
        if (val.startsWith("NOW")) {
            math = val.substring("NOW".length());
        } else {
            int zz = val.indexOf(90);
            if (zz == -1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date String:'" + val + "'");
            }
            math = val.substring(zz + 1);
            try {
                p.setNow(DateMathParser.parseNoMath(val.substring(0, zz + 1)));
            }
            catch (DateTimeParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date in Date Math String:'" + val + "'", (Throwable)e);
            }
        }
        if (null == math || math.equals("")) {
            return p.getNow();
        }
        try {
            return p.parseMath(math);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date Math String:'" + val + "'", (Throwable)e);
        }
    }

    private static Date parseNoMath(String val) {
        return new Date(PARSER.parse((CharSequence)val, Instant::from).toEpochMilli());
    }

    public DateMathParser() {
        this(null, null);
    }

    public DateMathParser(TimeZone tz) {
        this(null, tz);
    }

    public DateMathParser(Date now, TimeZone tz) {
        this.now = now;
        if (null == tz) {
            SolrRequestInfo reqInfo = SolrRequestInfo.getRequestInfo();
            tz = null != reqInfo ? reqInfo.getClientTimeZone() : DEFAULT_MATH_TZ;
        }
        this.zone = null != tz ? tz : DEFAULT_MATH_TZ;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setNow(Date n) {
        this.now = n;
    }

    public Date getNow() {
        if (this.now == null) {
            SolrRequestInfo reqInfo = SolrRequestInfo.getRequestInfo();
            this.now = reqInfo == null ? new Date() : reqInfo.getNOW();
        }
        return (Date)this.now.clone();
    }

    public Date parseMath(String math) throws ParseException {
        if (0 == math.length()) {
            return this.getNow();
        }
        ZoneId zoneId = this.zone.toZoneId();
        LocalDateTime localDateTime = ZonedDateTime.ofInstant(this.getNow().toInstant(), zoneId).toLocalDateTime();
        String[] ops = splitter.split(math);
        int pos = 0;
        block10: while (pos < ops.length) {
            if (1 != ops[pos].length()) {
                throw new ParseException("Multi character command found: \"" + ops[pos] + "\"", pos);
            }
            char command = ops[pos++].charAt(0);
            switch (command) {
                case '/': {
                    if (ops.length < pos + 1) {
                        throw new ParseException("Need a unit after command: \"" + command + "\"", pos);
                    }
                    try {
                        localDateTime = DateMathParser.round(localDateTime, ops[pos++]);
                        continue block10;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException("Unit not recognized: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                }
                case '+': 
                case '-': {
                    if (ops.length < pos + 2) {
                        throw new ParseException("Need a value and unit for command: \"" + command + "\"", pos);
                    }
                    int val = 0;
                    try {
                        val = Integer.parseInt(ops[pos++]);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException("Not a Number: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                    if ('-' == command) {
                        val = 0 - val;
                    }
                    try {
                        String unit = ops[pos++];
                        localDateTime = DateMathParser.add(localDateTime, val, unit);
                        continue block10;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException("Unit not recognized: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                }
            }
            throw new ParseException("Unrecognized command: \"" + command + "\"", pos - 1);
        }
        return Date.from(ZonedDateTime.of(localDateTime, zoneId).toInstant());
    }

    static {
        DEFAULT_MATH_TZ = UTC = TimeZone.getTimeZone("UTC");
        PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendInstant().toFormatter(Locale.ROOT);
        CALENDAR_UNITS = DateMathParser.makeUnitsMap();
        splitter = Pattern.compile("\\b|(?<=\\d)(?=\\D)");
    }
}

