/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocBasedVersionConstraintsProcessor
extends UpdateRequestProcessor {
    private static final String[] EMPTY_STR_ARR = new String[0];
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String[] versionFieldNames;
    private final SchemaField[] userVersionFields;
    private final SchemaField solrVersionField;
    private final boolean ignoreOldUpdates;
    private final boolean supportMissingVersionOnOldDocs;
    private final String[] deleteVersionParamNames;
    private final SolrCore core;
    private final NamedList<Object> tombstoneConfig;
    private final DistributedUpdateProcessor distribProc;
    private final DistributedUpdateProcessor.DistribPhase phase;
    private final boolean useFieldCache;
    private long oldSolrVersion;

    public DocBasedVersionConstraintsProcessor(List<String> versionFields, boolean ignoreOldUpdates, List<String> deleteVersionParamNames, boolean supportMissingVersionOnOldDocs, boolean useFieldCache, NamedList<Object> tombstoneConfig, SolrQueryRequest req, UpdateRequestProcessor next) {
        super(next);
        this.ignoreOldUpdates = ignoreOldUpdates;
        this.deleteVersionParamNames = deleteVersionParamNames.toArray(EMPTY_STR_ARR);
        this.supportMissingVersionOnOldDocs = supportMissingVersionOnOldDocs;
        this.core = req.getCore();
        this.versionFieldNames = versionFields.toArray(EMPTY_STR_ARR);
        IndexSchema schema = this.core.getLatestSchema();
        this.userVersionFields = new SchemaField[this.versionFieldNames.length];
        for (int i = 0; i < this.versionFieldNames.length; ++i) {
            this.userVersionFields[i] = schema.getField(this.versionFieldNames[i]);
        }
        this.solrVersionField = schema.getField("_version_");
        this.useFieldCache = useFieldCache;
        this.distribProc = DocBasedVersionConstraintsProcessor.getDistributedUpdateProcessor(next);
        this.phase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get("update.distrib"));
        this.tombstoneConfig = tombstoneConfig;
    }

    private static DistributedUpdateProcessor getDistributedUpdateProcessor(UpdateRequestProcessor next) {
        UpdateRequestProcessor proc = next;
        while (proc != null) {
            if (proc instanceof DistributedUpdateProcessor) {
                return (DistributedUpdateProcessor)proc;
            }
            proc = proc.next;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "DistributedUpdateProcessor must follow DocBasedVersionConstraintsProcessor");
    }

    private static Object convertFieldValueUsingType(Object rawValue, SchemaField field) {
        if (rawValue instanceof CharSequence) {
            FieldType fieldType = field.getType();
            BytesRefBuilder term = new BytesRefBuilder();
            fieldType.readableToIndexed((CharSequence)rawValue, term);
            return fieldType.toObject(field, term.get());
        }
        return rawValue;
    }

    private Object[] convertFieldValuesUsingType(Object[] rawValues) {
        Object[] returnArr = new Object[rawValues.length];
        for (int i = 0; i < returnArr.length; ++i) {
            returnArr[i] = DocBasedVersionConstraintsProcessor.convertFieldValueUsingType(rawValues[i], this.userVersionFields[i]);
        }
        return returnArr;
    }

    private boolean isVersionNewEnough(BytesRef indexedDocId, Object[] newUserVersions) throws IOException {
        assert (null != indexedDocId);
        assert (null != newUserVersions);
        newUserVersions = this.convertFieldValuesUsingType(newUserVersions);
        DocFoundAndOldUserAndSolrVersions docFoundAndOldUserVersions = this.useFieldCache ? this.getOldUserVersionsFromFieldCache(indexedDocId) : this.getOldUserVersionsFromStored(indexedDocId);
        this.oldSolrVersion = docFoundAndOldUserVersions.oldSolrVersion;
        if (!docFoundAndOldUserVersions.found) {
            return true;
        }
        Object[] oldUserVersions = docFoundAndOldUserVersions.oldUserVersions;
        this.validateUserVersions(oldUserVersions, this.versionFieldNames, "Doc exists in index, but has null versionField: ");
        return this.versionInUpdateIsAcceptable(newUserVersions, oldUserVersions);
    }

    private void validateUserVersions(Object[] userVersions, String[] fieldNames, String errorMessage) {
        assert (userVersions.length == fieldNames.length);
        for (int i = 0; i < userVersions.length; ++i) {
            Object userVersion = userVersions[i];
            if (this.supportMissingVersionOnOldDocs && null == userVersion) {
                userVersions[i] = o -> -1;
                continue;
            }
            if (null != userVersion) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errorMessage + fieldNames[i]);
        }
    }

    private DocFoundAndOldUserAndSolrVersions getOldUserVersionsFromFieldCache(BytesRef indexedDocId) {
        SolrInputDocument oldDoc = RealTimeGetComponent.getInputDocumentFromTlog(this.core, indexedDocId, null, null, true);
        if (oldDoc == RealTimeGetComponent.DELETED) {
            return DocFoundAndOldUserAndSolrVersions.NOT_FOUND;
        }
        if (oldDoc == null) {
            RefCounted<SolrIndexSearcher> newestSearcher = this.core.getRealtimeSearcher();
            try {
                SolrIndexSearcher searcher = newestSearcher.get();
                long lookup = searcher.lookupId(indexedDocId);
                if (lookup < 0L) {
                    DocFoundAndOldUserAndSolrVersions docFoundAndOldUserAndSolrVersions = DocFoundAndOldUserAndSolrVersions.NOT_FOUND;
                    return docFoundAndOldUserAndSolrVersions;
                }
                LeafReaderContext segmentContext = (LeafReaderContext)searcher.getTopReaderContext().leaves().get((int)(lookup >> 32));
                int docIdInSegment = (int)lookup;
                long oldSolrVersion = DocBasedVersionConstraintsProcessor.getFunctionValues(segmentContext, this.solrVersionField, searcher).longVal(docIdInSegment);
                Object[] oldUserVersions = DocBasedVersionConstraintsProcessor.getObjectValues(segmentContext, this.userVersionFields, searcher, docIdInSegment);
                DocFoundAndOldUserAndSolrVersions docFoundAndOldUserAndSolrVersions = new DocFoundAndOldUserAndSolrVersions(oldUserVersions, oldSolrVersion);
                return docFoundAndOldUserAndSolrVersions;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading version from index", (Throwable)e);
            }
            finally {
                if (newestSearcher != null) {
                    newestSearcher.decref();
                }
            }
        }
        return this.getUserVersionAndSolrVersionFromDocument(oldDoc);
    }

    private DocFoundAndOldUserAndSolrVersions getOldUserVersionsFromStored(BytesRef indexedDocId) throws IOException {
        SolrInputDocument oldDoc = RealTimeGetComponent.getInputDocument(this.core, indexedDocId, RealTimeGetComponent.Resolution.DOC);
        if (null == oldDoc) {
            return DocFoundAndOldUserAndSolrVersions.NOT_FOUND;
        }
        return this.getUserVersionAndSolrVersionFromDocument(oldDoc);
    }

    private DocFoundAndOldUserAndSolrVersions getUserVersionAndSolrVersionFromDocument(SolrInputDocument oldDoc) {
        Object[] oldUserVersions = this.getUserVersionsFromDocument(oldDoc);
        Object o = oldDoc.getFieldValue(this.solrVersionField.getName());
        if (o == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No _version_ for document " + oldDoc);
        }
        long solrVersion = o instanceof Number ? ((Number)o).longValue() : Long.parseLong(o.toString());
        return new DocFoundAndOldUserAndSolrVersions(oldUserVersions, solrVersion);
    }

    private Object[] getUserVersionsFromDocument(SolrInputDocument doc) {
        Object[] versions = new Object[this.versionFieldNames.length];
        for (int i = 0; i < this.versionFieldNames.length; ++i) {
            String fieldName = this.versionFieldNames[i];
            SchemaField schemaField = this.userVersionFields[i];
            Object userVersion = doc.getFieldValue(fieldName);
            versions[i] = userVersion = DocBasedVersionConstraintsProcessor.convertFieldValueUsingType(userVersion, schemaField);
        }
        return versions;
    }

    protected boolean versionInUpdateIsAcceptable(Object[] newUserVersions, Object[] oldUserVersions) {
        for (int i = 0; i < oldUserVersions.length; ++i) {
            Object oldUserVersion = oldUserVersions[i];
            Object newUserVersion = newUserVersions[i];
            if (!(oldUserVersion instanceof Comparable) || !(newUserVersion instanceof Comparable)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "old version and new version are not comparable: " + oldUserVersion.getClass() + " vs " + newUserVersion.getClass());
            }
            try {
                boolean passes = this.newUpdateComparePasses((Comparable)newUserVersion, (Comparable)oldUserVersion, this.versionFieldNames[i]);
                if (!passes) continue;
                return true;
            }
            catch (ClassCastException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "old version and new version are not comparable: " + oldUserVersion.getClass() + " vs " + newUserVersion.getClass() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.ignoreOldUpdates) {
            if (log.isDebugEnabled()) {
                log.debug("Dropping update since user version is not high enough: {}; old user version={}", (Object)Arrays.toString(newUserVersions), (Object)Arrays.toString(oldUserVersions));
            }
            return false;
        }
        throw new SolrException(SolrException.ErrorCode.CONFLICT, "user version is not high enough: " + Arrays.toString(newUserVersions));
    }

    protected <T extends Comparable<? super T>> boolean newUpdateComparePasses(T newUserVersion, T oldUserVersion, String userVersionFieldName) {
        return oldUserVersion.compareTo(newUserVersion) < 0;
    }

    private static Object[] getObjectValues(LeafReaderContext segmentContext, SchemaField[] fields, SolrIndexSearcher searcher, int docIdInSegment) throws IOException {
        FunctionValues[] functionValues = DocBasedVersionConstraintsProcessor.getManyFunctionValues(segmentContext, fields, searcher);
        Object[] objectValues = new Object[functionValues.length];
        for (int i = 0; i < functionValues.length; ++i) {
            objectValues[i] = functionValues[i].objectVal(docIdInSegment);
        }
        return objectValues;
    }

    private static FunctionValues[] getManyFunctionValues(LeafReaderContext segmentContext, SchemaField[] fields, SolrIndexSearcher searcher) throws IOException {
        FunctionValues[] values = new FunctionValues[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = DocBasedVersionConstraintsProcessor.getFunctionValues(segmentContext, fields[i], searcher);
        }
        return values;
    }

    private static FunctionValues getFunctionValues(LeafReaderContext segmentContext, SchemaField field, SolrIndexSearcher searcher) throws IOException {
        ValueSource vs = field.getType().getValueSource(field, null);
        Map context = ValueSource.newContext((IndexSearcher)searcher);
        vs.createWeight(context, (IndexSearcher)searcher);
        return vs.getValues(context, segmentContext);
    }

    private boolean isNotLeader(UpdateCommand cmd) {
        if ((cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
            return true;
        }
        if (this.phase == DistributedUpdateProcessor.DistribPhase.FROMLEADER) {
            return true;
        }
        this.distribProc.setupRequest(cmd);
        return !this.distribProc.isLeader();
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        if (this.isNotLeader(cmd)) {
            super.processAdd(cmd);
            return;
        }
        SolrInputDocument newDoc = cmd.getSolrInputDocument();
        Object[] newVersions = this.getUserVersionsFromDocument(newDoc);
        this.validateUserVersions(newVersions, this.versionFieldNames, "Doc does not have versionField: ");
        int i = 0;
        while (true) {
            DocBasedVersionConstraintsProcessor.logOverlyFailedRetries(i, cmd);
            if (!this.isVersionNewEnough(cmd.getIndexedId(), newVersions)) {
                return;
            }
            try {
                cmd.setVersion(this.oldSolrVersion);
                super.processAdd(cmd);
                return;
            }
            catch (SolrException e) {
                if (e.code() != 409) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private static void logOverlyFailedRetries(int i, UpdateCommand cmd) {
        if ((i & 0xFF) == 255) {
            log.warn("Unusual number of optimistic concurrency retries: retries={} cmd={}", (Object)i, (Object)cmd);
        }
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (this.deleteVersionParamNames.length == 0) {
            super.processDelete(cmd);
            return;
        }
        if (!cmd.isDeleteById()) {
            super.processDelete(cmd);
            return;
        }
        Object[] deleteParamValues = this.getDeleteParamValuesFromRequest(cmd);
        this.validateDeleteParamValues((String[])deleteParamValues);
        if (this.isNotLeader(cmd)) {
            SolrInputDocument newDoc = this.createTombstoneDocument(this.core.getLatestSchema(), cmd.getId(), this.versionFieldNames, (String[])deleteParamValues, this.tombstoneConfig);
            AddUpdateCommand newCmd = new AddUpdateCommand(cmd.getReq());
            newCmd.solrDoc = newDoc;
            newCmd.commitWithin = cmd.commitWithin;
            super.processAdd(newCmd);
            return;
        }
        int i = 0;
        while (true) {
            DocBasedVersionConstraintsProcessor.logOverlyFailedRetries(i, cmd);
            if (!this.isVersionNewEnough(cmd.getIndexedId(), deleteParamValues)) {
                return;
            }
            try {
                SolrInputDocument newDoc = this.createTombstoneDocument(this.core.getLatestSchema(), cmd.getId(), this.versionFieldNames, (String[])deleteParamValues, this.tombstoneConfig);
                AddUpdateCommand newCmd = new AddUpdateCommand(cmd.getReq());
                newCmd.solrDoc = newDoc;
                newCmd.commitWithin = cmd.commitWithin;
                newCmd.setVersion(this.oldSolrVersion);
                super.processAdd(newCmd);
                return;
            }
            catch (SolrException e) {
                if (e.code() != 409) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    protected SolrInputDocument createTombstoneDocument(IndexSchema schema, String id, String[] versionFieldNames, String[] deleteParamValues, NamedList<Object> tombstoneConfig) {
        SolrInputDocument newDoc = new SolrInputDocument();
        if (tombstoneConfig != null) {
            tombstoneConfig.forEach((k, v) -> newDoc.addField(k, v));
        }
        newDoc.setField(schema.getUniqueKeyField().getName(), (Object)id);
        DocBasedVersionConstraintsProcessor.setDeleteParamValues(newDoc, versionFieldNames, deleteParamValues);
        return newDoc;
    }

    private String[] getDeleteParamValuesFromRequest(DeleteUpdateCommand cmd) {
        SolrParams params = cmd.getReq().getParams();
        String[] returnArr = new String[this.deleteVersionParamNames.length];
        for (int i = 0; i < this.deleteVersionParamNames.length; ++i) {
            String deleteParamValue;
            String deleteVersionParamName = this.deleteVersionParamNames[i];
            returnArr[i] = deleteParamValue = params.get(deleteVersionParamName);
        }
        return returnArr;
    }

    private void validateDeleteParamValues(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            String deleteParamValue = values[i];
            if (null != deleteParamValue) continue;
            String deleteVersionParamName = this.deleteVersionParamNames[i];
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Delete by ID must specify doc version param: " + deleteVersionParamName);
        }
    }

    private static void setDeleteParamValues(SolrInputDocument doc, String[] versionFieldNames, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            String versionFieldName = versionFieldNames[i];
            String value = values[i];
            doc.setField(versionFieldName, (Object)value);
        }
    }

    private static final class DocFoundAndOldUserAndSolrVersions {
        private static final DocFoundAndOldUserAndSolrVersions NOT_FOUND = new DocFoundAndOldUserAndSolrVersions();
        private final boolean found;
        private final Object[] oldUserVersions;
        private final long oldSolrVersion;

        private DocFoundAndOldUserAndSolrVersions() {
            this.found = false;
            this.oldSolrVersion = -1L;
            this.oldUserVersions = null;
        }

        private DocFoundAndOldUserAndSolrVersions(Object[] oldUserVersions, long oldSolrVersion) {
            this.found = true;
            this.oldUserVersions = oldUserVersions;
            this.oldSolrVersion = oldSolrVersion;
        }
    }
}

