/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.facet.AggUtil;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.ReadOnlyCountSlotAcc;

public abstract class SlotAcc
implements Closeable {
    String key;
    protected final FacetContext fcontext;
    protected LeafReaderContext currentReaderContext;
    protected int currentDocBase;
    static final CountSlotAcc DEV_NULL_SLOT_ACC = new CountSlotAcc(null){

        @Override
        public void resize(Resizer resizer) {
        }

        @Override
        public void reset() throws IOException {
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotContext> slotContext) throws IOException {
        }

        @Override
        public void incrementCount(int slot, long count) {
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
        }

        @Override
        public int collect(DocSet docs, int slot, IntFunction<SlotContext> slotContext) throws IOException {
            return docs.size();
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public int compare(int slotA, int slotB) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public long getCount(int slot) {
            throw new UnsupportedOperationException("not supported");
        }
    };

    public SlotAcc(FacetContext fcontext) {
        this.fcontext = fcontext;
    }

    public String toString() {
        return this.key;
    }

    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        LeafReaderContext lastReaderContext = this.currentReaderContext;
        this.currentReaderContext = readerContext;
        this.currentDocBase = this.currentReaderContext.docBase;
        if (lastReaderContext == null || lastReaderContext.ord >= this.currentReaderContext.ord) {
            this.resetIterators();
        }
    }

    public abstract void collect(int var1, int var2, IntFunction<SlotContext> var3) throws IOException;

    public int collect(DocSet docs, int slot, IntFunction<SlotContext> slotContext) throws IOException {
        int count = 0;
        SolrIndexSearcher searcher = this.fcontext.searcher;
        List leaves = searcher.getIndexReader().leaves();
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        int segBase = 0;
        int adjustedMax = 0;
        DocIterator docsIt = docs.iterator();
        while (docsIt.hasNext()) {
            int doc = docsIt.nextDoc();
            if (doc >= adjustedMax) {
                int segMax;
                do {
                    if ((ctx = (LeafReaderContext)ctxIt.next()) != null) continue;
                    throw new RuntimeException("INTERNAL FACET ERROR");
                } while (doc >= (adjustedMax = (segBase = ctx.docBase) + (segMax = ctx.reader().maxDoc())));
                assert (doc >= ctx.docBase);
                this.setNextReader(ctx);
            }
            ++count;
            this.collect(doc - segBase, slot, slotContext);
        }
        return count;
    }

    public abstract int compare(int var1, int var2);

    public abstract Object getValue(int var1) throws IOException;

    public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
        if (this.key == null) {
            return;
        }
        Object val = this.getValue(slotNum);
        if (val != null) {
            bucket.add(this.key, val);
        }
    }

    public abstract void reset() throws IOException;

    protected void resetIterators() throws IOException {
    }

    public abstract void resize(Resizer var1);

    @Override
    public void close() throws IOException {
    }

    static class SortSlotAcc
    extends SlotAcc {
        public SortSlotAcc(FacetContext fcontext) {
            super(fcontext);
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotContext> slotContext) throws IOException {
        }

        @Override
        public int compare(int slotA, int slotB) {
            return slotA - slotB;
        }

        @Override
        public Object getValue(int slotNum) {
            return slotNum;
        }

        @Override
        public void reset() {
        }

        @Override
        public void resize(Resizer resizer) {
            throw new UnsupportedOperationException();
        }
    }

    static class CountSlotArrAcc
    extends CountSlotAcc {
        long[] result;

        public CountSlotArrAcc(FacetContext fcontext, int numSlots) {
            super(fcontext);
            this.result = new long[numSlots];
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotContext> slotContext) {
            int n = slotNum;
            this.result[n] = this.result[n] + 1L;
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Long.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            return this.result[slotNum];
        }

        @Override
        public void incrementCount(int slot, long count) {
            int n = slot;
            this.result[n] = this.result[n] + count;
        }

        @Override
        public long getCount(int slot) {
            return this.result[slot];
        }

        long[] getCountArray() {
            return this.result;
        }

        @Override
        public void reset() {
            Arrays.fill(this.result, 0L);
        }

        @Override
        public void resize(Resizer resizer) {
            this.result = resizer.resize(this.result, 0L);
        }
    }

    static abstract class CountSlotAcc
    extends SlotAcc
    implements ReadOnlyCountSlotAcc {
        public CountSlotAcc(FacetContext fcontext) {
            super(fcontext);
            this.key = "count";
        }

        public abstract void incrementCount(int var1, long var2);

        @Override
        public abstract long getCount(int var1);
    }

    static class SweepingCountSlotAcc
    extends CountSlotArrAcc {
        static final String SWEEP_COLLECTION_DEBUG_KEY = "sweep_collection";
        private final SimpleOrderedMap<Object> debug;
        private final FacetFieldProcessor p;
        final SweepCountAccStruct base;
        final List<SweepCountAccStruct> others = new ArrayList<SweepCountAccStruct>();
        private final List<SlotAcc> output = new ArrayList<SlotAcc>();

        SweepingCountSlotAcc(int numSlots, FacetFieldProcessor p) {
            super(p.fcontext, numSlots);
            this.p = p;
            this.base = new SweepCountAccStruct(this.fcontext.base, true, this);
            FacetDebugInfo fdebug = this.fcontext.getDebugInfo();
            SimpleOrderedMap simpleOrderedMap = this.debug = null != fdebug ? new SimpleOrderedMap() : null;
            if (null != this.debug) {
                fdebug.putInfoItem(SWEEP_COLLECTION_DEBUG_KEY, this.debug);
                this.debug.add("base", (Object)this.key);
                this.debug.add("accs", new ArrayList());
                this.debug.add("mapped", new ArrayList());
            }
        }

        public ReadOnlyCountSlotAcc add(String key, DocSet docs, int numSlots) {
            CountSlotArrAcc count = new CountSlotArrAcc(this.fcontext, numSlots);
            count.key = key;
            SweepCountAccStruct ret = new SweepCountAccStruct(docs, false, count);
            if (null != this.debug) {
                List accsDebug = (List)this.debug.get("accs");
                accsDebug.add(ret.toString());
            }
            this.others.add(ret);
            return ret.roCountAcc();
        }

        public void registerMapping(SlotAcc fromAcc, SlotAcc toAcc) {
            assert (fromAcc.key.equals(toAcc.key));
            this.output.add(toAcc);
            if (this.p.sortAcc == fromAcc) {
                this.p.sortAcc = toAcc;
            }
            if (null != this.debug) {
                List mappedDebug = (List)this.debug.get("mapped");
                mappedDebug.add(fromAcc.toString());
            }
        }

        @Override
        public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
            super.setValues(bucket, slotNum);
            if (0L < this.getCount(slotNum) || ((FacetRequest)this.fcontext.processor.freq).processEmpty) {
                this.setSweepValues(bucket, slotNum);
            }
        }

        public void setSweepValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
            for (SlotAcc acc : this.output) {
                acc.setValues(bucket, slotNum);
            }
        }

        public static SweepCountAccStruct baseStructOf(FacetProcessor<?> processor) {
            if (processor.countAcc instanceof SweepingCountSlotAcc) {
                return ((SweepingCountSlotAcc)processor.countAcc).base;
            }
            return new SweepCountAccStruct(processor.fcontext.base, true, processor.countAcc);
        }

        public static List<SweepCountAccStruct> otherStructsOf(FacetProcessor<?> processor) {
            if (processor.countAcc instanceof SweepingCountSlotAcc) {
                return ((SweepingCountSlotAcc)processor.countAcc).others;
            }
            return Collections.emptyList();
        }
    }

    static final class SweepCountAccStruct {
        final DocSet docSet;
        final boolean isBase;
        final CountSlotAcc countAcc;

        public SweepCountAccStruct(DocSet docSet, boolean isBase, CountSlotAcc countAcc) {
            this.docSet = docSet;
            this.isBase = isBase;
            this.countAcc = countAcc;
        }

        public SweepCountAccStruct(SweepCountAccStruct t, DocSet replaceDocSet) {
            this.docSet = replaceDocSet;
            this.isBase = t.isBase;
            this.countAcc = t.countAcc;
        }

        public ReadOnlyCountSlotAcc roCountAcc() {
            return this.countAcc;
        }

        public String toString() {
            return this.countAcc.toString();
        }
    }

    static interface SweepableSlotAcc<T extends SlotAcc> {
        public T registerSweepingAccs(SweepingCountSlotAcc var1);
    }

    static class StddevSlotAcc
    extends DoubleFuncSlotAcc {
        int[] counts;
        double[] sum;

        public StddevSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots);
            this.counts = new int[numSlots];
            this.sum = new double[numSlots];
        }

        @Override
        public void reset() {
            super.reset();
            Arrays.fill(this.counts, 0);
            Arrays.fill(this.sum, 0.0);
        }

        @Override
        public void resize(Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
            this.result = resizer.resize(this.result, 0.0);
        }

        private double stdDev(int slot) {
            return AggUtil.stdDev(this.result[slot], this.sum[slot], this.counts[slot]);
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.stdDev(slotA), this.stdDev(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(3);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                lst.add(this.sum[slot]);
                return lst;
            }
            return this.stdDev(slot);
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotContext> slotContext) throws IOException {
            double val = this.values.doubleVal(doc);
            if (this.values.exists(doc)) {
                int n = slot;
                this.counts[n] = this.counts[n] + 1;
                int n2 = slot;
                this.result[n2] = this.result[n2] + val * val;
                int n3 = slot;
                this.sum[n3] = this.sum[n3] + val;
            }
        }
    }

    static class VarianceSlotAcc
    extends DoubleFuncSlotAcc {
        int[] counts;
        double[] sum;

        public VarianceSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots);
            this.counts = new int[numSlots];
            this.sum = new double[numSlots];
        }

        @Override
        public void reset() {
            super.reset();
            Arrays.fill(this.counts, 0);
            Arrays.fill(this.sum, 0.0);
        }

        @Override
        public void resize(Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
            this.sum = resizer.resize(this.sum, 0.0);
        }

        private double variance(int slot) {
            return AggUtil.variance(this.result[slot], this.sum[slot], this.counts[slot]);
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.variance(slotA), this.variance(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(3);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                lst.add(this.sum[slot]);
                return lst;
            }
            return this.variance(slot);
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotContext> slotContext) throws IOException {
            double val = this.values.doubleVal(doc);
            if (this.values.exists(doc)) {
                int n = slot;
                this.counts[n] = this.counts[n] + 1;
                int n2 = slot;
                this.result[n2] = this.result[n2] + val * val;
                int n3 = slot;
                this.sum[n3] = this.sum[n3] + val;
            }
        }
    }

    static class AvgSlotAcc
    extends DoubleFuncSlotAcc {
        int[] counts;

        public AvgSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots);
            this.counts = new int[numSlots];
        }

        @Override
        public void reset() {
            super.reset();
            for (int i = 0; i < this.counts.length; ++i) {
                this.counts[i] = 0;
            }
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotContext> slotContext) throws IOException {
            double val = this.values.doubleVal(doc);
            if (val != 0.0 || this.values.exists(doc)) {
                int n = slotNum;
                this.result[n] = this.result[n] + val;
                int n2 = slotNum;
                this.counts[n2] = this.counts[n2] + 1;
            }
        }

        private double avg(int slot) {
            return AggUtil.avg(this.result[slot], this.counts[slot]);
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.avg(slotA), this.avg(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(2);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                return lst;
            }
            return this.avg(slot);
        }

        @Override
        public void resize(Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
        }
    }

    static class SumsqSlotAcc
    extends DoubleFuncSlotAcc {
        public SumsqSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots);
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotContext> slotContext) throws IOException {
            double val = this.values.doubleVal(doc);
            val *= val;
            int n = slotNum;
            this.result[n] = this.result[n] + val;
        }
    }

    static class SumSlotAcc
    extends DoubleFuncSlotAcc {
        public SumSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots);
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotContext> slotContext) throws IOException {
            double val = this.values.doubleVal(doc);
            int n = slotNum;
            this.result[n] = this.result[n] + val;
        }
    }

    public static abstract class IntSlotAcc
    extends SlotAcc {
        protected int[] result;
        protected int initialValue;

        public IntSlotAcc(FacetContext fcontext, int numSlots, int initialValue) {
            super(fcontext);
            this.initialValue = initialValue;
            this.result = new int[numSlots];
            if (initialValue != 0) {
                this.reset();
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Integer.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slot) {
            return this.result[slot];
        }

        @Override
        public void reset() {
            Arrays.fill(this.result, this.initialValue);
        }

        @Override
        public void resize(Resizer resizer) {
            this.result = resizer.resize(this.result, this.initialValue);
        }
    }

    public static abstract class LongFuncSlotAcc
    extends FuncSlotAcc {
        protected long[] result;
        protected long initialValue;

        public LongFuncSlotAcc(ValueSource values, FacetContext fcontext, int numSlots, long initialValue) {
            super(values, fcontext, numSlots);
            this.initialValue = initialValue;
            this.result = new long[numSlots];
            if (initialValue != 0L) {
                this.reset();
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Long.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slot) {
            return this.result[slot];
        }

        @Override
        public void reset() {
            Arrays.fill(this.result, this.initialValue);
        }

        @Override
        public void resize(Resizer resizer) {
            this.result = resizer.resize(this.result, this.initialValue);
        }
    }

    public static abstract class DoubleFuncSlotAcc
    extends FuncSlotAcc {
        protected double[] result;
        protected double initialValue;

        public DoubleFuncSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            this(values, fcontext, numSlots, 0.0);
        }

        public DoubleFuncSlotAcc(ValueSource values, FacetContext fcontext, int numSlots, double initialValue) {
            super(values, fcontext, numSlots);
            this.initialValue = initialValue;
            this.result = new double[numSlots];
            if (initialValue != 0.0) {
                this.reset();
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slot) {
            return this.result[slot];
        }

        @Override
        public void reset() {
            Arrays.fill(this.result, this.initialValue);
        }

        @Override
        public void resize(Resizer resizer) {
            this.result = resizer.resize(this.result, this.initialValue);
        }
    }

    public static abstract class FuncSlotAcc
    extends SlotAcc {
        protected final ValueSource valueSource;
        protected FunctionValues values;

        public FuncSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(fcontext);
            this.valueSource = values;
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = this.valueSource.getValues((Map)this.fcontext.qcontext, readerContext);
        }
    }

    public static class SlotContext {
        private final Query slotQuery;

        public SlotContext(Query slotQuery) {
            this.slotQuery = slotQuery;
        }

        public Query getSlotQuery() {
            return this.slotQuery;
        }

        public boolean isAllBuckets() {
            return false;
        }
    }

    public static abstract class Resizer {
        public abstract int getNewSize();

        public abstract int getNewSlot(int var1);

        public double[] resize(double[] old, double defaultValue) {
            double[] values = new double[this.getNewSize()];
            if (defaultValue != 0.0) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                double val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }

        public int[] resize(int[] old, int defaultValue) {
            int[] values = new int[this.getNewSize()];
            if (defaultValue != 0) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                int val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }

        public long[] resize(long[] old, long defaultValue) {
            long[] values = new long[this.getNewSize()];
            if (defaultValue != 0L) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                long val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }

        public FixedBitSet resize(FixedBitSet old) {
            FixedBitSet values = new FixedBitSet(this.getNewSize());
            int oldSize = old.length();
            int oldSlot = 0;
            while ((oldSlot = values.nextSetBit(oldSlot)) != Integer.MAX_VALUE) {
                int newSlot = this.getNewSlot(oldSlot);
                values.set(newSlot);
                if (++oldSlot < oldSize) continue;
                break;
            }
            return values;
        }

        public <T> T[] resize(T[] old, T defaultValue) {
            Object[] values = (Object[])Array.newInstance(old.getClass().getComponentType(), this.getNewSize());
            if (defaultValue != null) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                T val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }
    }
}

