/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class RandomSortField
extends FieldType {
    private static FieldComparatorSource randomComparatorSource = new FieldComparatorSource(){

        public FieldComparator<Integer> newComparator(final String fieldname, final int numHits, int sortPos, boolean reversed) {
            return new SimpleFieldComparator<Integer>(){
                int seed;
                private final int[] values;
                int bottomVal;
                int topVal;
                {
                    this.values = new int[numHits];
                }

                public int compare(int slot1, int slot2) {
                    return this.values[slot1] - this.values[slot2];
                }

                public void setBottom(int slot) {
                    this.bottomVal = this.values[slot];
                }

                public void setTopValue(Integer value) {
                    this.topVal = value;
                }

                public int compareBottom(int doc) {
                    return this.bottomVal - RandomSortField.hash(doc + this.seed);
                }

                public void copy(int slot, int doc) {
                    this.values[slot] = RandomSortField.hash(doc + this.seed);
                }

                protected void doSetNextReader(LeafReaderContext context) {
                    this.seed = RandomSortField.getSeed(fieldname, context);
                }

                public Integer value(int slot) {
                    return this.values[slot];
                }

                public int compareTop(int doc) {
                    return this.topVal - RandomSortField.hash(doc + this.seed);
                }
            };
        }
    };

    private static int hash(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key >>> 1;
    }

    private static int getSeed(String fieldName, LeafReaderContext context) {
        DirectoryReader top = (DirectoryReader)ReaderUtil.getTopLevelContext((IndexReaderContext)context).reader();
        return fieldName.hashCode() + context.docBase + (int)top.getVersion();
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return new SortField(field.getName(), randomComparatorSource, reverse);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        return new RandomValueSource(field.getName());
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
    }

    public static class RandomValueSource
    extends ValueSource {
        private final String field;

        public RandomValueSource(String field) {
            this.field = field;
        }

        public String description() {
            return this.field;
        }

        public FunctionValues getValues(Map<Object, Object> context, final LeafReaderContext readerContext) throws IOException {
            return new IntDocValues(this){
                private final int seed;
                {
                    super(arg0);
                    this.seed = RandomSortField.getSeed(field, readerContext);
                }

                public int intVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }
            };
        }

        public boolean equals(Object o) {
            if (!(o instanceof RandomValueSource)) {
                return false;
            }
            RandomValueSource other = (RandomValueSource)((Object)o);
            return this.field.equals(other.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }
    }
}

