/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.TaskManagementHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class ActiveTasksListHandler
extends TaskManagementHandler {
    private List<SearchComponent> components;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        HashMap<String, String> extraParams = null;
        ResponseBuilder rb = ActiveTasksListHandler.buildResponseBuilder(req, rsp, this.getComponentsList());
        rb.setIsTaskListRequest(true);
        String taskStatusCheckUUID = req.getParams().get("taskUUID", null);
        if (taskStatusCheckUUID != null) {
            if (rb.isDistrib) {
                extraParams = new HashMap<String, String>();
                extraParams.put("taskUUID", taskStatusCheckUUID);
            }
            rb.setTaskStatusCheckUUID(taskStatusCheckUUID);
        }
        this.processRequest(req, rb, extraParams);
    }

    @Override
    public String getDescription() {
        return "activetaskslist";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public SolrRequestHandler getSubHandler(String path) {
        if (path.startsWith("/tasks/list")) {
            return this;
        }
        return null;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Api> getApis() {
        return ApiBag.wrapRequestHandlers(this, "core.tasks.list");
    }

    private List<SearchComponent> getComponentsList() {
        if (this.components == null) {
            this.components = ActiveTasksListHandler.buildComponentsList();
        }
        return this.components;
    }
}

