/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90Codec;
import org.apache.lucene.codecs.lucene90.Lucene90HnswVectorsFormat;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCodecFactory
extends CodecFactory
implements SolrCoreAware {
    public static final String COMPRESSION_MODE = "compressionMode";
    public static final Lucene90Codec.Mode SOLR_DEFAULT_COMPRESSION_MODE = Lucene90Codec.Mode.BEST_SPEED;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Codec codec;
    private volatile SolrCore core;

    @Override
    public void inform(SolrCore core) {
        this.core = core;
    }

    @Override
    public void init(NamedList<?> args) {
        Lucene90Codec.Mode compressionMode;
        super.init(args);
        assert (this.codec == null);
        String compressionModeStr = (String)args.get(COMPRESSION_MODE);
        if (compressionModeStr != null) {
            try {
                compressionMode = Lucene90Codec.Mode.valueOf((String)compressionModeStr.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid compressionMode: '" + compressionModeStr + "'. Value must be one of " + Arrays.toString(Lucene90Codec.Mode.values()));
            }
            log.debug("Using compressionMode: {}", (Object)compressionMode);
        } else {
            compressionMode = SOLR_DEFAULT_COMPRESSION_MODE;
            log.debug("Using default compressionMode: {}", (Object)compressionMode);
        }
        this.codec = new Lucene90Codec(compressionMode){

            public PostingsFormat getPostingsFormatForField(String field) {
                String postingsFormatName;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                if (schemaField != null && (postingsFormatName = schemaField.getType().getPostingsFormat()) != null) {
                    return PostingsFormat.forName((String)postingsFormatName);
                }
                return super.getPostingsFormatForField(field);
            }

            public DocValuesFormat getDocValuesFormatForField(String field) {
                String docValuesFormatName;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                if (schemaField != null && (docValuesFormatName = schemaField.getType().getDocValuesFormat()) != null) {
                    return DocValuesFormat.forName((String)docValuesFormatName);
                }
                return super.getDocValuesFormatForField(field);
            }

            public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
                DenseVectorField vectorType;
                String knnVectorFormatName;
                FieldType fieldType;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                FieldType fieldType2 = fieldType = schemaField == null ? null : schemaField.getType();
                if (fieldType instanceof DenseVectorField && (knnVectorFormatName = (vectorType = (DenseVectorField)fieldType).getCodecFormat()) != null) {
                    if (knnVectorFormatName.equals(Lucene90HnswVectorsFormat.class.getSimpleName())) {
                        int maxConn = vectorType.getHnswMaxConn();
                        int beamWidth = vectorType.getHnswBeamWidth();
                        return new Lucene90HnswVectorsFormat(maxConn, beamWidth);
                    }
                    return KnnVectorsFormat.forName((String)knnVectorFormatName);
                }
                return super.getKnnVectorsFormatForField(field);
            }
        };
    }

    @Override
    public Codec getCodec() {
        assert (this.core != null) : "inform must be called first";
        return this.codec;
    }
}

