/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SolrZkClient zkClient;

    public NodeMutator(SolrCloudManager cloudManager) {
        this.zkClient = SliceMutator.getZkClient(cloudManager);
    }

    public List<ZkWriteCommand> downNode(ClusterState clusterState, ZkNodeProps message) {
        String nodeName = message.getStr("node_name");
        log.debug("DownNode state invoked for node: {}", (Object)nodeName);
        ArrayList<ZkWriteCommand> zkWriteCommands = new ArrayList<ZkWriteCommand>();
        Map collections = clusterState.getCollectionsMap();
        for (Map.Entry entry : collections.entrySet()) {
            DocCollection docCollection;
            String collectionName = (String)entry.getKey();
            Optional<ZkWriteCommand> zkWriteCommand = NodeMutator.computeCollectionUpdate(nodeName, collectionName, docCollection = (DocCollection)entry.getValue(), this.zkClient);
            if (!zkWriteCommand.isPresent()) continue;
            zkWriteCommands.add(zkWriteCommand.get());
        }
        return zkWriteCommands;
    }

    public static Optional<ZkWriteCommand> computeCollectionUpdate(String nodeName, String collectionName, DocCollection docCollection, SolrZkClient client) {
        boolean needToUpdateCollection = false;
        ArrayList<String> downedReplicas = new ArrayList<String>();
        LinkedHashMap slicesCopy = new LinkedHashMap(docCollection.getSlicesMap());
        for (Map.Entry entry : slicesCopy.entrySet()) {
            Slice slice = (Slice)entry.getValue();
            Map newReplicas = slice.getReplicasCopy();
            Collection replicas = slice.getReplicas();
            for (Replica replica : replicas) {
                String rNodeName = replica.getNodeName();
                if (rNodeName == null) {
                    throw new RuntimeException("Replica without node name! " + replica);
                }
                if (!rNodeName.equals(nodeName)) continue;
                log.debug("Update replica state for {} to {}", (Object)replica, (Object)Replica.State.DOWN);
                Map props = replica.shallowCopy();
                Replica newReplica = new Replica(replica.getName(), replica.node, replica.collection, slice.getName(), replica.core, Replica.State.DOWN, replica.type, props);
                newReplicas.put(replica.getName(), newReplica);
                needToUpdateCollection = true;
                downedReplicas.add(replica.getName());
            }
            Slice newSlice = new Slice(slice.getName(), newReplicas, slice.shallowCopy(), collectionName);
            entry.setValue(newSlice);
        }
        if (needToUpdateCollection) {
            if (docCollection.isPerReplicaState()) {
                PerReplicaStates prs = client == null ? docCollection.getPerReplicaStates() : PerReplicaStates.fetch((String)docCollection.getZNode(), (SolrZkClient)client, (PerReplicaStates)docCollection.getPerReplicaStates());
                return Optional.of(new ZkWriteCommand(collectionName, docCollection.copyWithSlices(slicesCopy), PerReplicaStatesOps.downReplicas(downedReplicas, (PerReplicaStates)prs), false));
            }
            return Optional.of(new ZkWriteCommand(collectionName, docCollection.copyWithSlices(slicesCopy)));
        }
        return Optional.empty();
    }
}

