/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrResourceNotFoundException;
import org.apache.solr.schema.ZkIndexSchemaReader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkSolrResourceLoader
extends SolrResourceLoader {
    private final String configSetZkPath;
    private ZkController zkController;
    private ZkIndexSchemaReader zkIndexSchemaReader;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkSolrResourceLoader(Path instanceDir, String configSet, ClassLoader parent, ZkController zooKeeperController) {
        super(instanceDir, parent);
        this.zkController = zooKeeperController;
        this.configSetZkPath = "/configs/" + configSet;
    }

    @Override
    public InputStream openResource(String resource) throws IOException {
        InputStream is;
        String file = ".".equals(resource) ? this.configSetZkPath : this.configSetZkPath + "/" + resource;
        int maxTries = 10;
        KeeperException.SessionExpiredException exception = null;
        while (maxTries-- > 0) {
            try {
                if (this.zkController.pathExists(file)) {
                    Stat stat = new Stat();
                    byte[] bytes = this.zkController.getZkClient().getData(file, null, stat, true);
                    return new ZkByteArrayInputStream(bytes, file, stat);
                }
                break;
            }
            catch (KeeperException.SessionExpiredException e) {
                exception = e;
                if (this.zkController.getCoreContainer().isShutDown()) continue;
                try {
                    Thread.sleep(1000L);
                    log.debug("Sleeping for 1s before retrying fetching resource={}", (Object)resource);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Could not load resource=" + resource, ie);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Error opening " + file, e);
            }
            catch (Exception e) {
                throw new IOException("Error opening " + file, e);
            }
        }
        if (exception != null) {
            throw new IOException("We re-tried 10 times but was still unable to fetch resource=" + resource + " from ZK", exception);
        }
        try {
            is = this.classLoader.getResourceAsStream(resource.replace(File.separatorChar, '/'));
        }
        catch (Exception e) {
            throw new IOException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new SolrResourceNotFoundException("Can't find resource '" + resource + "' in classpath or '" + this.configSetZkPath + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    @Override
    public String getConfigDir() {
        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "ZkSolrResourceLoader does not support getConfigDir() - likely, what you are trying to do is not supported in ZooKeeper mode");
    }

    public String getConfigSetZkPath() {
        return this.configSetZkPath;
    }

    public ZkController getZkController() {
        return this.zkController;
    }

    public void setZkIndexSchemaReader(ZkIndexSchemaReader zkIndexSchemaReader) {
        this.zkIndexSchemaReader = zkIndexSchemaReader;
    }

    public ZkIndexSchemaReader getZkIndexSchemaReader() {
        return this.zkIndexSchemaReader;
    }

    @Override
    public CoreContainer getCoreContainer() {
        return this.zkController.getCoreContainer();
    }

    public static class ZkByteArrayInputStream
    extends ByteArrayInputStream {
        public final String fileName;
        private final Stat stat;

        public ZkByteArrayInputStream(byte[] buf, String fileName, Stat stat) {
            super(buf);
            this.fileName = fileName;
            this.stat = stat;
        }

        public Stat getStat() {
            return this.stat;
        }
    }
}

