/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.ActionThrottle;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardLeaderElectionContext
extends ShardLeaderElectionContextBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer cc;
    private final SyncStrategy syncStrategy;
    private final DistributedClusterStateUpdater distributedClusterStateUpdater;
    private volatile boolean isClosed = false;

    public ShardLeaderElectionContext(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkController zkController, CoreContainer cc) {
        super(leaderElector, shardId, collection, coreNodeName, props, zkController);
        this.cc = cc;
        this.syncStrategy = new SyncStrategy(cc);
        this.distributedClusterStateUpdater = zkController.getDistributedClusterStateUpdater();
    }

    @Override
    public void close() {
        super.close();
        this.isClosed = true;
        this.syncStrategy.close();
    }

    @Override
    public void cancelElection() throws InterruptedException, KeeperException {
        String coreName = this.leaderProps.getStr("core");
        try (SolrCore core = this.cc.getCore(coreName);){
            if (core != null) {
                core.getCoreDescriptor().getCloudDescriptor().setLeader(false);
            }
        }
        super.cancelElection();
    }

    @Override
    public ElectionContext copy() {
        return new ShardLeaderElectionContext(this.leaderElector, this.shardId, this.collection, this.id, this.leaderProps, this.zkController, this.cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStart) throws KeeperException, InterruptedException, IOException {
        ActionThrottle lt;
        String coreName = this.leaderProps.getStr("core");
        try (SolrCore core = this.cc.getCore(coreName);){
            if (core == null) {
                return;
            }
            MDCLoggingContext.setCore(core);
            lt = core.getUpdateHandler().getSolrCoreState().getLeaderThrottle();
        }
        try {
            lt.minimumWaitBetweenActions();
            lt.markAttemptingAction();
            int leaderVoteWait = this.cc.getZkController().getLeaderVoteWait();
            log.debug("Running the leader process for shard={} and weAreReplacement={} and leaderVoteWait={}", new Object[]{this.shardId, weAreReplacement, leaderVoteWait});
            if (this.zkController.getClusterState().getCollection(this.collection).getSlice(this.shardId).getReplicas().size() > 1) {
                ZkNodeProps m = new ZkNodeProps(new String[]{"operation", OverseerAction.LEADER.toLower(), "shard", this.shardId, "collection", this.collection});
                if (this.distributedClusterStateUpdater.isDistributedStateUpdate()) {
                    this.distributedClusterStateUpdater.doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.SliceSetShardLeader, m, this.zkController.getSolrCloudManager(), this.zkStateReader);
                } else {
                    this.zkController.getOverseer().getStateUpdateQueue().offer(Utils.toJSON((Object)m));
                }
            }
            if (!weAreReplacement) {
                this.waitForReplicasToComeUp(leaderVoteWait);
            } else {
                this.areAllReplicasParticipating();
            }
            if (this.isClosed) {
                return;
            }
            boolean setTermToMax = false;
            try (SolrCore core = this.cc.getCore(coreName);){
                if (core == null) {
                    return;
                }
                Replica.Type replicaType = core.getCoreDescriptor().getCloudDescriptor().getReplicaType();
                String coreNodeName = core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName();
                ZkShardTerms zkShardTerms = this.zkController.getShardTerms(this.collection, this.shardId);
                if (!zkShardTerms.registered(coreNodeName)) {
                }
                if (!zkShardTerms.canBecomeLeader(coreNodeName)) {
                    if (!this.waitForEligibleBecomeLeaderAfterTimeout(zkShardTerms, coreNodeName, leaderVoteWait)) {
                        this.rejoinLeaderElection(core);
                        return;
                    }
                    setTermToMax = true;
                }
            }
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    private boolean waitForEligibleBecomeLeaderAfterTimeout(ZkShardTerms zkShardTerms, String coreNodeName, int timeout) throws InterruptedException {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
        while (!this.isClosed && !this.cc.isShutDown()) {
            if (System.nanoTime() > timeoutAt) {
                log.warn("After waiting for {}ms, no other potential leader was found, {} try to become leader anyway (core_term:{}, highest_term:{})", new Object[]{timeout, coreNodeName, zkShardTerms.getTerm(coreNodeName), zkShardTerms.getHighestTerm()});
                return true;
            }
            if (this.replicasWithHigherTermParticipated(zkShardTerms, coreNodeName)) {
                log.info("Can't become leader, other replicas with higher term participated in leader election");
                return false;
            }
            Thread.sleep(500L);
        }
        return false;
    }

    private boolean replicasWithHigherTermParticipated(ZkShardTerms zkShardTerms, String coreNodeName) {
        Slice slices;
        ClusterState clusterState = this.zkController.getClusterState();
        DocCollection docCollection = clusterState.getCollectionOrNull(this.collection);
        Slice slice = slices = docCollection == null ? null : docCollection.getSlice(this.shardId);
        if (slices == null) {
            return false;
        }
        long replicaTerm = zkShardTerms.getTerm(coreNodeName);
        boolean isRecovering = zkShardTerms.isRecovering(coreNodeName);
        for (Replica replica : slices.getReplicas()) {
            if (replica.getName().equals(coreNodeName) || !clusterState.getLiveNodes().contains(replica.getNodeName())) continue;
            long otherTerm = zkShardTerms.getTerm(replica.getName());
            boolean isOtherReplicaRecovering = zkShardTerms.isRecovering(replica.getName());
            if (isRecovering && !isOtherReplicaRecovering) {
                return true;
            }
            if (otherTerm <= replicaTerm) continue;
            return true;
        }
        return false;
    }

    public void publishActiveIfRegisteredAndNotActive(SolrCore core) throws Exception {
        if (core.getCoreDescriptor().getCloudDescriptor().hasRegistered()) {
            ZkStateReader zkStateReader = this.zkController.getZkStateReader();
            zkStateReader.forceUpdateCollection(this.collection);
            ClusterState clusterState = zkStateReader.getClusterState();
            Replica rep = this.getReplica(clusterState, this.collection, this.leaderProps.getStr("core_node_name"));
            if (rep == null) {
                return;
            }
            if (rep.getState() != Replica.State.ACTIVE || core.getCoreDescriptor().getCloudDescriptor().getLastPublished() != Replica.State.ACTIVE) {
                log.debug("We have become the leader after core registration but are not in an ACTIVE state - publishing ACTIVE");
                this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
            }
        }
    }

    private Replica getReplica(ClusterState clusterState, String collectionName, String replicaName) {
        if (clusterState == null) {
            return null;
        }
        DocCollection docCollection = clusterState.getCollectionOrNull(collectionName);
        if (docCollection == null) {
            return null;
        }
        return docCollection.getReplica(replicaName);
    }

    private boolean waitForReplicasToComeUp(int timeoutms) throws InterruptedException {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutms, TimeUnit.MILLISECONDS);
        String shardsElectZkPath = this.electionPath + "/election";
        DocCollection docCollection = this.zkController.getClusterState().getCollectionOrNull(this.collection);
        Slice slices = docCollection == null ? null : docCollection.getSlice(this.shardId);
        int cnt = 0;
        while (!this.isClosed && !this.cc.isShutDown()) {
            if (slices != null) {
                int found = 0;
                try {
                    found = this.zkClient.getChildren(shardsElectZkPath, null, true).size();
                }
                catch (KeeperException e) {
                    if (e instanceof KeeperException.SessionExpiredException) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ZK session expired - cancelling election for " + this.collection + " " + this.shardId);
                    }
                    SolrException.log((Logger)log, (String)"Error checking for the number of election participants", (Throwable)e);
                }
                if (found >= slices.getReplicas(EnumSet.of(Replica.Type.TLOG, Replica.Type.NRT)).size()) {
                    log.info("Enough replicas found to continue.");
                    return true;
                }
                if (cnt % 40 == 0 && log.isInfoEnabled()) {
                    log.info("Waiting until we see more replicas up for shard {}: total={} found={} timeoute in={}ms", new Object[]{this.shardId, slices.getReplicas(EnumSet.of(Replica.Type.TLOG, Replica.Type.NRT)).size(), found, TimeUnit.MILLISECONDS.convert(timeoutAt - System.nanoTime(), TimeUnit.NANOSECONDS)});
                }
                if (System.nanoTime() > timeoutAt) {
                    log.info("Was waiting for replicas to come up, but they are taking too long - assuming they won't come back till later");
                    return false;
                }
            } else {
                log.warn("Shard not found: {} for collection {}", (Object)this.shardId, (Object)this.collection);
                return false;
            }
            Thread.sleep(500L);
            docCollection = this.zkController.getClusterState().getCollectionOrNull(this.collection);
            slices = docCollection == null ? null : docCollection.getSlice(this.shardId);
            ++cnt;
        }
        return false;
    }

    private boolean areAllReplicasParticipating() throws InterruptedException {
        String shardsElectZkPath = this.electionPath + "/election";
        DocCollection docCollection = this.zkController.getClusterState().getCollectionOrNull(this.collection);
        if (docCollection != null && docCollection.getSlice(this.shardId) != null) {
            Slice slices = docCollection.getSlice(this.shardId);
            int found = 0;
            try {
                found = this.zkClient.getChildren(shardsElectZkPath, null, true).size();
            }
            catch (KeeperException e) {
                if (e instanceof KeeperException.SessionExpiredException) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ZK session expired - cancelling election for " + this.collection + " " + this.shardId);
                }
                SolrException.log((Logger)log, (String)"Error checking for the number of election participants", (Throwable)e);
            }
            if (found >= slices.getReplicasMap().size()) {
                log.debug("All replicas are ready to participate in election.");
                return true;
            }
        } else {
            log.warn("Shard not found: {} for collection {}", (Object)this.shardId, (Object)this.collection);
            return false;
        }
        return false;
    }

    private void rejoinLeaderElection(SolrCore core) throws InterruptedException, KeeperException, IOException {
        if (this.cc.isShutDown()) {
            log.debug("Not rejoining election because CoreContainer is closed");
            return;
        }
        log.info("There may be a better leader candidate than us - going back into recovery");
        this.cancelElection();
        core.getUpdateHandler().getSolrCoreState().doRecovery(this.cc, core.getCoreDescriptor());
        this.leaderElector.joinElection(this, true);
    }
}

