/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.Collections;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.ApiMapping;
import org.apache.solr.common.params.CoreAdminParams;

public class CoreApiMapping {

    public static enum EndPoint implements ApiMapping.V2EndPoint
    {
        PER_CORE_COMMANDS("cores.core.Commands");

        final String specName;

        private EndPoint(String specName) {
            this.specName = specName;
        }

        @Override
        public String getSpecName() {
            return this.specName;
        }
    }

    public static enum Meta implements ApiMapping.CommandMeta
    {
        UNLOAD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.UNLOAD, "unload", null),
        RELOAD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.RELOAD, "reload", null),
        SWAP(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.SWAP, "swap", Collections.singletonMap("other", "with")),
        RENAME(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.RENAME, "rename", Collections.singletonMap("other", "to")),
        MERGEINDEXES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.MERGEINDEXES, "merge-indexes", null),
        SPLIT(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.SPLIT, "split", Collections.singletonMap("split.key", "splitKey")),
        PREPRECOVERY(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.PREPRECOVERY, "prep-recovery", null),
        REQUESTRECOVERY(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REQUESTRECOVERY, "request-recovery", null),
        REQUESTSYNCSHARD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REQUESTSYNCSHARD, "request-sync-shard", null),
        REQUESTBUFFERUPDATES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES, "request-buffer-updates", null),
        REQUESTAPPLYUPDATES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES, "request-apply-updates", null),
        REQUESTSTATUS(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.GET, CoreAdminParams.CoreAdminAction.REQUESTSTATUS, "request-status", null);

        public final String commandName;
        public final EndPoint endPoint;
        public final SolrRequest.METHOD method;
        public final CoreAdminParams.CoreAdminAction action;
        public final Map<String, String> paramstoAttr;

        private Meta(EndPoint endPoint, SolrRequest.METHOD method, CoreAdminParams.CoreAdminAction action, String commandName, Map<String, String> paramstoAttr) {
            this.commandName = commandName;
            this.endPoint = endPoint;
            this.method = method;
            this.paramstoAttr = paramstoAttr == null ? Collections.emptyMap() : paramstoAttr;
            this.action = action;
        }

        @Override
        public String getName() {
            return this.commandName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public ApiMapping.V2EndPoint getEndPoint() {
            return this.endPoint;
        }

        @Override
        public String getParamSubstitute(String param) {
            return this.paramstoAttr.containsKey(param) ? this.paramstoAttr.get(param) : param;
        }
    }
}

