/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;

public class CloudHttp2SolrClient
extends CloudSolrClient {
    private final ClusterStateProvider stateProvider;
    private final LBHttp2SolrClient lbClient;
    private final Http2SolrClient myClient;
    private final boolean clientIsInternal;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CloudHttp2SolrClient(Builder builder) {
        super(builder.shardLeadersOnly, builder.parallelUpdates, builder.directUpdatesToLeadersOnly);
        if (builder.httpClient == null) {
            this.clientIsInternal = true;
            this.myClient = builder.internalClientBuilder == null ? new Http2SolrClient.Builder().build() : builder.internalClientBuilder.build();
        } else {
            this.clientIsInternal = false;
            this.myClient = builder.httpClient;
        }
        if (builder.stateProvider == null) {
            if (builder.zkHosts != null && builder.solrUrls != null) {
                throw new IllegalArgumentException("Both zkHost(s) & solrUrl(s) have been specified. Only specify one.");
            }
            if (builder.zkHosts != null) {
                this.stateProvider = new ZkClientClusterStateProvider(builder.zkHosts, builder.zkChroot);
            } else {
                if (builder.solrUrls == null || builder.solrUrls.isEmpty()) throw new IllegalArgumentException("Both zkHosts and solrUrl cannot be null.");
                try {
                    this.stateProvider = new Http2ClusterStateProvider(builder.solrUrls, builder.httpClient);
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't initialize a HttpClusterStateProvider (is/are the Solr server(s), " + builder.solrUrls + ", down?)", e);
                }
            }
        } else {
            this.stateProvider = builder.stateProvider;
        }
        this.lbClient = new LBHttp2SolrClient(this.myClient, new String[0]);
    }

    @Override
    public void close() throws IOException {
        this.stateProvider.close();
        this.lbClient.close();
        if (this.clientIsInternal && this.myClient != null) {
            this.myClient.close();
        }
        super.close();
    }

    @Override
    public LBHttp2SolrClient getLbClient() {
        return this.lbClient;
    }

    @Override
    public ClusterStateProvider getClusterStateProvider() {
        return this.stateProvider;
    }

    public Http2SolrClient getHttpClient() {
        return this.myClient;
    }

    @Override
    protected boolean wasCommError(Throwable rootCause) {
        return false;
    }

    public static class Builder {
        protected Collection<String> zkHosts = new ArrayList<String>();
        protected List<String> solrUrls = new ArrayList<String>();
        protected String zkChroot;
        protected Http2SolrClient httpClient;
        protected boolean shardLeadersOnly = true;
        protected boolean directUpdatesToLeadersOnly = false;
        protected boolean parallelUpdates = true;
        protected ClusterStateProvider stateProvider;
        protected Http2SolrClient.Builder internalClientBuilder;

        public Builder(List<String> solrUrls) {
            this.solrUrls = solrUrls;
        }

        public Builder(List<String> zkHosts, Optional<String> zkChroot) {
            this.zkHosts = zkHosts;
            if (zkChroot.isPresent()) {
                this.zkChroot = zkChroot.get();
            }
        }

        public Builder sendDirectUpdatesToShardLeadersOnly() {
            this.directUpdatesToLeadersOnly = true;
            return this;
        }

        public Builder sendDirectUpdatesToAnyShardReplica() {
            this.directUpdatesToLeadersOnly = false;
            return this;
        }

        public Builder withParallelUpdates(boolean parallelUpdates) {
            this.parallelUpdates = parallelUpdates;
            return this;
        }

        public Builder withHttpClient(Http2SolrClient httpClient) {
            if (this.internalClientBuilder != null) {
                throw new IllegalStateException("The builder can't accept an httpClient AND an internalClientBuilder, only one of those can be provided");
            }
            this.httpClient = httpClient;
            return this;
        }

        public Builder withInternalClientBuilder(Http2SolrClient.Builder internalClientBuilder) {
            if (this.httpClient != null) {
                throw new IllegalStateException("The builder can't accept an httpClient AND an internalClientBuilder, only one of those can be provided");
            }
            this.internalClientBuilder = internalClientBuilder;
            return this;
        }

        public CloudHttp2SolrClient build() {
            if (this.stateProvider == null) {
                if (!this.zkHosts.isEmpty()) {
                    this.stateProvider = new ZkClientClusterStateProvider(this.zkHosts, this.zkChroot);
                } else if (!this.solrUrls.isEmpty()) {
                    try {
                        this.stateProvider = new Http2ClusterStateProvider(this.solrUrls, this.httpClient);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Couldn't initialize a HttpClusterStateProvider (is/are the Solr server(s), " + this.solrUrls + ", down?)", e);
                    }
                } else {
                    throw new IllegalArgumentException("Both zkHosts and solrUrl cannot be null.");
                }
            }
            return new CloudHttp2SolrClient(this);
        }
    }
}

