/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.OfflineSorter;

public class ExternalRefSorter
implements BytesRefSorter,
Closeable {
    private final OfflineSorter sorter;
    private OfflineSorter.ByteSequencesWriter writer;
    private IndexOutput tempOutput;
    private String sortedOutput;

    public ExternalRefSorter(OfflineSorter sorter) throws IOException {
        this.sorter = sorter;
        this.tempOutput = sorter.getDirectory().createTempOutput(sorter.getTempFileNamePrefix(), "RefSorterRaw", IOContext.DEFAULT);
        this.writer = new OfflineSorter.ByteSequencesWriter(this.tempOutput);
    }

    @Override
    public void add(BytesRef utf8) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("Can't append after iterator() has been called and all the input sorted.");
        }
        this.writer.write(utf8);
    }

    @Override
    public ByteSequenceIterator iterator() throws IOException {
        block6: {
            block7: {
                block5: {
                    if (this.sortedOutput != null) break block6;
                    if (this.tempOutput == null) {
                        throw new IOException("The sorter has been closed.");
                    }
                    this.closeWriter();
                    boolean success = false;
                    try {
                        this.sortedOutput = this.sorter.sort(this.tempOutput.getName());
                        success = true;
                        if (!success) break block5;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            this.sorter.getDirectory().deleteFile(this.tempOutput.getName());
                        } else {
                            IOUtils.deleteFilesIgnoringExceptions((Directory)this.sorter.getDirectory(), (String[])new String[]{this.tempOutput.getName()});
                        }
                        throw throwable;
                    }
                    this.sorter.getDirectory().deleteFile(this.tempOutput.getName());
                    break block7;
                }
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.sorter.getDirectory(), (String[])new String[]{this.tempOutput.getName()});
            }
            this.tempOutput = null;
        }
        return new ByteSequenceIterator(new OfflineSorter.ByteSequencesReader(this.sorter.getDirectory().openChecksumInput(this.sortedOutput, IOContext.READONCE), this.sortedOutput));
    }

    private void closeWriter() throws IOException {
        if (this.writer != null) {
            CodecUtil.writeFooter((IndexOutput)this.tempOutput);
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeWriter();
        }
        catch (Throwable throwable) {
            IOUtils.deleteFilesIgnoringExceptions((Directory)this.sorter.getDirectory(), (String[])new String[]{this.tempOutput == null ? null : this.tempOutput.getName(), this.sortedOutput});
            throw throwable;
        }
        IOUtils.deleteFilesIgnoringExceptions((Directory)this.sorter.getDirectory(), (String[])new String[]{this.tempOutput == null ? null : this.tempOutput.getName(), this.sortedOutput});
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.sorter.getComparator();
    }

    static class ByteSequenceIterator
    implements BytesRefIterator,
    Closeable {
        private final OfflineSorter.ByteSequencesReader reader;
        private BytesRef scratch;

        public ByteSequenceIterator(OfflineSorter.ByteSequencesReader reader) {
            this.reader = reader;
        }

        public BytesRef next() throws IOException {
            BytesRef bytesRef;
            block4: {
                boolean success = false;
                try {
                    this.scratch = this.reader.next();
                    if (this.scratch == null) {
                        this.close();
                    }
                    success = true;
                    bytesRef = this.scratch;
                    if (success) break block4;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.reader});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.reader});
            }
            return bytesRef;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

