var protocol,CONNECT_TIMEOUT=15e3;class XpraProtocolWorkerHost{constructor(){this.worker=null,this.packet_handler=null}open(uri){this.worker?this.worker.postMessage({c:"o",u:uri}):(this.worker=new Worker("js/Protocol.js"),this.worker.addEventListener("message",e=>{var data=e.data;switch(data.c){case"r":this.worker.postMessage({c:"o",u:uri});break;case"p":this.packet_handler&&this.packet_handler(data.p);break;case"l":console.log(data.t);break;default:console.error("got unknown command from worker"),console.error(e.data)}},!1))}close=function(){this.worker.postMessage({c:"c"})};terminate=function(){this.worker.postMessage({c:"t"})};send=function(packet){this.worker.postMessage({c:"s",p:packet})};set_packet_handler=function(callback){this.packet_handler=callback};set_cipher_in=function(caps,key){this.worker.postMessage({c:"z",p:caps,k:key})};set_cipher_out=function(caps,key){this.worker.postMessage({c:"x",p:caps,k:key})}}class XpraProtocol{constructor(){this.verify_connected_timer=0,this.is_worker=!1,this.packet_handler=null,this.websocket=null,this.raw_packets=[],this.cipher_in_block_size=null,this.cipher_in_params=null,this.cipher_in_key=null,this.cipher_out_params=null,this.cipher_out_key=null,this.rQ=[],this.sQ=[],this.mQ=[],this.header=[],this.process_interval=0}close_event_str(event){var code_mappings={1e3:"Normal Closure",1001:"Going Away",1002:"Protocol Error",1003:"Unsupported Data",1004:"(For future)",1005:"No Status Received",1006:"Abnormal Closure",1007:"Invalid frame payload data",1008:"Policy Violation",1009:"Message too big",1010:"Missing Extension",1011:"Internal Error",1012:"Service Restart",1013:"Try Again Later",1014:"Bad Gateway",1015:"TLS Handshake"},message="";if(event.code)try{message+=void 0!==code_mappings[event.code]?`'${code_mappings[event.code]}' (${event.code})`:""+event.code,event.reason&&(message+=`: '${event.reason}'`)}catch(error){this.error("cannot parse websocket event:",error),message="unknown reason"}else message="unknown reason (no websocket error code)";return message}open(uri){var me=this;function handle(packet){me.packet_handler(packet)}this.raw_packets=[],this.rQ=[],this.sQ=[],this.mQ=[],this.header=[],this.websocket=null,this.verify_connected_timer=setTimeout(()=>handle(["error","connection timed out",0]),CONNECT_TIMEOUT);try{this.websocket=new WebSocket(uri,"binary")}catch(error){return void handle(["error",""+error,0])}this.websocket.binaryType="arraybuffer",this.websocket.addEventListener("open",function(){me.verify_connected_timer&&(clearTimeout(me.verify_connected_timer),me.verify_connected_timer=0),handle(["open"])}),this.websocket.addEventListener("close",event=>handle(["close",me.close_event_str(event)])),this.websocket.onerror=event=>handle(["error",me.close_event_str(event),event.code||0]),this.websocket.onmessage=function(e){me.rQ.push(new Uint8Array(e.data)),setTimeout(function(){me.process_receive_queue()},this.process_interval)}}close(){this.websocket&&(this.websocket.onopen=null,this.websocket.onclose=null,this.websocket.onerror=null,this.websocket.onmessage=null,this.websocket.close(),this.websocket=null)}protocol_error(message){this.error("protocol error:",message),this.websocket.onopen=null,this.websocket.onclose=null,this.websocket.onerror=null,this.websocket.onmessage=null,this.header=[],this.rQ=[],this.packet_handler(["close",message])}process_receive_queue(){for(;this.websocket&&0<this.rQ.length&&this.do_process_receive_queue(););}error(){console.error.apply(console,arguments)}log(){console.log.apply(console,arguments)}do_process_receive_queue(){if(this.header.length<8&&0<this.rQ.length){for(;this.header.length<8&&0<this.rQ.length;){var slice=this.rQ[0],needed=8-this.header.length,n=Math.min(needed,slice.length);this.header.push(...slice.subarray(0,n)),slice.length>needed?this.rQ[0]=slice.subarray(n):this.rQ.shift()}if(80!==this.header[0]){var message="invalid packet header format: "+this.header[0];if(1<this.header.length){var p,hex="";for(p of this.header){var v=p.toString(16);hex+=v.length<2?"0"+v:v}message+=": 0x"+hex}return this.protocol_error(message),!1}}if(!(this.header.length<8)){var message=-9&this.header[1],encrypted=2&message;if(encrypted&&(message&=-3),1<message&&16!==message)return this.protocol_error("we can't handle this protocol flag yet: "+message),!1;var packet_size=[4,5,6,7].reduce((accumulator,value)=>256*accumulator+this.header[value],0),padding=0,rsize=(encrypted&&0<this.cipher_in_block_size&&(padding=this.cipher_in_block_size-packet_size%this.cipher_in_block_size,packet_size+=padding),this.rQ.reduce((accumulator,value)=>accumulator+value.length,0));if(rsize<packet_size)return!1;var packet_data,iv,header=this.header;if(this.header=[],this.rQ[0].length===packet_size)packet_data=this.rQ.shift();else for(packet_data=new Uint8Array(packet_size),rsize=0;rsize<packet_size;){slice=this.rQ[0],needed=packet_size-rsize;slice.length>needed?(packet_data.set(slice.subarray(0,needed),rsize),rsize+=needed,this.rQ[0]=slice.subarray(needed)):(packet_data.set(slice,rsize),rsize+=slice.length,this.rQ.shift())}if(encrypted)return this.cipher_in_key?(iv=packet_data.slice(0,16),message=packet_data.subarray(16),this.cipher_in_params.iv=iv,crypto.subtle.decrypt(this.cipher_in_params,this.cipher_in_key,message).then(decrypted=>{var expected_length=packet_size-padding-iv.length;if(!decrypted||decrypted.byteLength<expected_length)return this.protocol_error(` expected ${expected_length} bytes, but got `+decrypted.byteLength),!1;packet_data=decrypted.byteLength===packet_size-padding?new Uint8Array(decrypted):new Uint8Array(decrypted.slice(0,packet_size-padding)),this.process_packet_data(header,packet_data)}).catch(err=>this.protocol_error("failed to decrypt data: "+err)),!0):(this.protocol_error("encrypted packet received, but no decryption is configured"),!1);this.process_packet_data(header,packet_data)}return!0}process_packet_data(header,packet_data){var level=header[2],index=header[3];if(0!==level){if(16&level)inflated=lz4.decode(packet_data);else{if(!(64&level))throw"unsupported compressor specified: "+level;inflated=new Uint8Array(BrotliDecode(packet_data))}packet_data=inflated}if(0<index)return 20<=index?void this.protocol_error("invalid packet index: "+index):(this.raw_packets[index]=packet_data,void(4<=this.raw_packets.length&&this.protocol_error("too many raw packets: "+this.raw_packets.length)));var packet=null;try{for(var index in packet=rdecode(packet_data),this.raw_packets)packet[index]=this.raw_packets[index];this.raw_packets={}}catch(error){this.error("error decoding packet",error),this.error("packet="+packet_data);var inflated=header[1];return this.error("protocol flags="+inflated),this.error(" level="+level),this.error(" index="+index),void(this.raw_packets=[])}try{this.is_worker?(this.mQ[this.mQ.length]=packet,setTimeout(()=>this.process_message_queue(),this.process_interval)):this.packet_handler(packet)}catch(error){this.error(`error processing packet ${packet[0]}: `+error),this.error(" packet data: "+packet_data)}}process_send_queue(){for(;0<this.sQ.length&&this.websocket;){var packet=this.sQ.shift();if(!packet)return;var bdata=null;try{bdata=rencode(packet)}catch(error){this.error("Error: failed to encode packet:",packet),this.error(error);continue}var iv,payload_size=bdata.length;if(this.cipher_out_key)return iv=Utilities.getSecureRandomBytes(16),this.cipher_out_params.iv=iv,void crypto.subtle.encrypt(this.cipher_out_params,this.cipher_out_key,bdata).then(encrypted=>{var encrypted=new Uint8Array(encrypted),packet_data=new Uint8Array(iv.byteLength+encrypted.byteLength);packet_data.set(iv,0),packet_data.set(encrypted,iv.byteLength),payload_size+=iv.byteLength,this.send_packet(packet_data,payload_size,!0)}).catch(err=>this.protocol_error("failed to encrypt packet: "+err));this.send_packet(bdata,payload_size,!1)}}make_packet_header(proto_flags,level,payload_size){var header=new Uint8Array(8);header[0]="P".charCodeAt(0),header[1]=proto_flags,header[2]=level;for(var index=header[3]=0;index<4;index++)header[7-index]=payload_size>>8*index&255;return header}send_packet(bdata,payload_size,encrypted){var proto_flags=16,encrypted=(encrypted&&(proto_flags|=2),this.make_packet_header(proto_flags,0,payload_size)),proto_flags=bdata.byteLength,payload_size=new Uint8Array(8+proto_flags);payload_size.set(encrypted,0),payload_size.set(bdata,8),this.websocket&&this.websocket.send(payload_size.buffer)}process_message_queue(){for(;0<this.mQ.length;){var packet=this.mQ.shift();if(!packet)return;var raw_buffers=[];"draw"===packet[0]&&"buffer"in packet[7]?raw_buffers.push(packet[7].buffer):"sound-data"===packet[0]&&Object.hasOwn(packet[2],"buffer")&&raw_buffers.push(packet[2].buffer),postMessage({c:"p",p:packet},raw_buffers)}}send(packet){this.sQ[this.sQ.length]=packet,setTimeout(()=>this.process_send_queue(),this.process_interval)}set_packet_handler(callback){this.packet_handler=callback}set_cipher_in(caps,key){this.setup_cipher(caps,key,"decrypt",(block_size,params,crypto_key)=>{this.cipher_in_block_size=block_size,this.cipher_in_params=params,this.cipher_in_key=crypto_key})}set_cipher_out(caps,key){this.setup_cipher(caps,key,"encrypt",(block_size,params,crypto_key)=>{this.cipher_out_params=params,this.cipher_out_key=crypto_key})}setup_cipher(caps,key,usage,setup_function){if(!key)throw"missing encryption key";var cipher=caps.cipher||"AES";if("AES"!==cipher)throw`unsupported encryption specified: '${cipher}'`;var mode=caps.mode||"CBC",block_size=0;if("CBC"===mode)block_size=16;else if(!["GCM","CTR"].includes(mode))throw`unsupported AES mode '${mode}'`;cipher=caps.iv;if(!cipher)throw"missing IV";var salt=Utilities.u8(caps.key_salt);if(!salt)throw"missing salt";var iterations=caps.key_stretch_iterations;if(iterations<1e3||1e6<iterations)throw"invalid number of iterations: "+iterations;var key_size=caps.key_size||32;if(![32,24,16].includes(key_size))throw`invalid key size '${key_size}'`;var key_stretch=caps.key_stretch||"PBKDF2";if("PBKDF2"!==key_stretch.toUpperCase())throw"invalid key stretching function "+key_stretch;var key_hash=(caps.key_hash||"SHA-1").toUpperCase(),params=(key_hash.startsWith("SHA")&&!key_hash.startsWith("SHA-")&&(key_hash="SHA-"+key_hash.substring(3)),{name:"AES-"+mode,iv:Utilities.u8(cipher)});console.log("importing","PBKDF2","key","'"+key+"'"),crypto.subtle.importKey("raw",Utilities.u8(key),{name:"PBKDF2"},!1,["deriveKey","deriveBits"]).then(imported_key=>{console.log("imported key:",imported_key),console.log("deriving",8*key_size,"bits",mode,"key with:",iterations,key_hash),console.log("salt=",salt),crypto.subtle.deriveKey({name:"PBKDF2",salt:salt,iterations:iterations,hash:{name:key_hash}},imported_key,{name:"AES-"+mode,length:8*key_size},!1,[usage]).then(crypto_key=>{console.log("derived key for",usage,"usage:",crypto_key),setup_function(block_size,params,crypto_key)}).catch(err=>{this.protocol_error("failed to derive AES key: "+err)})}).catch(err=>{this.protocol_error("failed to import AES key: "+err)})}}"object"==typeof window&&"object"==typeof document&&window.document===document||(importScripts("lib/lz4.js","lib/brotli_decode.js","lib/rencode.js","Utilities.js"),(protocol=new XpraProtocol).is_worker=!0,protocol.set_packet_handler(packet=>{var raw_buffer=[];"draw"===packet[0]&&Object.hasOwn(packet[7],"buffer")?(raw_buffer=packet[7].buffer,packet[7]=null):"send-file-chunk"===packet[0]&&Object.hasOwn(packet[3],"buffer")&&(raw_buffer=packet[3].buffer,packet[3]=null),postMessage({c:"p",p:packet},raw_buffer)},null),self.addEventListener("message",e=>{var data=e.data;switch(data.c){case"o":protocol.open(data.u);break;case"s":protocol.send(data.p);break;case"x":protocol.set_cipher_out(data.p,data.k);break;case"z":protocol.set_cipher_in(data.p,data.k);break;case"c":protocol.close();break;case"t":self.close();break;default:postMessage({c:"l",t:"got unknown command from host"})}},!1),postMessage({c:"r"}));