var JSMpeg={Player:null,VideoElement:null,BitBuffer:null,Source:{},Demuxer:{},Decoder:{},Renderer:{},AudioOutput:{},Now:function(){return window.performance?window.performance.now()/1e3:Date.now()/1e3},CreateVideoElements:function(){for(var elements=document.querySelectorAll(".jsmpeg"),i=0;i<elements.length;i++)new JSMpeg.VideoElement(elements[i])},Fill:function(array,value){if(array.fill)array.fill(value);else for(var i=0;i<array.length;i++)array[i]=value}};"complete"===document.readyState?JSMpeg.CreateVideoElements():document.addEventListener("DOMContentLoaded",JSMpeg.CreateVideoElements),JSMpeg.VideoElement=(()=>{function VideoElement(element){var url=element.dataset.url;if(!url)throw"VideoElement has no `data-url` attribute";function addStyles(element,styles){for(var name in styles)element.style[name]=styles[name]}this.container=element,addStyles(this.container,{display:"inline-block",position:"relative",minWidth:"80px",minHeight:"80px"}),this.canvas=document.createElement("canvas"),this.canvas.width=960,this.canvas.height=540,addStyles(this.canvas,{display:"block",width:"100%"}),this.container.appendChild(this.canvas),this.playButton=document.createElement("div"),this.playButton.innerHTML=VideoElement.PLAY_BUTTON,addStyles(this.playButton,{zIndex:2,position:"absolute",top:"0",bottom:"0",left:"0",right:"0",maxWidth:"75px",maxHeight:"75px",margin:"auto",opacity:"0.7",cursor:"pointer"}),this.container.appendChild(this.playButton);var option,options={canvas:this.canvas};for(option in element.dataset)try{options[option]=JSON.parse(element.dataset[option])}catch(err){options[option]=element.dataset[option]}this.player=new JSMpeg.Player(url,options),element.playerInstance=this.player,!options.poster||options.autoplay||this.player.options.streaming||(options.decodeFirstFrame=!1,this.poster=new Image,this.poster.src=options.poster,this.poster.addEventListener("load",this.posterLoaded),addStyles(this.poster,{display:"block",zIndex:1,position:"absolute",top:0,left:0,bottom:0,right:0}),this.container.appendChild(this.poster)),this.player.options.streaming||this.container.addEventListener("click",this.onClick.bind(this)),(options.autoplay||this.player.options.streaming)&&(this.playButton.style.display="none"),this.player.audioOut&&!this.player.audioOut.unlocked&&(url=this.container,(options.autoplay||this.player.options.streaming)&&(this.unmuteButton=document.createElement("div"),this.unmuteButton.innerHTML=VideoElement.UNMUTE_BUTTON,addStyles(this.unmuteButton,{zIndex:2,position:"absolute",bottom:"10px",right:"20px",width:"75px",height:"75px",margin:"auto",opacity:"0.7",cursor:"pointer"}),this.container.appendChild(this.unmuteButton),url=this.unmuteButton),this.unlockAudioBound=this.onUnlockAudio.bind(this,url),url.addEventListener("touchstart",this.unlockAudioBound,!1),url.addEventListener("click",this.unlockAudioBound,!0))}return VideoElement.prototype.onUnlockAudio=function(element,ev){this.unmuteButton&&(ev.preventDefault(),ev.stopPropagation()),this.player.audioOut.unlock(function(){this.unmuteButton&&(this.unmuteButton.style.display="none"),element.removeEventListener("touchstart",this.unlockAudioBound),element.removeEventListener("click",this.unlockAudioBound)}.bind(this))},VideoElement.prototype.onClick=function(ev){this.player.isPlaying?(this.player.pause(),this.playButton.style.display="block"):(this.player.play(),this.playButton.style.display="none",this.poster&&(this.poster.style.display="none"))},VideoElement.PLAY_BUTTON='<svg style="max-width: 75px; max-height: 75px;" viewBox="0 0 200 200" alt="Play video"><circle cx="100" cy="100" r="90" fill="none" stroke-width="15" stroke="#fff"/><polygon points="70, 55 70, 145 145, 100" fill="#fff"/></svg>',VideoElement.UNMUTE_BUTTON='<svg style="max-width: 75px; max-height: 75px;" viewBox="0 0 75 75"><polygon class="audio-speaker" stroke="none" fill="#fff" points="39,13 22,28 6,28 6,47 21,47 39,62 39,13"/><g stroke="#fff" stroke-width="5"><path d="M 49,50 69,26"/><path d="M 69,50 49,26"/></g></svg>',VideoElement})(),JSMpeg.Player=(()=>{function Player(url,options){this.options=options||{},options.source?(this.source=new options.source(url,options),options.streaming=!!this.source.streaming):url.match(/^wss?:\/\//)?(this.source=new JSMpeg.Source.WebSocket(url,options),options.streaming=!0):(!1!==options.progressive?this.source=new JSMpeg.Source.AjaxProgressive(url,options):this.source=new JSMpeg.Source.Ajax(url,options),options.streaming=!1),this.maxAudioLag=options.maxAudioLag||.25,this.loop=!1!==options.loop,this.autoplay=!!options.autoplay||options.streaming,this.demuxer=new JSMpeg.Demuxer.TS(options),this.source.connect(this.demuxer),!1!==options.video&&(this.video=new JSMpeg.Decoder.MPEG1Video(options),this.renderer=new(!options.disableGl&&JSMpeg.Renderer.WebGL.IsSupported()?JSMpeg.Renderer.WebGL:JSMpeg.Renderer.Canvas2D)(options),this.demuxer.connect(JSMpeg.Demuxer.TS.STREAM.VIDEO_1,this.video),this.video.connect(this.renderer)),!1!==options.audio&&JSMpeg.AudioOutput.WebAudio.IsSupported()&&(this.audio=new JSMpeg.Decoder.MP2Audio(options),this.audioOut=new JSMpeg.AudioOutput.WebAudio(options),this.demuxer.connect(JSMpeg.Demuxer.TS.STREAM.AUDIO_1,this.audio),this.audio.connect(this.audioOut)),Object.defineProperty(this,"currentTime",{get:this.getCurrentTime,set:this.setCurrentTime}),Object.defineProperty(this,"volume",{get:this.getVolume,set:this.setVolume}),(this.unpauseOnShow=!1)!==options.pauseWhenHidden&&document.addEventListener("visibilitychange",this.showHide.bind(this)),this.source.start(),this.autoplay&&this.play()}return Player.prototype.showHide=function(ev){"hidden"===document.visibilityState?(this.unpauseOnShow=this.wantsToPlay,this.pause()):this.unpauseOnShow&&this.play()},Player.prototype.play=function(ev){this.animationId=requestAnimationFrame(this.update.bind(this)),this.wantsToPlay=!0},Player.prototype.pause=function(ev){cancelAnimationFrame(this.animationId),this.wantsToPlay=!1,this.isPlaying=!1,this.audio&&this.audio.canPlay&&(this.audioOut.stop(),this.seek(this.currentTime))},Player.prototype.getVolume=function(){return this.audioOut?this.audioOut.volume:0},Player.prototype.setVolume=function(volume){this.audioOut&&(this.audioOut.volume=volume)},Player.prototype.stop=function(ev){this.pause(),this.seek(0),this.video&&!1!==this.options.decodeFirstFrame&&this.video.decode()},Player.prototype.destroy=function(){this.pause(),this.source.destroy(),this.renderer.destroy(),this.audioOut.destroy()},Player.prototype.seek=function(time){var startOffset=(this.audio&&this.audio.canPlay?this.audio:this.video).startTime;this.video&&this.video.seek(time+startOffset),this.audio&&this.audio.seek(time+startOffset),this.startTime=JSMpeg.Now()-time},Player.prototype.getCurrentTime=function(){return this.audio&&this.audio.canPlay?this.audio.currentTime-this.audio.startTime:this.video.currentTime-this.video.startTime},Player.prototype.setCurrentTime=function(time){this.seek(time)},Player.prototype.update=function(){this.animationId=requestAnimationFrame(this.update.bind(this)),this.source.established?(this.isPlaying||(this.isPlaying=!0,this.startTime=JSMpeg.Now()-this.currentTime),this.options.streaming?this.updateForStreaming():this.updateForStaticFile()):this.renderer&&this.renderer.renderProgress(this.source.progress)},Player.prototype.updateForStreaming=function(){if(this.video&&this.video.decode(),this.audio){for(;this.audioOut.enqueuedTime>this.maxAudioLag&&(this.audioOut.resetEnqueuedTime(),this.audioOut.enabled=!1),this.audio.decode(););this.audioOut.enabled=!0}},Player.prototype.updateForStaticFile=function(){var targetTime,lateTime,frameTime,notEnoughData=!1,headroom=0;if(this.audio&&this.audio.canPlay){for(;!notEnoughData&&this.audio.decodedTime-this.audio.currentTime<.25;)notEnoughData=!this.audio.decode();this.video&&this.video.currentTime<this.audio.currentTime&&(notEnoughData=!this.video.decode()),headroom=this.demuxer.currentTime-this.audio.currentTime}else this.video&&(lateTime=(targetTime=JSMpeg.Now()-this.startTime+this.video.startTime)-this.video.currentTime,frameTime=1/this.video.frameRate,this.video&&0<lateTime&&(2*frameTime<lateTime&&(this.startTime+=lateTime),notEnoughData=!this.video.decode()),headroom=this.demuxer.currentTime-targetTime);this.source.resume(headroom),notEnoughData&&this.source.completed&&(this.loop?this.seek(0):this.pause())},Player})(),JSMpeg.BitBuffer=(()=>{function BitBuffer(bufferOrLength,mode){"object"==typeof bufferOrLength?(this.bytes=bufferOrLength instanceof Uint8Array?bufferOrLength:new Uint8Array(bufferOrLength),this.byteLength=this.bytes.length):(this.bytes=new Uint8Array(bufferOrLength||1048576),this.byteLength=0),this.mode=mode||BitBuffer.MODE.EXPAND,this.index=0}return BitBuffer.prototype.resize=function(size){var newBytes=new Uint8Array(size);0!==this.byteLength&&(this.byteLength=Math.min(this.byteLength,size),newBytes.set(this.bytes,0,this.byteLength)),this.bytes=newBytes,this.index=Math.min(this.index,this.byteLength<<3)},BitBuffer.prototype.evict=function(sizeNeeded){var bytePos=this.index>>3,available=this.bytes.length-this.byteLength;this.index===this.byteLength<<3||available+bytePos<sizeNeeded?(this.byteLength=0,this.index=0):0!=bytePos&&(this.bytes.copyWithin?this.bytes.copyWithin(0,bytePos,this.byteLength):this.bytes.set(this.bytes.subarray(bytePos,this.byteLength)),this.byteLength=this.byteLength-bytePos,this.index-=bytePos<<3)},BitBuffer.prototype.write=function(buffers){var isArrayOfBuffers="object"==typeof buffers[0],totalLength=0,available=this.bytes.length-this.byteLength;if(isArrayOfBuffers)for(var totalLength=0,i=0;i<buffers.length;i++)totalLength+=buffers[i].byteLength;else totalLength=buffers.byteLength;if(available<totalLength&&(this.mode===BitBuffer.MODE.EXPAND?(available=Math.max(2*this.bytes.length,totalLength-available),this.resize(available)):this.evict(totalLength)),isArrayOfBuffers)for(i=0;i<buffers.length;i++)this.appendSingleBuffer(buffers[i]);else this.appendSingleBuffer(buffers)},BitBuffer.prototype.appendSingleBuffer=function(buffer){buffer=buffer instanceof Uint8Array?buffer:new Uint8Array(buffer),this.bytes.set(buffer,this.byteLength),this.byteLength+=buffer.length},BitBuffer.prototype.findNextStartCode=function(){for(var i=this.index+7>>3;i<this.byteLength;i++)if(0==this.bytes[i]&&0==this.bytes[i+1]&&1==this.bytes[i+2])return this.index=i+4<<3,this.bytes[i+3];return this.index=this.byteLength<<3,-1},BitBuffer.prototype.findStartCode=function(code){for(var current;;)if((current=this.findNextStartCode())===code||-1===current)return current;return-1},BitBuffer.prototype.nextBytesAreStartCode=function(){var i=this.index+7>>3;return i>=this.byteLength||0==this.bytes[i]&&0==this.bytes[1+i]&&1==this.bytes[2+i]},BitBuffer.prototype.peek=function(count){for(var offset=this.index,value=0;count;){var remaining=8-(7&offset),read=remaining<count?remaining:count,remaining=remaining-read,value=value<<read|(this.bytes[offset>>3]&255>>8-read<<remaining)>>remaining;offset+=read,count-=read}return value},BitBuffer.prototype.read=function(count){var value=this.peek(count);return this.index+=count,value},BitBuffer.prototype.skip=function(count){return this.index+=count},BitBuffer.prototype.rewind=function(count){this.index=Math.max(this.index-count,0)},BitBuffer.prototype.has=function(count){return(this.byteLength<<3)-this.index>=count},BitBuffer.MODE={EVICT:1,EXPAND:2},BitBuffer})(),JSMpeg.Source.Ajax=(()=>{function AjaxSource(url,options){this.url=url,this.destination=null,this.request=null,this.completed=!1,this.established=!1,this.progress=0}return AjaxSource.prototype.connect=function(destination){this.destination=destination},AjaxSource.prototype.start=function(){this.request=new XMLHttpRequest,this.request.onreadystatechange=function(){this.request.readyState===this.request.DONE&&200===this.request.status&&this.onLoad(this.request.response)}.bind(this),this.request.onprogress=this.onProgress.bind(this),this.request.open("GET",this.url),this.request.responseType="arraybuffer",this.request.send()},AjaxSource.prototype.resume=function(secondsHeadroom){},AjaxSource.prototype.destroy=function(){this.request.abort()},AjaxSource.prototype.onProgress=function(ev){this.progress=ev.loaded/ev.total},AjaxSource.prototype.onLoad=function(data){this.established=!0,this.completed=!0,this.progress=1,this.destination&&this.destination.write(data)},AjaxSource})(),JSMpeg.Source.AjaxProgressive=(()=>{function AjaxProgressiveSource(url,options){this.url=url,this.destination=null,this.request=null,this.completed=!1,this.established=!1,this.progress=0,this.fileSize=0,this.loadedSize=0,this.chunkSize=options.chunkSize||1048576,this.isLoading=!1,this.loadStartTime=0,this.throttled=!1!==options.throttled,this.aborted=!1}return AjaxProgressiveSource.prototype.connect=function(destination){this.destination=destination},AjaxProgressiveSource.prototype.start=function(){this.request=new XMLHttpRequest,this.request.onreadystatechange=function(){this.request.readyState===this.request.DONE&&(this.fileSize=parseInt(this.request.getResponseHeader("Content-Length")),this.loadNextChunk())}.bind(this),this.request.onprogress=this.onProgress.bind(this),this.request.open("HEAD",this.url),this.request.send()},AjaxProgressiveSource.prototype.resume=function(secondsHeadroom){!this.isLoading&&this.throttled&&secondsHeadroom<8*this.loadTime+2&&this.loadNextChunk()},AjaxProgressiveSource.prototype.destroy=function(){this.request.abort(),this.aborted=!0},AjaxProgressiveSource.prototype.loadNextChunk=function(){var start=this.loadedSize,end=Math.min(this.loadedSize+this.chunkSize-1,this.fileSize-1);start>=this.fileSize||this.aborted?this.completed=!0:(this.isLoading=!0,this.loadStartTime=JSMpeg.Now(),this.request=new XMLHttpRequest,this.request.onreadystatechange=function(){this.request.readyState===this.request.DONE&&200<=this.request.status&&this.request.status<300?this.onChunkLoad(this.request.response):this.request.readyState===this.request.DONE&&this.loadFails++<3&&this.loadNextChunk()}.bind(this),0===start&&(this.request.onprogress=this.onProgress.bind(this)),this.request.open("GET",this.url+"?"+start+"-"+end),this.request.setRequestHeader("Range","bytes="+start+"-"+end),this.request.responseType="arraybuffer",this.request.send())},AjaxProgressiveSource.prototype.onProgress=function(ev){this.progress=ev.loaded/ev.total},AjaxProgressiveSource.prototype.onChunkLoad=function(data){this.established=!0,this.progress=1,this.loadedSize+=data.byteLength,this.loadFails=0,this.isLoading=!1,this.destination&&this.destination.write(data),this.loadTime=JSMpeg.Now()-this.loadStartTime,this.throttled||this.loadNextChunk()},AjaxProgressiveSource})(),JSMpeg.Source.WebSocket=(()=>{function WSSource(url,options){this.url=url,this.options=options,this.socket=null,this.callbacks={connect:[],data:[]},this.destination=null,this.reconnectInterval=void 0!==options.reconnectInterval?options.reconnectInterval:5,this.shouldAttemptReconnect=!!this.reconnectInterval,this.completed=!1,this.established=!1,this.progress=0,this.reconnectTimeoutId=0}return WSSource.prototype.connect=function(destination){this.destination=destination},WSSource.prototype.destroy=function(){clearTimeout(this.reconnectTimeoutId),this.shouldAttemptReconnect=!1,this.socket.close()},WSSource.prototype.start=function(){this.shouldAttemptReconnect=!!this.reconnectInterval,this.progress=0,this.established=!1,this.socket=new WebSocket(this.url,this.options.protocols||null),this.socket.binaryType="arraybuffer",this.socket.onmessage=this.onMessage.bind(this),this.socket.onopen=this.onOpen.bind(this),this.socket.onerror=this.onClose.bind(this),this.socket.onclose=this.onClose.bind(this)},WSSource.prototype.resume=function(secondsHeadroom){},WSSource.prototype.onOpen=function(){this.progress=1,this.established=!0},WSSource.prototype.onClose=function(){this.shouldAttemptReconnect&&(clearTimeout(this.reconnectTimeoutId),this.reconnectTimeoutId=setTimeout(function(){this.start()}.bind(this),1e3*this.reconnectInterval))},WSSource.prototype.onMessage=function(ev){this.destination&&this.destination.write(ev.data)},WSSource})(),JSMpeg.Demuxer.TS=(()=>{function TS(options){this.bits=null,this.leftoverBytes=null,this.guessVideoFrameEnd=!0,this.pidsToStreamIds={},this.pesPacketInfo={},this.startTime=0,this.currentTime=0}return TS.prototype.connect=function(streamId,destination){this.pesPacketInfo[streamId]={destination:destination,currentLength:0,totalLength:0,pts:0,buffers:[]}},TS.prototype.write=function(buffer){for(this.leftoverBytes?(totalLength=buffer.byteLength+this.leftoverBytes.byteLength,this.bits=new JSMpeg.BitBuffer(totalLength),this.bits.write([this.leftoverBytes,buffer])):this.bits=new JSMpeg.BitBuffer(buffer);this.bits.has(1504)&&this.parsePacket(););var totalLength=this.bits.byteLength-(this.bits.index>>3);this.leftoverBytes=0<totalLength?this.bits.bytes.subarray(this.bits.index>>3):null},TS.prototype.parsePacket=function(){var end,payloadStart,adaptationField,streamId,adaptationFieldLength,headerLength,payloadBeginIndex,pts,p29_15,p14_0,pi,pid;return!(71!==this.bits.read(8)&&!this.resync()||(end=187+(this.bits.index>>3),this.bits.read(1),payloadStart=this.bits.read(1),this.bits.read(1),pid=this.bits.read(13),this.bits.read(2),adaptationField=this.bits.read(2),this.bits.read(4),streamId=this.pidsToStreamIds[pid],payloadStart&&streamId&&(pi=this.pesPacketInfo[streamId])&&pi.currentLength&&this.packetComplete(pi),1&adaptationField&&(2&adaptationField&&(adaptationFieldLength=this.bits.read(8),this.bits.skip(adaptationFieldLength<<3)),payloadStart&&this.bits.nextBytesAreStartCode()&&(this.bits.skip(24),streamId=this.bits.read(8),this.pidsToStreamIds[pid]=streamId,adaptationFieldLength=this.bits.read(16),this.bits.skip(8),pid=this.bits.read(2),this.bits.skip(6),headerLength=this.bits.read(8),payloadBeginIndex=this.bits.index+(headerLength<<3),(pi=this.pesPacketInfo[streamId])&&(pts=0,2&pid&&(this.bits.skip(4),pid=this.bits.read(3),this.bits.skip(1),p29_15=this.bits.read(15),this.bits.skip(1),p14_0=this.bits.read(15),this.bits.skip(1),this.currentTime=pts=(1073741824*pid+32768*p29_15+p14_0)/9e4,-1===this.startTime)&&(this.startTime=pts),this.packetStart(pi,pts,adaptationFieldLength?adaptationFieldLength-headerLength-3:0)),this.bits.index=payloadBeginIndex),streamId)&&(pi=this.pesPacketInfo[streamId])&&(pid=this.bits.index>>3,this.packetAddData(pi,pid,end)||this.guessVideoFrameEnd&&(!payloadStart&&2&adaptationField))&&this.packetComplete(pi),this.bits.index=end<<3,0))},TS.prototype.resync=function(){if(this.bits.has(9024)){for(var byteIndex=this.bits.index>>3,i=0;i<187;i++)if(71===this.bits.bytes[byteIndex+i]){for(var foundSync=!0,j=1;j<5;j++)if(71!==this.bits.bytes[byteIndex+i+188*j]){foundSync=!1;break}if(foundSync)return this.bits.index=byteIndex+i+1<<3,!0}console.warn("JSMpeg: Possible garbage data. Skipping."),this.bits.skip(1496)}return!1},TS.prototype.packetStart=function(pi,pts,payloadLength){pi.totalLength=payloadLength,pi.currentLength=0,pi.pts=pts},TS.prototype.packetAddData=function(pi,start,end){return pi.buffers.push(this.bits.bytes.subarray(start,end)),pi.currentLength+=end-start,0!==pi.totalLength&&pi.currentLength>=pi.totalLength},TS.prototype.packetComplete=function(pi){pi.destination.write(pi.pts,pi.buffers),pi.totalLength=0,pi.currentLength=0,pi.buffers=[]},TS.STREAM={PACK_HEADER:186,SYSTEM_HEADER:187,PROGRAM_MAP:188,PRIVATE_1:189,PADDING:190,PRIVATE_2:191,AUDIO_1:192,VIDEO_1:224,DIRECTORY:255},TS})(),JSMpeg.Decoder.Base=(()=>{function BaseDecoder(options){this.destination=null,this.canPlay=!1,this.collectTimestamps=!options.streaming,this.timestamps=[],this.timestampIndex=0,this.startTime=0,this.decodedTime=0,Object.defineProperty(this,"currentTime",{get:this.getCurrentTime})}return BaseDecoder.prototype.connect=function(destination){this.destination=destination},BaseDecoder.prototype.write=function(pts,buffers){this.collectTimestamps&&(0===this.timestamps.length&&(this.startTime=pts,this.decodedTime=pts),this.timestamps.push({index:this.bits.byteLength<<3,time:pts})),this.bits.write(buffers),this.canPlay=!0},BaseDecoder.prototype.seek=function(time){if(this.collectTimestamps){for(var i=this.timestampIndex=0;i<this.timestamps.length&&!(this.timestamps[i].time>time);i++)this.timestampIndex=i;var ts=this.timestamps[this.timestampIndex];ts?(this.bits.index=ts.index,this.decodedTime=ts.time):(this.bits.index=0,this.decodedTime=this.startTime)}},BaseDecoder.prototype.decode=function(){this.advanceDecodedTime(0)},BaseDecoder.prototype.advanceDecodedTime=function(seconds){if(this.collectTimestamps){for(var newTimestampIndex=-1,i=this.timestampIndex;i<this.timestamps.length&&!(this.timestamps[i].index>this.bits.index);i++)newTimestampIndex=i;if(-1!==newTimestampIndex&&newTimestampIndex!==this.timestampIndex)return this.timestampIndex=newTimestampIndex,void(this.decodedTime=this.timestamps[this.timestampIndex].time)}this.decodedTime+=seconds},BaseDecoder.prototype.getCurrentTime=function(){return this.decodedTime},BaseDecoder})(),JSMpeg.Decoder.MPEG1Video=(()=>{function MPEG1(options){JSMpeg.Decoder.Base.call(this,options);var bufferSize=options.videoBufferSize||524288,bufferMode=options.streaming?JSMpeg.BitBuffer.MODE.EVICT:JSMpeg.BitBuffer.MODE.EXPAND;this.bits=new JSMpeg.BitBuffer(bufferSize,bufferMode),this.customIntraQuantMatrix=new Uint8Array(64),this.customNonIntraQuantMatrix=new Uint8Array(64),this.blockData=new Int32Array(64),this.currentFrame=0,this.decodeFirstFrame=!1!==options.decodeFirstFrame}return((MPEG1.prototype=Object.create(JSMpeg.Decoder.Base.prototype)).constructor=MPEG1).prototype.write=function(pts,buffers){if(JSMpeg.Decoder.Base.prototype.write.call(this,pts,buffers),!this.hasSequenceHeader){if(-1===this.bits.findStartCode(MPEG1.START.SEQUENCE))return!1;this.decodeSequenceHeader(),this.decodeFirstFrame&&this.decode()}},MPEG1.prototype.decode=function(){return!!this.hasSequenceHeader&&(-1===this.bits.findStartCode(MPEG1.START.PICTURE)?(this.bits.byteLength,this.bits.index,!1):(this.decodePicture(),this.advanceDecodedTime(1/this.frameRate),!0))},MPEG1.prototype.readHuffman=function(codeTable){for(var state=0;0<=(state=codeTable[state+this.bits.read(1)])&&0!==codeTable[state];);return codeTable[state+2]},MPEG1.prototype.frameRate=30,MPEG1.prototype.decodeSequenceHeader=function(){var newWidth=this.bits.read(12),newHeight=this.bits.read(12);if(this.bits.skip(4),this.frameRate=MPEG1.PICTURE_RATE[this.bits.read(4)],this.bits.skip(30),newWidth===this.width&&newHeight===this.height||(this.width=newWidth,this.height=newHeight,this.initBuffers(),this.destination&&this.destination.resize(newWidth,newHeight)),this.bits.read(1)){for(var i=0;i<64;i++)this.customIntraQuantMatrix[MPEG1.ZIG_ZAG[i]]=this.bits.read(8);this.intraQuantMatrix=this.customIntraQuantMatrix}if(this.bits.read(1)){for(i=0;i<64;i++){var idx=MPEG1.ZIG_ZAG[i];this.customNonIntraQuantMatrix[idx]=this.bits.read(8)}this.nonIntraQuantMatrix=this.customNonIntraQuantMatrix}this.hasSequenceHeader=!0},MPEG1.prototype.initBuffers=function(){this.intraQuantMatrix=MPEG1.DEFAULT_INTRA_QUANT_MATRIX,this.nonIntraQuantMatrix=MPEG1.DEFAULT_NON_INTRA_QUANT_MATRIX,this.mbWidth=this.width+15>>4,this.mbHeight=this.height+15>>4,this.mbSize=this.mbWidth*this.mbHeight,this.codedWidth=this.mbWidth<<4,this.codedHeight=this.mbHeight<<4,this.codedSize=this.codedWidth*this.codedHeight,this.halfWidth=this.mbWidth<<3,this.halfHeight=this.mbHeight<<3,this.currentY=new Uint8ClampedArray(this.codedSize),this.currentY32=new Uint32Array(this.currentY.buffer),this.currentCr=new Uint8ClampedArray(this.codedSize>>2),this.currentCr32=new Uint32Array(this.currentCr.buffer),this.currentCb=new Uint8ClampedArray(this.codedSize>>2),this.currentCb32=new Uint32Array(this.currentCb.buffer),this.forwardY=new Uint8ClampedArray(this.codedSize),this.forwardY32=new Uint32Array(this.forwardY.buffer),this.forwardCr=new Uint8ClampedArray(this.codedSize>>2),this.forwardCr32=new Uint32Array(this.forwardCr.buffer),this.forwardCb=new Uint8ClampedArray(this.codedSize>>2),this.forwardCb32=new Uint32Array(this.forwardCb.buffer)},MPEG1.prototype.currentY=null,MPEG1.prototype.currentCr=null,MPEG1.prototype.currentCb=null,MPEG1.prototype.pictureType=0,MPEG1.prototype.forwardY=null,MPEG1.prototype.forwardCr=null,MPEG1.prototype.forwardCb=null,MPEG1.prototype.fullPelForward=!1,MPEG1.prototype.forwardFCode=0,MPEG1.prototype.forwardRSize=0,MPEG1.prototype.forwardF=0,MPEG1.prototype.decodePicture=function(skipOutput){if(this.currentFrame++,this.bits.skip(10),this.pictureType=this.bits.read(3),this.bits.skip(16),!(this.pictureType<=0||this.pictureType>=MPEG1.PICTURE_TYPE.B)){if(this.pictureType===MPEG1.PICTURE_TYPE.PREDICTIVE){if(this.fullPelForward=this.bits.read(1),this.forwardFCode=this.bits.read(3),0===this.forwardFCode)return;this.forwardRSize=this.forwardFCode-1,this.forwardF=1<<this.forwardRSize}for(var tmpY,tmpY32,tmpCr,tmpCr32,tmpCb,tmpCb32,code=0;(code=this.bits.findNextStartCode())===MPEG1.START.EXTENSION||code===MPEG1.START.USER_DATA;);for(;code>=MPEG1.START.SLICE_FIRST&&code<=MPEG1.START.SLICE_LAST;)this.decodeSlice(255&code),code=this.bits.findNextStartCode();-1!==code&&this.bits.rewind(32),this.destination&&this.destination.render(this.currentY,this.currentCr,this.currentCb),this.pictureType!==MPEG1.PICTURE_TYPE.INTRA&&this.pictureType!==MPEG1.PICTURE_TYPE.PREDICTIVE||(tmpY=this.forwardY,tmpY32=this.forwardY32,tmpCr=this.forwardCr,tmpCr32=this.forwardCr32,tmpCb=this.forwardCb,tmpCb32=this.forwardCb32,this.forwardY=this.currentY,this.forwardY32=this.currentY32,this.forwardCr=this.currentCr,this.forwardCr32=this.currentCr32,this.forwardCb=this.currentCb,this.forwardCb32=this.currentCb32,this.currentY=tmpY,this.currentY32=tmpY32,this.currentCr=tmpCr,this.currentCr32=tmpCr32,this.currentCb=tmpCb,this.currentCb32=tmpCb32)}},MPEG1.prototype.quantizerScale=0,MPEG1.prototype.sliceBegin=!1,MPEG1.prototype.decodeSlice=function(slice){for(this.sliceBegin=!0,this.macroblockAddress=(slice-1)*this.mbWidth-1,this.motionFwH=this.motionFwHPrev=0,this.motionFwV=this.motionFwVPrev=0,this.dcPredictorY=128,this.dcPredictorCr=128,this.dcPredictorCb=128,this.quantizerScale=this.bits.read(5);this.bits.read(1);)this.bits.skip(8);for(;this.decodeMacroblock(),!this.bits.nextBytesAreStartCode(););},MPEG1.prototype.macroblockAddress=0,MPEG1.prototype.mbRow=0,MPEG1.prototype.mbCol=0,MPEG1.prototype.macroblockType=0,MPEG1.prototype.macroblockIntra=!1,MPEG1.prototype.macroblockMotFw=!1,MPEG1.prototype.motionFwH=0,MPEG1.prototype.motionFwV=0,MPEG1.prototype.motionFwHPrev=0,MPEG1.prototype.motionFwVPrev=0,MPEG1.prototype.decodeMacroblock=function(){for(var increment=0,t=this.readHuffman(MPEG1.MACROBLOCK_ADDRESS_INCREMENT);34===t;)t=this.readHuffman(MPEG1.MACROBLOCK_ADDRESS_INCREMENT);for(;35===t;)increment+=33,t=this.readHuffman(MPEG1.MACROBLOCK_ADDRESS_INCREMENT);if(increment+=t,this.sliceBegin)this.sliceBegin=!1,this.macroblockAddress+=increment;else{if(this.macroblockAddress+increment>=this.mbSize)return;for(1<increment&&(this.dcPredictorY=128,this.dcPredictorCr=128,this.dcPredictorCb=128,this.pictureType===MPEG1.PICTURE_TYPE.PREDICTIVE)&&(this.motionFwH=this.motionFwHPrev=0,this.motionFwV=this.motionFwVPrev=0);1<increment;)this.macroblockAddress++,this.mbRow=this.macroblockAddress/this.mbWidth|0,this.mbCol=this.macroblockAddress%this.mbWidth,this.copyMacroblock(this.motionFwH,this.motionFwV,this.forwardY,this.forwardCr,this.forwardCb),increment--;this.macroblockAddress++}this.mbRow=this.macroblockAddress/this.mbWidth|0,this.mbCol=this.macroblockAddress%this.mbWidth;for(var mbTable=MPEG1.MACROBLOCK_TYPE[this.pictureType],cbp=(this.macroblockType=this.readHuffman(mbTable),this.macroblockIntra=1&this.macroblockType,this.macroblockMotFw=8&this.macroblockType,0!=(16&this.macroblockType)&&(this.quantizerScale=this.bits.read(5)),this.macroblockIntra?(this.motionFwH=this.motionFwHPrev=0,this.motionFwV=this.motionFwVPrev=0):(this.dcPredictorY=128,this.dcPredictorCr=128,this.dcPredictorCb=128,this.decodeMotionVectors(),this.copyMacroblock(this.motionFwH,this.motionFwV,this.forwardY,this.forwardCr,this.forwardCb)),0!=(2&this.macroblockType)?this.readHuffman(MPEG1.CODE_BLOCK_PATTERN):this.macroblockIntra?63:0),block=0,mask=32;block<6;block++)0!=(cbp&mask)&&this.decodeBlock(block),mask>>=1},MPEG1.prototype.decodeMotionVectors=function(){var code,d,r=0;this.macroblockMotFw?(0!==(code=this.readHuffman(MPEG1.MOTION))&&1!==this.forwardF?(r=this.bits.read(this.forwardRSize),d=(Math.abs(code)-1<<this.forwardRSize)+r+1,code<0&&(d=-d)):d=code,this.motionFwHPrev+=d,this.motionFwHPrev>(this.forwardF<<4)-1?this.motionFwHPrev-=this.forwardF<<5:this.motionFwHPrev<-this.forwardF<<4&&(this.motionFwHPrev+=this.forwardF<<5),this.motionFwH=this.motionFwHPrev,this.fullPelForward&&(this.motionFwH<<=1),0!==(code=this.readHuffman(MPEG1.MOTION))&&1!==this.forwardF?(r=this.bits.read(this.forwardRSize),d=(Math.abs(code)-1<<this.forwardRSize)+r+1,code<0&&(d=-d)):d=code,this.motionFwVPrev+=d,this.motionFwVPrev>(this.forwardF<<4)-1?this.motionFwVPrev-=this.forwardF<<5:this.motionFwVPrev<-this.forwardF<<4&&(this.motionFwVPrev+=this.forwardF<<5),this.motionFwV=this.motionFwVPrev,this.fullPelForward&&(this.motionFwV<<=1)):this.pictureType===MPEG1.PICTURE_TYPE.PREDICTIVE&&(this.motionFwH=this.motionFwHPrev=0,this.motionFwV=this.motionFwVPrev=0)},MPEG1.prototype.copyMacroblock=function(motionH,motionV,sY,sCr,sCb){var x,y1,y2,y,cr1,cr2,cr,cb1,cb2,cb,dY=this.currentY32,dCb=this.currentCb32,dCr=this.currentCr32,width=this.codedWidth,scan=width-16,H=motionH>>1,V=motionV>>1,oddH=1==(1&motionH),oddV=1==(1&motionV),src=((this.mbRow<<4)+V)*width+(this.mbCol<<4)+H,dest=this.mbRow*width+this.mbCol<<2,last=dest+(width<<2);if(oddH)if(oddV)for(;dest<last;){for(y1=sY[src]+sY[src+width],src++,x=0;x<4;x++)y=y1+(y2=sY[src]+sY[src+width])+2>>2&255,y=(y|=(y1=sY[++src]+sY[src+width])+y2+2<<6&65280)|y1+(y2=sY[++src]+sY[src+width])+2<<14&16711680,y1=sY[++src]+sY[src+width],src++,y|=y1+y2+2<<22&4278190080,dY[dest++]=y;dest+=scan>>2,src+=scan-1}else for(;dest<last;){for(y1=sY[src++],x=0;x<4;x++)y=y1+(y2=sY[src++])+1>>1&255,y=(y=(y|=(y1=sY[src++])+y2+1<<7&65280)|y1+(y2=sY[src++])+1<<15&16711680)|(y1=sY[src++])+y2+1<<23&4278190080,dY[dest++]=y;dest+=scan>>2,src+=scan-1}else if(oddV)for(;dest<last;){for(x=0;x<4;x++)y=sY[src]+sY[src+width]+1>>1&255,y=(y|=sY[++src]+sY[src+width]+1<<7&65280)|sY[++src]+sY[src+width]+1<<15&16711680|sY[++src]+sY[src+width]+1<<23&4278190080,src++,dY[dest++]=y;dest+=scan>>2,src+=scan}else for(;dest<last;){for(x=0;x<4;x++)y=sY[src],y=(y|=sY[++src]<<8)|sY[++src]<<16|sY[++src]<<24,src++,dY[dest++]=y;dest+=scan>>2,src+=scan}if(scan=(width=this.halfWidth)-8,oddV=1==(motionV/2&1),src=((this.mbRow<<3)+(motionV/2>>1))*width+(this.mbCol<<3)+(motionH/2>>1),last=(dest=this.mbRow*width+this.mbCol<<1)+(width<<1),1==(motionH/2&1))if(oddV)for(;dest<last;){for(cr1=sCr[src]+sCr[src+width],cb1=sCb[src]+sCb[src+width],src++,x=0;x<2;x++)cr=cr1+(cr2=sCr[src]+sCr[src+width])+2>>2&255,cb=cb1+(cb2=sCb[src]+sCb[src+width])+2>>2&255,cb|=(cb1=sCb[++src]+sCb[src+width])+cb2+2<<6&65280,cr=(cr|=(cr1=sCr[src]+sCr[src+width])+cr2+2<<6&65280)|cr1+(cr2=sCr[++src]+sCr[src+width])+2<<14&16711680,cb|=cb1+(cb2=sCb[src]+sCb[src+width])+2<<14&16711680,cr1=sCr[++src]+sCr[src+width],cb1=sCb[src]+sCb[src+width],src++,cr|=cr1+cr2+2<<22&4278190080,cb|=cb1+cb2+2<<22&4278190080,dCr[dest]=cr,dCb[dest]=cb,dest++;dest+=scan>>2,src+=scan-1}else for(;dest<last;){for(cr1=sCr[src],cb1=sCb[src],src++,x=0;x<2;x++)cr=cr1+(cr2=sCr[src])+1>>1&255,cb=cb1+(cb2=sCb[src++])+1>>1&255,cr1=sCr[src],cb1=sCb[src++],cr|=cr1+cr2+1<<7&65280,cr2=sCr[src],cb=(cb|=cb1+cb2+1<<7&65280)|cb1+(cb2=sCb[src++])+1<<15&16711680,cr=(cr|=cr1+cr2+1<<15&16711680)|(cr1=sCr[src])+cr2+1<<23&4278190080,cb|=(cb1=sCb[src++])+cb2+1<<23&4278190080,dCr[dest]=cr,dCb[dest]=cb,dest++;dest+=scan>>2,src+=scan-1}else if(oddV)for(;dest<last;){for(x=0;x<2;x++)cr=sCr[src]+sCr[src+width]+1>>1&255,cb=sCb[src]+sCb[src+width]+1>>1&255,cr|=sCr[++src]+sCr[src+width]+1<<7&65280,cb=cb|sCb[src]+sCb[src+width]+1<<7&65280|sCb[++src]+sCb[src+width]+1<<15&16711680,cr=cr|sCr[src]+sCr[src+width]+1<<15&16711680|sCr[++src]+sCr[src+width]+1<<23&4278190080,cb|=sCb[src]+sCb[src+width]+1<<23&4278190080,src++,dCr[dest]=cr,dCb[dest]=cb,dest++;dest+=scan>>2,src+=scan}else for(;dest<last;){for(x=0;x<2;x++)cr=sCr[src],cb=sCb[src],cr|=sCr[++src]<<8,cb=cb|sCb[src]<<8|sCb[++src]<<16,cr=cr|sCr[src]<<16|sCr[++src]<<24,cb|=sCb[src]<<24,src++,dCr[dest]=cr,dCb[dest]=cb,dest++;dest+=scan>>2,src+=scan}},MPEG1.prototype.dcPredictorY=0,MPEG1.prototype.dcPredictorCr=0,MPEG1.prototype.dcPredictorCb=0,MPEG1.prototype.blockData=null,MPEG1.prototype.decodeBlock=function(block){for(var quantMatrix,predictor,differential,dctSize,destArray,destIndex,scan,n=0,level=(this.macroblockIntra?(0<(dctSize=block<4?(predictor=this.dcPredictorY,this.readHuffman(MPEG1.DCT_DC_SIZE_LUMINANCE)):(predictor=4===block?this.dcPredictorCr:this.dcPredictorCb,this.readHuffman(MPEG1.DCT_DC_SIZE_CHROMINANCE)))?(differential=this.bits.read(dctSize),this.blockData[0]=0!=(differential&1<<dctSize-1)?predictor+differential:predictor+(-1<<dctSize|differential+1)):this.blockData[0]=predictor,block<4?this.dcPredictorY=this.blockData[0]:4===block?this.dcPredictorCr=this.blockData[0]:this.dcPredictorCb=this.blockData[0],this.blockData[0]<<=8,quantMatrix=this.intraQuantMatrix,n=1):quantMatrix=this.nonIntraQuantMatrix,0);;){var run=0,coeff=this.readHuffman(MPEG1.DCT_COEFF);if(1===coeff&&0<n&&0===this.bits.read(1))break;65535===coeff?(run=this.bits.read(6),0===(level=this.bits.read(8))?level=this.bits.read(8):128===level?level=this.bits.read(8)-256:128<level&&(level-=256)):(run=coeff>>8,level=255&coeff,this.bits.read(1)&&(level=-level));coeff=MPEG1.ZIG_ZAG[n+=run];n++,level<<=1,this.macroblockIntra||(level+=level<0?-1:1),0==(1&(level=level*this.quantizerScale*quantMatrix[coeff]>>4))&&(level-=0<level?1:-1),2047<level?level=2047:level<-2048&&(level=-2048),this.blockData[coeff]=level*MPEG1.PREMULTIPLIER_MATRIX[coeff]}block<4?(destArray=this.currentY,scan=this.codedWidth-8,destIndex=this.mbRow*this.codedWidth+this.mbCol<<4,0!=(1&block)&&(destIndex+=8),0!=(2&block)&&(destIndex+=this.codedWidth<<3)):(destArray=4===block?this.currentCb:this.currentCr,scan=(this.codedWidth>>1)-8,destIndex=(this.mbRow*this.codedWidth<<2)+(this.mbCol<<3)),this.macroblockIntra?1===n?(MPEG1.CopyValueToDestination(this.blockData[0]+128>>8,destArray,destIndex,scan),this.blockData[0]=0):(MPEG1.IDCT(this.blockData),MPEG1.CopyBlockToDestination(this.blockData,destArray,destIndex,scan),JSMpeg.Fill(this.blockData,0)):1===n?(MPEG1.AddValueToDestination(this.blockData[0]+128>>8,destArray,destIndex,scan),this.blockData[0]=0):(MPEG1.IDCT(this.blockData),MPEG1.AddBlockToDestination(this.blockData,destArray,destIndex,scan),JSMpeg.Fill(this.blockData,0))},MPEG1.CopyBlockToDestination=function(block,dest,index,scan){for(var n=0;n<64;n+=8,index+=scan+8)dest[index+0]=block[n+0],dest[index+1]=block[n+1],dest[index+2]=block[n+2],dest[index+3]=block[n+3],dest[index+4]=block[n+4],dest[index+5]=block[n+5],dest[index+6]=block[n+6],dest[index+7]=block[n+7]},MPEG1.AddBlockToDestination=function(block,dest,index,scan){for(var n=0;n<64;n+=8,index+=scan+8)dest[index+0]+=block[n+0],dest[index+1]+=block[n+1],dest[index+2]+=block[n+2],dest[index+3]+=block[n+3],dest[index+4]+=block[n+4],dest[index+5]+=block[n+5],dest[index+6]+=block[n+6],dest[index+7]+=block[n+7]},MPEG1.CopyValueToDestination=function(value,dest,index,scan){for(var n=0;n<64;n+=8,index+=scan+8)dest[index+0]=value,dest[index+1]=value,dest[index+2]=value,dest[index+3]=value,dest[index+4]=value,dest[index+5]=value,dest[index+6]=value,dest[index+7]=value},MPEG1.AddValueToDestination=function(value,dest,index,scan){for(var n=0;n<64;n+=8,index+=scan+8)dest[index+0]+=value,dest[index+1]+=value,dest[index+2]+=value,dest[index+3]+=value,dest[index+4]+=value,dest[index+5]+=value,dest[index+6]+=value,dest[index+7]+=value},MPEG1.IDCT=function(block){for(var b1,b3,b4,b6,b7,tmp1,tmp2,m0,x0,x1,x2,x3,x4,y3,y4,y5,y6,y7,i=0;i<8;++i)b1=block[32+i],y3=(x1=(m0=block[0+i])-b1)+(x2=(362*(block[16+i]-block[48+i])+128>>8)-(b3=block[16+i]+block[48+i])),y5=x1-x2,y6=(x3=m0+b1)-b3,y7=-(x0=(x4=(473*(b6=block[8+i]-block[56+i])-196*(b4=block[40+i]-block[24+i])+128>>8)-(b7=(tmp1=block[8+i]+block[56+i])+(tmp2=block[24+i]+block[40+i])))-(362*(tmp1-tmp2)+128>>8))-(473*b4+196*b6+128>>8),block[0+i]=b7+(y4=x3+b3),block[8+i]=x4+y3,block[16+i]=y5-x0,block[24+i]=y6-y7,block[32+i]=y6+y7,block[40+i]=x0+y5,block[48+i]=y3-x4,block[56+i]=y4-b7;for(i=0;i<64;i+=8)b1=block[4+i],y3=(x1=(m0=block[0+i])-b1)+(x2=(362*(block[2+i]-block[6+i])+128>>8)-(b3=block[2+i]+block[6+i])),y5=x1-x2,y6=(x3=m0+b1)-b3,y7=-(x0=(x4=(473*(b6=block[1+i]-block[7+i])-196*(b4=block[5+i]-block[3+i])+128>>8)-(b7=(tmp1=block[1+i]+block[7+i])+(tmp2=block[3+i]+block[5+i])))-(362*(tmp1-tmp2)+128>>8))-(473*b4+196*b6+128>>8),block[0+i]=b7+(y4=x3+b3)+128>>8,block[1+i]=x4+y3+128>>8,block[2+i]=y5-x0+128>>8,block[3+i]=y6-y7+128>>8,block[4+i]=y6+y7+128>>8,block[5+i]=x0+y5+128>>8,block[6+i]=y3-x4+128>>8,block[7+i]=y4-b7+128>>8},MPEG1.PICTURE_RATE=[0,23.976,24,25,29.97,30,50,59.94,60,0,0,0,0,0,0,0],MPEG1.ZIG_ZAG=new Uint8Array([0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63]),MPEG1.DEFAULT_INTRA_QUANT_MATRIX=new Uint8Array([8,16,19,22,26,27,29,34,16,16,22,24,27,29,34,37,19,22,26,27,29,34,34,38,22,22,26,27,29,34,37,40,22,26,27,29,32,35,40,48,26,27,29,32,35,40,48,58,26,27,29,34,38,46,56,69,27,29,35,38,46,56,69,83]),MPEG1.DEFAULT_NON_INTRA_QUANT_MATRIX=new Uint8Array([16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]),MPEG1.PREMULTIPLIER_MATRIX=new Uint8Array([32,44,42,38,32,25,17,9,44,62,58,52,44,35,24,12,42,58,55,49,42,33,23,12,38,52,49,44,38,30,20,10,32,44,42,38,32,25,17,9,25,35,33,30,25,20,14,7,17,24,23,20,17,14,9,5,9,12,12,10,9,7,5,2]),MPEG1.MACROBLOCK_ADDRESS_INCREMENT=new Int16Array([3,6,0,9,12,0,0,0,1,15,18,0,21,24,0,27,30,0,33,36,0,0,0,3,0,0,2,39,42,0,45,48,0,0,0,5,0,0,4,51,54,0,57,60,0,0,0,7,0,0,6,63,66,0,69,72,0,75,78,0,81,84,0,-1,87,0,-1,90,0,93,96,0,99,102,0,105,108,0,111,114,0,0,0,9,0,0,8,117,120,0,123,126,0,129,132,0,135,138,0,0,0,15,0,0,14,0,0,13,0,0,12,0,0,11,0,0,10,141,-1,0,-1,144,0,147,150,0,153,156,0,159,162,0,165,168,0,171,174,0,177,180,0,183,-1,0,-1,186,0,189,192,0,195,198,0,201,204,0,207,210,0,213,216,0,219,222,0,0,0,21,0,0,20,0,0,19,0,0,18,0,0,17,0,0,16,0,0,35,0,0,34,0,0,33,0,0,32,0,0,31,0,0,30,0,0,29,0,0,28,0,0,27,0,0,26,0,0,25,0,0,24,0,0,23,0,0,22]),MPEG1.MACROBLOCK_TYPE_INTRA=new Int8Array([3,6,0,-1,9,0,0,0,1,0,0,17]),MPEG1.MACROBLOCK_TYPE_PREDICTIVE=new Int8Array([3,6,0,9,12,0,0,0,10,15,18,0,0,0,2,21,24,0,0,0,8,27,30,0,33,36,0,-1,39,0,0,0,18,0,0,26,0,0,1,0,0,17]),MPEG1.MACROBLOCK_TYPE_B=new Int8Array([3,6,0,9,15,0,12,18,0,24,21,0,0,0,12,27,30,0,0,0,14,39,42,0,36,33,0,0,0,4,0,0,6,54,48,0,45,51,0,0,0,8,0,0,10,-1,57,0,0,0,1,60,63,0,0,0,30,0,0,17,0,0,22,0,0,26]),MPEG1.MACROBLOCK_TYPE=[null,MPEG1.MACROBLOCK_TYPE_INTRA,MPEG1.MACROBLOCK_TYPE_PREDICTIVE,MPEG1.MACROBLOCK_TYPE_B],MPEG1.CODE_BLOCK_PATTERN=new Int16Array([6,3,0,9,18,0,12,15,0,24,33,0,36,39,0,27,21,0,30,42,0,60,57,0,54,48,0,69,51,0,81,75,0,63,84,0,45,66,0,72,78,0,0,0,60,105,120,0,132,144,0,114,108,0,126,141,0,87,93,0,117,96,0,0,0,32,135,138,0,99,123,0,129,102,0,0,0,4,90,111,0,0,0,8,0,0,16,0,0,44,150,168,0,0,0,28,0,0,52,0,0,62,183,177,0,156,180,0,0,0,1,165,162,0,0,0,61,0,0,56,171,174,0,0,0,2,0,0,40,153,186,0,0,0,48,192,189,0,147,159,0,0,0,20,0,0,12,240,249,0,0,0,63,231,225,0,195,219,0,252,198,0,0,0,24,0,0,36,0,0,3,207,261,0,243,237,0,204,213,0,210,234,0,201,228,0,216,222,0,258,255,0,264,246,0,-1,282,0,285,291,0,0,0,33,0,0,9,318,330,0,306,348,0,0,0,5,0,0,10,279,267,0,0,0,6,0,0,18,0,0,17,0,0,34,339,357,0,309,312,0,270,276,0,327,321,0,351,354,0,303,297,0,294,288,0,300,273,0,342,345,0,315,324,0,336,333,0,363,375,0,0,0,41,0,0,14,0,0,21,372,366,0,360,369,0,0,0,11,0,0,19,0,0,7,0,0,35,0,0,13,0,0,50,0,0,49,0,0,58,0,0,37,0,0,25,0,0,45,0,0,57,0,0,26,0,0,29,0,0,38,0,0,53,0,0,23,0,0,43,0,0,46,0,0,42,0,0,22,0,0,54,0,0,51,0,0,15,0,0,30,0,0,39,0,0,47,0,0,55,0,0,27,0,0,59,0,0,31]),MPEG1.MOTION=new Int16Array([3,6,0,12,9,0,0,0,0,18,15,0,24,21,0,0,0,-1,0,0,1,27,30,0,36,33,0,0,0,2,0,0,-2,42,45,0,48,39,0,60,54,0,0,0,3,0,0,-3,51,57,0,-1,69,0,81,75,0,78,63,0,72,66,0,96,84,0,87,93,0,-1,99,0,108,105,0,0,0,-4,90,102,0,0,0,4,0,0,-7,0,0,5,111,123,0,0,0,-5,0,0,7,114,120,0,126,117,0,0,0,-6,0,0,6,153,162,0,150,147,0,135,138,0,156,141,0,129,159,0,132,144,0,0,0,10,0,0,9,0,0,8,0,0,-8,171,198,0,0,0,-9,180,192,0,168,183,0,165,186,0,174,189,0,0,0,-10,177,195,0,0,0,12,0,0,16,0,0,13,0,0,14,0,0,11,0,0,15,0,0,-16,0,0,-12,0,0,-14,0,0,-15,0,0,-11,0,0,-13]),MPEG1.DCT_DC_SIZE_LUMINANCE=new Int8Array([6,3,0,18,15,0,9,12,0,0,0,1,0,0,2,27,24,0,21,30,0,0,0,0,36,33,0,0,0,4,0,0,3,39,42,0,0,0,5,0,0,6,48,45,0,51,-1,0,0,0,7,0,0,8]),MPEG1.DCT_DC_SIZE_CHROMINANCE=new Int8Array([6,3,0,12,9,0,18,15,0,24,21,0,0,0,2,0,0,1,0,0,0,30,27,0,0,0,3,36,33,0,0,0,4,42,39,0,0,0,5,48,45,0,0,0,6,51,-1,0,0,0,7,0,0,8]),MPEG1.DCT_COEFF=new Int32Array([3,6,0,12,9,0,0,0,1,21,24,0,18,15,0,39,27,0,33,30,0,42,36,0,0,0,257,60,66,0,54,63,0,48,57,0,0,0,513,51,45,0,0,0,2,0,0,3,81,75,0,87,93,0,72,78,0,96,90,0,0,0,1025,69,84,0,0,0,769,0,0,258,0,0,1793,0,0,65535,0,0,1537,111,108,0,0,0,1281,105,102,0,117,114,0,99,126,0,120,123,0,156,150,0,162,159,0,144,147,0,129,135,0,138,132,0,0,0,2049,0,0,4,0,0,514,0,0,2305,153,141,0,165,171,0,180,168,0,177,174,0,183,186,0,0,0,2561,0,0,3329,0,0,6,0,0,259,0,0,5,0,0,770,0,0,2817,0,0,3073,228,225,0,201,210,0,219,213,0,234,222,0,216,231,0,207,192,0,204,189,0,198,195,0,243,261,0,273,240,0,246,237,0,249,258,0,279,276,0,252,255,0,270,282,0,264,267,0,0,0,515,0,0,260,0,0,7,0,0,1026,0,0,1282,0,0,4097,0,0,3841,0,0,3585,315,321,0,333,342,0,312,291,0,375,357,0,288,294,0,-1,369,0,285,303,0,318,363,0,297,306,0,339,309,0,336,348,0,330,300,0,372,345,0,351,366,0,327,354,0,360,324,0,381,408,0,417,420,0,390,378,0,435,438,0,384,387,0,0,0,2050,396,402,0,465,462,0,0,0,8,411,399,0,429,432,0,453,414,0,426,423,0,0,0,10,0,0,9,0,0,11,0,0,5377,0,0,1538,0,0,771,0,0,5121,0,0,1794,0,0,4353,0,0,4609,0,0,4865,444,456,0,0,0,1027,459,450,0,0,0,261,393,405,0,0,0,516,447,441,0,516,519,0,486,474,0,510,483,0,504,498,0,471,537,0,507,501,0,522,513,0,534,531,0,468,477,0,492,495,0,549,546,0,525,528,0,0,0,263,0,0,2562,0,0,2306,0,0,5633,0,0,5889,0,0,6401,0,0,6145,0,0,1283,0,0,772,0,0,13,0,0,12,0,0,14,0,0,15,0,0,517,0,0,6657,0,0,262,540,543,0,480,489,0,588,597,0,0,0,27,609,555,0,606,603,0,0,0,19,0,0,22,591,621,0,0,0,18,573,576,0,564,570,0,0,0,20,552,582,0,0,0,21,558,579,0,0,0,23,612,594,0,0,0,25,0,0,24,600,615,0,0,0,31,0,0,30,0,0,28,0,0,29,0,0,26,0,0,17,0,0,16,567,618,0,561,585,0,654,633,0,0,0,37,645,648,0,0,0,36,630,636,0,0,0,34,639,627,0,663,666,0,657,624,0,651,642,0,669,660,0,0,0,35,0,0,267,0,0,40,0,0,268,0,0,266,0,0,32,0,0,264,0,0,265,0,0,38,0,0,269,0,0,270,0,0,33,0,0,39,0,0,7937,0,0,6913,0,0,7681,0,0,4098,0,0,7425,0,0,7169,0,0,271,0,0,274,0,0,273,0,0,272,0,0,1539,0,0,2818,0,0,3586,0,0,3330,0,0,3074,0,0,3842]),MPEG1.PICTURE_TYPE={INTRA:1,PREDICTIVE:2,B:3},MPEG1.START={SEQUENCE:179,SLICE_FIRST:1,SLICE_LAST:175,PICTURE:0,EXTENSION:181,USER_DATA:178},MPEG1})(),JSMpeg.Decoder.MP2Audio=(()=>{function MP2(options){JSMpeg.Decoder.Base.call(this,options);var bufferSize=options.audioBufferSize||131072,options=options.streaming?JSMpeg.BitBuffer.MODE.EVICT:JSMpeg.BitBuffer.MODE.EXPAND;this.bits=new JSMpeg.BitBuffer(bufferSize,options),this.left=new Float32Array(1152),this.right=new Float32Array(1152),this.sampleRate=44100,this.D=new Float32Array(1024),this.D.set(MP2.SYNTHESIS_WINDOW,0),this.D.set(MP2.SYNTHESIS_WINDOW,512),this.V=new Float32Array(1024),this.U=new Int32Array(32),this.VPos=0,this.allocation=[new Array(32),new Array(32)],this.scaleFactorInfo=[new Uint8Array(32),new Uint8Array(32)],this.scaleFactor=[new Array(32),new Array(32)],this.sample=[new Array(32),new Array(32)];for(var j=0;j<2;j++)for(var i=0;i<32;i++)this.scaleFactor[j][i]=[0,0,0],this.sample[j][i]=[0,0,0]}return((MP2.prototype=Object.create(JSMpeg.Decoder.Base.prototype)).constructor=MP2).prototype.decode=function(){var decoded,pos=this.bits.index>>3;return!(pos>=this.bits.byteLength||(decoded=this.decodeFrame(this.left,this.right),this.bits.index=pos+decoded<<3,!decoded)||(this.destination&&this.destination.play(this.sampleRate,this.left,this.right),this.advanceDecodedTime(this.left.length/this.sampleRate),0))},MP2.prototype.getCurrentTime=function(){var enqueuedTime=this.destination?this.destination.enqueuedTime:0;return this.decodedTime-enqueuedTime},MP2.prototype.decodeFrame=function(left,right){var sync=this.bits.read(11),version=this.bits.read(2),layer=this.bits.read(2),hasCRC=!this.bits.read(1);if(sync!==MP2.FRAME_SYNC||version!==MP2.VERSION.MPEG_1||layer!==MP2.LAYER.II)return 0;sync=this.bits.read(4)-1;if(13<sync)return 0;layer=this.bits.read(2);MP2.SAMPLE_RATE[layer];if(3===layer)return 0;version===MP2.VERSION.MPEG_2&&(layer+=4,sync+=14);var padding=this.bits.read(1),mode=(this.bits.read(1),this.bits.read(2)),bound=0,bound=mode===MP2.MODE.JOINT_STEREO?this.bits.read(2)+1<<2:(this.bits.skip(2),mode===MP2.MODE.MONO?0:32);this.bits.skip(4),hasCRC&&this.bits.skip(16);var padding=144e3*MP2.BIT_RATE[sync]/(hasCRC=MP2.SAMPLE_RATE[layer])+padding|0,tab3=0,sblimit=0;version===MP2.VERSION.MPEG_2?(tab3=2,sblimit=30):(version=mode===MP2.MODE.MONO?0:1,version=MP2.QUANT_LUT_STEP_1[version][sync],sblimit=63&(tab3=MP2.QUANT_LUT_STEP_2[version][layer]),tab3>>=6),sblimit<bound&&(bound=sblimit);for(var sb=0;sb<bound;sb++)this.allocation[0][sb]=this.readAllocation(sb,tab3),this.allocation[1][sb]=this.readAllocation(sb,tab3);for(sb=bound;sb<sblimit;sb++)this.allocation[0][sb]=this.allocation[1][sb]=this.readAllocation(sb,tab3);for(var channels=mode===MP2.MODE.MONO?1:2,sb=0;sb<sblimit;sb++){for(ch=0;ch<channels;ch++)this.allocation[ch][sb]&&(this.scaleFactorInfo[ch][sb]=this.bits.read(2));mode===MP2.MODE.MONO&&(this.scaleFactorInfo[1][sb]=this.scaleFactorInfo[0][sb])}for(sb=0;sb<sblimit;sb++){for(var ch=0;ch<channels;ch++)if(this.allocation[ch][sb]){var sf=this.scaleFactor[ch][sb];switch(this.scaleFactorInfo[ch][sb]){case 0:sf[0]=this.bits.read(6),sf[1]=this.bits.read(6),sf[2]=this.bits.read(6);break;case 1:sf[0]=sf[1]=this.bits.read(6),sf[2]=this.bits.read(6);break;case 2:sf[0]=sf[1]=sf[2]=this.bits.read(6);break;case 3:sf[0]=this.bits.read(6),sf[1]=sf[2]=this.bits.read(6)}}mode===MP2.MODE.MONO&&(this.scaleFactor[1][sb][0]=this.scaleFactor[0][sb][0],this.scaleFactor[1][sb][1]=this.scaleFactor[0][sb][1],this.scaleFactor[1][sb][2]=this.scaleFactor[0][sb][2])}for(var outPos=0,part=0;part<3;part++)for(var granule=0;granule<4;granule++){for(sb=0;sb<bound;sb++)this.readSamples(0,sb,part),this.readSamples(1,sb,part);for(sb=bound;sb<sblimit;sb++)this.readSamples(0,sb,part),this.sample[1][sb][0]=this.sample[0][sb][0],this.sample[1][sb][1]=this.sample[0][sb][1],this.sample[1][sb][2]=this.sample[0][sb][2];for(sb=sblimit;sb<32;sb++)this.sample[0][sb][0]=0,this.sample[0][sb][1]=0,this.sample[0][sb][2]=0,this.sample[1][sb][0]=0,this.sample[1][sb][1]=0,this.sample[1][sb][2]=0;for(var p=0;p<3;p++){this.VPos=this.VPos-64&1023;for(ch=0;ch<2;ch++){MP2.MatrixTransform(this.sample[ch],p,this.V,this.VPos),JSMpeg.Fill(this.U,0);for(var dIndex=512-(this.VPos>>1),vIndex=this.VPos%128>>1;vIndex<1024;){for(var i=0;i<32;++i)this.U[i]+=this.D[dIndex++]*this.V[vIndex++];vIndex+=96,dIndex+=32}for(vIndex=1120-vIndex,dIndex-=480;vIndex<1024;){for(i=0;i<32;++i)this.U[i]+=this.D[dIndex++]*this.V[vIndex++];vIndex+=96,dIndex+=32}for(var outChannel=0===ch?left:right,j=0;j<32;j++)outChannel[outPos+j]=this.U[j]/2147418112}outPos+=32}}return this.sampleRate=hasCRC,padding},MP2.prototype.readAllocation=function(sb,tab3){tab3=MP2.QUANT_LUT_STEP_3[tab3][sb],sb=MP2.QUANT_LUT_STEP4[15&tab3][this.bits.read(tab3>>4)];return sb?MP2.QUANT_TAB[sb-1]:0},MP2.prototype.readSamples=function(ch,sb,part){var shift,q=this.allocation[ch][sb],part=this.scaleFactor[ch][sb][part],ch=this.sample[ch][sb],sb=0;q?(part=63===part?0:MP2.SCALEFACTOR_BASE[part%3]+(1<<(shift=part/3|0)>>1)>>shift,shift=q.levels,q.group?(sb=this.bits.read(q.bits),ch[0]=sb%shift,ch[1]=(sb=sb/shift|0)%shift,ch[2]=sb/shift|0):(ch[0]=this.bits.read(q.bits),ch[1]=this.bits.read(q.bits),ch[2]=this.bits.read(q.bits)),q=65536/(shift+1)|0,sb=((shift=(shift+1>>1)-1)-ch[0])*q,ch[0]=sb*(part>>12)+(sb*(4095&part)+2048>>12)>>12,ch[1]=(sb=(shift-ch[1])*q)*(part>>12)+(sb*(4095&part)+2048>>12)>>12,ch[2]=(sb=(shift-ch[2])*q)*(part>>12)+(sb*(4095&part)+2048>>12)>>12):ch[0]=ch[1]=ch[2]=0},MP2.MatrixTransform=function(s,ss,d,dp){var t01=s[0][ss]+s[31][ss],t02=.500602998235*(s[0][ss]-s[31][ss]),t03=s[1][ss]+s[30][ss],t04=.505470959898*(s[1][ss]-s[30][ss]),t05=s[2][ss]+s[29][ss],t06=.515447309923*(s[2][ss]-s[29][ss]),t07=s[3][ss]+s[28][ss],t08=.53104259109*(s[3][ss]-s[28][ss]),t09=s[4][ss]+s[27][ss],t10=.553103896034*(s[4][ss]-s[27][ss]),t11=s[5][ss]+s[26][ss],t12=.582934968206*(s[5][ss]-s[26][ss]),t13=s[6][ss]+s[25][ss],t14=.622504123036*(s[6][ss]-s[25][ss]),t15=s[7][ss]+s[24][ss],t16=.674808341455*(s[7][ss]-s[24][ss]),t17=s[8][ss]+s[23][ss],t18=.744536271002*(s[8][ss]-s[23][ss]),t19=s[9][ss]+s[22][ss],t20=.839349645416*(s[9][ss]-s[22][ss]),t21=s[10][ss]+s[21][ss],t22=.972568237862*(s[10][ss]-s[21][ss]),t23=s[11][ss]+s[20][ss],t24=1.16943993343*(s[11][ss]-s[20][ss]),t25=s[12][ss]+s[19][ss],t26=1.48416461631*(s[12][ss]-s[19][ss]),t27=s[13][ss]+s[18][ss],t28=2.05778100995*(s[13][ss]-s[18][ss]),t29=s[14][ss]+s[17][ss],t30=3.40760841847*(s[14][ss]-s[17][ss]),t31=s[15][ss]+s[16][ss],s=10.1900081235*(s[15][ss]-s[16][ss]),ss=t01+t31;t31=.502419286188*(t01-t31),t01=t03+t29,t29=.52249861494*(t03-t29),t03=t05+t27,t27=.566944034816*(t05-t27),t05=t07+t25,t25=.64682178336*(t07-t25),t07=t09+t23,t23=.788154623451*(t09-t23),t09=t11+t21,t21=1.06067768599*(t11-t21),t11=t13+t19,t19=1.72244709824*(t13-t19),t13=t15+t17,t17=5.10114861869*(t15-t17),t15=ss+t13,t13=.509795579104*(ss-t13),ss=t01+t11,t01=.601344886935*(t01-t11),t11=t03+t09,t09=.899976223136*(t03-t09),t03=t05+t07,t07=2.56291544774*(t05-t07),t05=t15+t03,t15=.541196100146*(t15-t03),t03=ss+t11,t11=1.30656296488*(ss-t11),ss=t05+t03,t05=.707106781187*(t05-t03),t03=t15+t11,t03+=t15=.707106781187*(t15-t11),t11=t13+t07,t13=.541196100146*(t13-t07),t07=t01+t09,t09=1.30656296488*(t01-t09),t01=t11+t07,t07=.707106781187*(t11-t07),t11=t13+t09,t01+=t11+=t13=.707106781187*(t13-t09),t11+=t07,t07+=t13,t09=t31+t17,t31=.509795579104*(t31-t17),t17=t29+t19,t29=.601344886935*(t29-t19),t19=t27+t21,t21=.899976223136*(t27-t21),t27=t25+t23,t23=2.56291544774*(t25-t23),t25=t09+t27,t09=.541196100146*(t09-t27),t27=t17+t19,t19=1.30656296488*(t17-t19),t17=t25+t27,t27=.707106781187*(t25-t27),t25=t09+t19,t19=.707106781187*(t09-t19),t09=t31+t23,t31=.541196100146*(t31-t23),t23=t29+t21,t21=1.30656296488*(t29-t21),t29=t09+t23,t23=.707106781187*(t09-t23),t09=t31+t21,t17+=t29+=t09+=t31=.707106781187*(t31-t21),t29+=t25+=t19,t25+=t09+=t23,t09+=t27,t27+=t23+=t31,t23+=t19,t19+=t31,t21=t02+s,t02=.502419286188*(t02-s),s=t04+t30,t04=.52249861494*(t04-t30),t30=t06+t28,t28=.566944034816*(t06-t28),t06=t08+t26,t08=.64682178336*(t08-t26),t26=t10+t24,t10=.788154623451*(t10-t24),t24=t12+t22,t22=1.06067768599*(t12-t22),t12=t14+t20,t20=1.72244709824*(t14-t20),t14=t16+t18,t16=5.10114861869*(t16-t18),t18=t21+t14,t14=.509795579104*(t21-t14),t21=s+t12,s=.601344886935*(s-t12),t12=t30+t24,t24=.899976223136*(t30-t24),t30=t06+t26,t26=2.56291544774*(t06-t26),t06=t18+t30,t18=.541196100146*(t18-t30),t30=t21+t12,t12=1.30656296488*(t21-t12),t21=t06+t30,t30=.707106781187*(t06-t30),t06=t18+t12,t12=.707106781187*(t18-t12),t18=t14+t26,t26=.541196100146*(t14-t26),t14=s+t24,t24=1.30656296488*(s-t24),s=t18+t14,t14=.707106781187*(t18-t14),t18=t26+t24,s+=t18+=t24=.707106781187*(t26-t24),t18+=t14,t26=t14+t24,t14=t02+t16,t02=.509795579104*(t02-t16),t16=t04+t20,t04=.601344886935*(t04-t20),t20=t28+t22,t22=.899976223136*(t28-t22),t28=t08+t10,t10=2.56291544774*(t08-t10),t08=t14+t28,t14=.541196100146*(t14-t28),t28=t16+t20,t20=1.30656296488*(t16-t20),t16=t08+t28,t28=.707106781187*(t08-t28),t08=t14+t20,t20=.707106781187*(t14-t20),t14=t02+t10,t02=.541196100146*(t02-t10),t10=t04+t22,t22=1.30656296488*(t04-t22),t04=t14+t10,t10=.707106781187*(t14-t10),t14=t02+t22,t21+=t16+=t04+=t14+=t02=.707106781187*(t02-t22),t16+=s,s+=t04+=t08+=t20,t04+=t06+=t12,t06+=t08+=t14+=t10,t08+=t18,t18+=t14+=t28,t14+=t30,t30+=t28+=t10+=t02,t28+=t26,t26+=t10+=t20,t10+=t12,t12+=t20+=t02,t20+=t24,t24+=t02,d[dp+48]=-ss,d[dp+49]=d[dp+47]=-t21,d[dp+50]=d[dp+46]=-t17,d[dp+51]=d[dp+45]=-t16,d[dp+52]=d[dp+44]=-t01,d[dp+53]=d[dp+43]=-s,d[dp+54]=d[dp+42]=-t29,d[dp+55]=d[dp+41]=-t04,d[dp+56]=d[dp+40]=-t03,d[dp+57]=d[dp+39]=-t06,d[dp+58]=d[dp+38]=-t25,d[dp+59]=d[dp+37]=-t08,d[dp+60]=d[dp+36]=-t11,d[dp+61]=d[dp+35]=-t18,d[dp+62]=d[dp+34]=-t09,d[dp+63]=d[dp+33]=-t14,d[dp+32]=-t05,d[dp+0]=t05,d[dp+31]=-t30,d[dp+1]=t30,d[dp+30]=-t27,d[dp+2]=t27,d[dp+29]=-t28,d[dp+3]=t28,d[dp+28]=-t07,d[dp+4]=t07,d[dp+27]=-t26,d[dp+5]=t26,d[dp+26]=-t23,d[dp+6]=t23,d[dp+25]=-t10,d[dp+7]=t10,d[dp+24]=-t15,d[dp+8]=t15,d[dp+23]=-t12,d[dp+9]=t12,d[dp+22]=-t19,d[dp+10]=t19,d[dp+21]=-t20,d[dp+11]=t20,d[dp+20]=-t13,d[dp+12]=t13,d[dp+19]=-t24,d[dp+13]=t24,d[dp+18]=-t31,d[dp+14]=t31,d[dp+17]=-t02,d[dp+15]=t02,d[dp+16]=0},MP2.FRAME_SYNC=2047,MP2.VERSION={MPEG_2_5:0,MPEG_2:2,MPEG_1:3},MP2.LAYER={III:1,II:2,I:3},MP2.MODE={STEREO:0,JOINT_STEREO:1,DUAL_CHANNEL:2,MONO:3},MP2.SAMPLE_RATE=new Uint16Array([44100,48e3,32e3,0,22050,24e3,16e3,0]),MP2.BIT_RATE=new Uint16Array([32,48,56,64,80,96,112,128,160,192,224,256,320,384,8,16,24,32,40,48,56,64,80,96,112,128,144,160]),MP2.SCALEFACTOR_BASE=new Uint32Array([33554432,26632170,21137968]),MP2.SYNTHESIS_WINDOW=new Float32Array([0,-.5,-.5,-.5,-.5,-.5,-.5,-1,-1,-1,-1,-1.5,-1.5,-2,-2,-2.5,-2.5,-3,-3.5,-3.5,-4,-4.5,-5,-5.5,-6.5,-7,-8,-8.5,-9.5,-10.5,-12,-13,-14.5,-15.5,-17.5,-19,-20.5,-22.5,-24.5,-26.5,-29,-31.5,-34,-36.5,-39.5,-42.5,-45.5,-48.5,-52,-55.5,-58.5,-62.5,-66,-69.5,-73.5,-77,-80.5,-84.5,-88,-91.5,-95,-98,-101,-104,106.5,109,111,112.5,113.5,114,114,113.5,112,110.5,107.5,104,100,94.5,88.5,81.5,73,63.5,53,41.5,28.5,14.5,-1,-18,-36,-55.5,-76.5,-98.5,-122,-147,-173.5,-200.5,-229.5,-259.5,-290.5,-322.5,-355.5,-389.5,-424,-459.5,-495.5,-532,-568.5,-605,-641.5,-678,-714,-749,-783.5,-817,-849,-879.5,-908.5,-935,-959.5,-981,-1000.5,-1016,-1028.5,-1037.5,-1042.5,-1043.5,-1040,-1031.5,1018.5,1e3,976,946.5,911,869.5,822,767.5,707,640,565.5,485,397,302.5,201,92.5,-22.5,-144,-272.5,-407,-547.5,-694,-846,-1003,-1165,-1331.5,-1502,-1675.5,-1852.5,-2031.5,-2212.5,-2394,-2576.5,-2758.5,-2939.5,-3118.5,-3294.5,-3467.5,-3635.5,-3798.5,-3955,-4104.5,-4245.5,-4377.5,-4499,-4609.5,-4708,-4792.5,-4863.5,-4919,-4958,-4979.5,-4983,-4967.5,-4931.5,-4875,-4796,-4694.5,-4569.5,-4420,-4246,-4046,-3820,-3567,3287,2979.5,2644,2280.5,1888,1467.5,1018.5,541,35,-499,-1061,-1650,-2266.5,-2909,-3577,-4270,-4987.5,-5727.5,-6490,-7274,-8077.5,-8899.5,-9739,-10594.5,-11464.5,-12347,-13241,-14144.5,-15056,-15973.5,-16895.5,-17820,-18744.5,-19668,-20588,-21503,-22410.5,-23308.5,-24195,-25068.5,-25926.5,-26767,-27589,-28389,-29166.5,-29919,-30644.5,-31342,-32009.5,-32645,-33247,-33814.5,-34346,-34839.5,-35295,-35710,-36084.5,-36417.5,-36707.5,-36954,-37156.5,-37315,-37428,-37496,37519,37496,37428,37315,37156.5,36954,36707.5,36417.5,36084.5,35710,35295,34839.5,34346,33814.5,33247,32645,32009.5,31342,30644.5,29919,29166.5,28389,27589,26767,25926.5,25068.5,24195,23308.5,22410.5,21503,20588,19668,18744.5,17820,16895.5,15973.5,15056,14144.5,13241,12347,11464.5,10594.5,9739,8899.5,8077.5,7274,6490,5727.5,4987.5,4270,3577,2909,2266.5,1650,1061,499,-35,-541,-1018.5,-1467.5,-1888,-2280.5,-2644,-2979.5,3287,3567,3820,4046,4246,4420,4569.5,4694.5,4796,4875,4931.5,4967.5,4983,4979.5,4958,4919,4863.5,4792.5,4708,4609.5,4499,4377.5,4245.5,4104.5,3955,3798.5,3635.5,3467.5,3294.5,3118.5,2939.5,2758.5,2576.5,2394,2212.5,2031.5,1852.5,1675.5,1502,1331.5,1165,1003,846,694,547.5,407,272.5,144,22.5,-92.5,-201,-302.5,-397,-485,-565.5,-640,-707,-767.5,-822,-869.5,-911,-946.5,-976,-1e3,1018.5,1031.5,1040,1043.5,1042.5,1037.5,1028.5,1016,1000.5,981,959.5,935,908.5,879.5,849,817,783.5,749,714,678,641.5,605,568.5,532,495.5,459.5,424,389.5,355.5,322.5,290.5,259.5,229.5,200.5,173.5,147,122,98.5,76.5,55.5,36,18,1,-14.5,-28.5,-41.5,-53,-63.5,-73,-81.5,-88.5,-94.5,-100,-104,-107.5,-110.5,-112,-113.5,-114,-114,-113.5,-112.5,-111,-109,106.5,104,101,98,95,91.5,88,84.5,80.5,77,73.5,69.5,66,62.5,58.5,55.5,52,48.5,45.5,42.5,39.5,36.5,34,31.5,29,26.5,24.5,22.5,20.5,19,17.5,15.5,14.5,13,12,10.5,9.5,8.5,8,7,6.5,5.5,5,4.5,4,3.5,3.5,3,2.5,2.5,2,2,1.5,1.5,1,1,1,1,.5,.5,.5,.5,.5,.5]),MP2.QUANT_LUT_STEP_1=[[0,0,1,1,1,2,2,2,2,2,2,2,2,2],[0,0,0,0,0,0,1,1,1,2,2,2,2,2]],MP2.QUANT_LUT_STEP_2=[[(MP2.QUANT_TAB={A:91,B:94,C:8,D:12}).C,MP2.QUANT_TAB.C,MP2.QUANT_TAB.D],[MP2.QUANT_TAB.A,MP2.QUANT_TAB.A,MP2.QUANT_TAB.A],[MP2.QUANT_TAB.B,MP2.QUANT_TAB.A,MP2.QUANT_TAB.B]],MP2.QUANT_LUT_STEP_3=[[68,68,52,52,52,52,52,52,52,52,52,52],[67,67,67,66,66,66,66,66,66,66,66,49,49,49,49,49,49,49,49,49,49,49,49,32,32,32,32,32,32,32],[69,69,69,69,52,52,52,52,52,52,52,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36]],MP2.QUANT_LUT_STEP4=[[0,1,2,17],[0,1,2,3,4,5,6,17],[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,17],[0,1,3,5,6,7,8,9,10,11,12,13,14,15,16,17],[0,1,2,4,5,6,7,8,9,10,11,12,13,14,15,17],[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]],MP2.QUANT_TAB=[{levels:3,group:1,bits:5},{levels:5,group:1,bits:7},{levels:7,group:0,bits:3},{levels:9,group:1,bits:10},{levels:15,group:0,bits:4},{levels:31,group:0,bits:5},{levels:63,group:0,bits:6},{levels:127,group:0,bits:7},{levels:255,group:0,bits:8},{levels:511,group:0,bits:9},{levels:1023,group:0,bits:10},{levels:2047,group:0,bits:11},{levels:4095,group:0,bits:12},{levels:8191,group:0,bits:13},{levels:16383,group:0,bits:14},{levels:32767,group:0,bits:15},{levels:65535,group:0,bits:16}],MP2})(),JSMpeg.Renderer.WebGL=(()=>{function WebGLRenderer(options){if(this.canvas=options.canvas||document.createElement("canvas"),this.width=this.canvas.width,this.height=this.canvas.height,this.enabled=!0,options={preserveDrawingBuffer:!!options.preserveDrawingBuffer,alpha:!1,depth:!1,stencil:!1,antialias:!1},this.gl=this.canvas.getContext("webgl",options)||this.canvas.getContext("experimental-webgl",options),!this.gl)throw new Error("Failed to get WebGL Context");var options=this.gl,vertexCoords=(this.vertexBuffer=options.createBuffer(),new Float32Array([0,0,0,1,1,0,1,1]));options.bindBuffer(options.ARRAY_BUFFER,this.vertexBuffer),options.bufferData(options.ARRAY_BUFFER,vertexCoords,options.STATIC_DRAW),this.program=this.createProgram(WebGLRenderer.SHADER.VERTEX_IDENTITY,WebGLRenderer.SHADER.FRAGMENT_YCRCB_TO_RGBA),vertexCoords=options.getAttribLocation(this.program,"vertex"),options.enableVertexAttribArray(vertexCoords),options.vertexAttribPointer(vertexCoords,2,options.FLOAT,!1,0,0),this.textureY=this.createTexture(0,"textureY"),this.textureCb=this.createTexture(1,"textureCb"),this.textureCr=this.createTexture(2,"textureCr"),this.loadingProgram=this.createProgram(WebGLRenderer.SHADER.VERTEX_IDENTITY,WebGLRenderer.SHADER.FRAGMENT_LOADING),vertexCoords=options.getAttribLocation(this.loadingProgram,"vertex"),options.enableVertexAttribArray(vertexCoords),options.vertexAttribPointer(vertexCoords,2,options.FLOAT,!1,0,0),this.shouldCreateUnclampedViews=!this.allowsClampedTextureData()}return WebGLRenderer.prototype.destroy=function(){var gl=this.gl;gl.deleteTexture(this.textureY),gl.deleteTexture(this.textureCb),gl.deleteTexture(this.textureCr),gl.deleteProgram(this.program),gl.deleteProgram(this.loadingProgram),gl.deleteBuffer(this.vertexBuffer)},WebGLRenderer.prototype.resize=function(width,height){this.width=0|width,this.height=0|height,this.canvas.width=this.width,this.canvas.height=this.height,this.gl.useProgram(this.program),this.gl.viewport(0,0,this.width,this.height)},WebGLRenderer.prototype.createTexture=function(index,name){var gl=this.gl,texture=gl.createTexture();return gl.bindTexture(gl.TEXTURE_2D,texture),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.LINEAR),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.LINEAR),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE),gl.uniform1i(gl.getUniformLocation(this.program,name),index),texture},WebGLRenderer.prototype.createProgram=function(vsh,fsh){var gl=this.gl,program=gl.createProgram();return gl.attachShader(program,this.compileShader(gl.VERTEX_SHADER,vsh)),gl.attachShader(program,this.compileShader(gl.FRAGMENT_SHADER,fsh)),gl.linkProgram(program),gl.useProgram(program),program},WebGLRenderer.prototype.compileShader=function(type,source){var gl=this.gl,type=gl.createShader(type);if(gl.shaderSource(type,source),gl.compileShader(type),gl.getShaderParameter(type,gl.COMPILE_STATUS))return type;throw new Error(gl.getShaderInfoLog(type))},WebGLRenderer.prototype.allowsClampedTextureData=function(){var gl=this.gl,texture=gl.createTexture();return gl.bindTexture(gl.TEXTURE_2D,texture),gl.texImage2D(gl.TEXTURE_2D,0,gl.LUMINANCE,1,1,0,gl.LUMINANCE,gl.UNSIGNED_BYTE,new Uint8ClampedArray([0])),0===gl.getError()},WebGLRenderer.prototype.renderProgress=function(progress){var gl=this.gl,loc=(gl.useProgram(this.loadingProgram),gl.getUniformLocation(this.loadingProgram,"progress"));gl.uniform1f(loc,progress),gl.drawArrays(gl.TRIANGLE_STRIP,0,4)},WebGLRenderer.prototype.render=function(y,cb,cr){var gl,w,h,w2,h2;this.enabled&&(gl=this.gl,w2=(w=this.width+15>>4<<4)>>1,h2=(h=this.height)>>1,this.shouldCreateUnclampedViews&&(y=new Uint8Array(y.buffer),cb=new Uint8Array(cb.buffer),cr=new Uint8Array(cr.buffer)),gl.useProgram(this.program),this.updateTexture(gl.TEXTURE0,this.textureY,w,h,y),this.updateTexture(gl.TEXTURE1,this.textureCb,w2,h2,cb),this.updateTexture(gl.TEXTURE2,this.textureCr,w2,h2,cr),gl.drawArrays(gl.TRIANGLE_STRIP,0,4))},WebGLRenderer.prototype.updateTexture=function(unit,texture,w,h,data){var gl=this.gl;gl.activeTexture(unit),gl.bindTexture(gl.TEXTURE_2D,texture),gl.texImage2D(gl.TEXTURE_2D,0,gl.LUMINANCE,w,h,0,gl.LUMINANCE,gl.UNSIGNED_BYTE,data)},WebGLRenderer.IsSupported=function(){try{var canvas;return window.WebGLRenderingContext?!(!(canvas=document.createElement("canvas")).getContext("webgl")&&!canvas.getContext("experimental-webgl")):!1}catch(err){return!1}},WebGLRenderer.SHADER={FRAGMENT_YCRCB_TO_RGBA:["precision mediump float;","uniform sampler2D textureY;","uniform sampler2D textureCb;","uniform sampler2D textureCr;","varying vec2 texCoord;","mat4 rec601 = mat4(","1.16438,  0.00000,  1.59603, -0.87079,","1.16438, -0.39176, -0.81297,  0.52959,","1.16438,  2.01723,  0.00000, -1.08139,","0, 0, 0, 1",");","void main() {","float y = texture2D(textureY, texCoord).r;","float cb = texture2D(textureCb, texCoord).r;","float cr = texture2D(textureCr, texCoord).r;","gl_FragColor = vec4(y, cr, cb, 1.0) * rec601;","}"].join("\n"),FRAGMENT_LOADING:["precision mediump float;","uniform float progress;","varying vec2 texCoord;","void main() {","float c = ceil(progress-(1.0-texCoord.y));","gl_FragColor = vec4(c,c,c,1);","}"].join("\n"),VERTEX_IDENTITY:["attribute vec2 vertex;","varying vec2 texCoord;","void main() {","texCoord = vertex;","gl_Position = vec4((vertex * 2.0 - 1.0) * vec2(1, -1), 0.0, 1.0);","}"].join("\n")},WebGLRenderer})(),JSMpeg.Renderer.Canvas2D=(()=>{function CanvasRenderer(options){this.canvas=options.canvas||document.createElement("canvas"),this.width=this.canvas.width,this.height=this.canvas.height,this.enabled=!0,this.context=this.canvas.getContext("2d")}return CanvasRenderer.prototype.destroy=function(){},CanvasRenderer.prototype.resize=function(width,height){this.width=0|width,this.height=0|height,this.canvas.width=this.width,this.canvas.height=this.height,this.imageData=this.context.getImageData(0,0,this.width,this.height),JSMpeg.Fill(this.imageData.data,255)},CanvasRenderer.prototype.renderProgress=function(progress){var w=this.canvas.width,h=this.canvas.height,ctx=this.context;ctx.fillStyle="#222",ctx.fillRect(0,0,w,h),ctx.fillStyle="#fff",ctx.fillRect(0,h-h*progress,w,h*progress)},CanvasRenderer.prototype.render=function(y,cb,cr){this.YCbCrToRGBA(y,cb,cr,this.imageData.data),this.context.putImageData(this.imageData,0,0)},CanvasRenderer.prototype.YCbCrToRGBA=function(y,cb,cr,rgba){if(this.enabled)for(var w=this.width+15>>4<<4,yIndex1=0,yIndex2=w,yNext2Lines=w+(w-this.width),cIndex=0,cNextLine=(w>>1)-(this.width>>1),rgbaIndex1=0,rgbaIndex2=4*this.width,rgbaNext2Lines=4*this.width,cols=this.width>>1,rows=this.height>>1,row=0;row<rows;row++){for(var col=0;col<cols;col++){ccb=cb[cIndex],ccr=cr[cIndex],cIndex++;var ccb,g=(88*ccr>>8)-44+(183*ccb>>8)-91,ccr=ccr+(198*ccr>>8)-227,y1=y[yIndex1++],y2=y[yIndex1++],y1=(rgba[rgbaIndex1]=y1+(ccb=ccb+(103*ccb>>8)-179),rgba[rgbaIndex1+1]=y1-g,rgba[rgbaIndex1+2]=y1+ccr,rgba[rgbaIndex1+4]=y2+ccb,rgba[rgbaIndex1+5]=y2-g,rgba[rgbaIndex1+6]=y2+ccr,rgbaIndex1+=8,y[yIndex2++]),y2=y[yIndex2++];rgba[rgbaIndex2]=y1+ccb,rgba[rgbaIndex2+1]=y1-g,rgba[rgbaIndex2+2]=y1+ccr,rgba[rgbaIndex2+4]=y2+ccb,rgba[rgbaIndex2+5]=y2-g,rgba[rgbaIndex2+6]=y2+ccr,rgbaIndex2+=8}yIndex1+=yNext2Lines,yIndex2+=yNext2Lines,rgbaIndex1+=rgbaNext2Lines,rgbaIndex2+=rgbaNext2Lines,cIndex+=cNextLine}},CanvasRenderer})(),JSMpeg.AudioOutput.WebAudio=(()=>{function WebAudioOut(options){this.context=WebAudioOut.CachedContext=WebAudioOut.CachedContext||new(window.AudioContext||window.webkitAudioContext),this.gain=this.context.createGain(),this.destination=this.gain,this.gain.connect(this.context.destination),this.context._connections=(this.context._connections||0)+1,this.startTime=0,this.buffer=null,this.wallclockStartTime=0,this.volume=1,this.enabled=!0,this.unlocked=!WebAudioOut.NeedsUnlocking(),Object.defineProperty(this,"enqueuedTime",{get:this.getEnqueuedTime})}return WebAudioOut.prototype.destroy=function(){this.gain.disconnect(),this.context._connections--,0===this.context._connections&&(this.context.close(),WebAudioOut.CachedContext=null)},WebAudioOut.prototype.play=function(sampleRate,left,right){var now,buffer;this.enabled&&(this.unlocked?(this.gain.gain.value=this.volume,(buffer=this.context.createBuffer(2,left.length,sampleRate)).getChannelData(0).set(left),buffer.getChannelData(1).set(right),(right=this.context.createBufferSource()).buffer=buffer,right.connect(this.destination),now=this.context.currentTime,buffer=buffer.duration,this.startTime<now&&(this.startTime=now,this.wallclockStartTime=JSMpeg.Now()),right.start(this.startTime),this.startTime+=buffer,this.wallclockStartTime+=buffer):(now=JSMpeg.Now(),this.wallclockStartTime<now&&(this.wallclockStartTime=now),this.wallclockStartTime+=left.length/sampleRate))},WebAudioOut.prototype.stop=function(){this.gain.gain.value=0},WebAudioOut.prototype.getEnqueuedTime=function(){return Math.max(this.wallclockStartTime-JSMpeg.Now(),0)},WebAudioOut.prototype.resetEnqueuedTime=function(){this.startTime=this.context.currentTime,this.wallclockStartTime=JSMpeg.Now()},WebAudioOut.prototype.unlock=function(callback){var source;this.unlocked?callback&&callback():(this.unlockCallback=callback,callback=this.context.createBuffer(1,1,22050),(source=this.context.createBufferSource()).buffer=callback,source.connect(this.destination),source.start(0),setTimeout(this.checkIfUnlocked.bind(this,source,0),0))},WebAudioOut.prototype.checkIfUnlocked=function(source,attempt){source.playbackState===source.PLAYING_STATE||source.playbackState===source.FINISHED_STATE?(this.unlocked=!0,this.unlockCallback&&(this.unlockCallback(),this.unlockCallback=null)):attempt<10&&setTimeout(this.checkIfUnlocked.bind(this,source,attempt+1),100)},WebAudioOut.NeedsUnlocking=function(){return/iPhone|iPad|iPod/i.test(navigator.userAgent)},WebAudioOut.IsSupported=function(){return window.AudioContext||window.webkitAudioContext},WebAudioOut.CachedContext=null,WebAudioOut})();