class XpraWebTransportProtocol{constructor(){this.verify_connected_timer=0,this.packet_handler=null,this.webtransport=null,this.stream=null,this.writer=null,this.raw_packets=[],this.rQ=[],this.sQ=[],this.header=[],this.process_interval=0}cancel_connected_timer(){this.verify_connected_timer&&(clearTimeout(this.verify_connected_timer),this.verify_connected_timer=0)}async open(uri){var me=this;function handle(packet){me.packet_handler(packet)}this.raw_packets=[],this.rQ=[],this.sQ=[],this.header=[],this.webtransport=null,this.stream=null,this.verify_connected_timer=setTimeout(()=>handle(["error","connection timed out",0]),CONNECT_TIMEOUT);try{console.log("opening WebTransport connection to "+uri),this.webtransport=new WebTransport(uri)}catch(error){return void handle(["error",""+error,0])}try{console.log("waiting for connection"),await this.webtransport.ready,this.cancel_connected_timer()}catch(e){return console.error("connection failed: "+e),handle(["error",e.toString()]),void this.cancel_connected_timer()}this.webtransport.closed.then(()=>{handle(["close","transport closed"])}).catch(e=>{console.error("error closing WebTransport: "+e),handle(["close","error",e.toString()])}),console.log("creating stream"),this.stream=await this.webtransport.createBidirectionalStream(),console.log("starting read loop with stream="+this.stream),this.read_loop().then(()=>{console.log("read loop ended, closing"),handle(["close","read loop ended"])}).catch(e=>{console.error("error in read loop: "+e),handle(["close","read loop error",e.toString()])}),this.writer=this.stream.writable.getWriter(),handle(["open"]),console.log("async open end")}async read_loop(){for(var reader=this.stream.readable.getReader(),me=this;;){var{value,done}=await reader.read();if(done)break;this.rQ.push(value),setTimeout(()=>me.process_receive_queue(),this.process_interval)}}protocol_error(message){this.packet_handler(["error",message]),console.error("protocol error: "+message),this.close()}close(){this.cancel_connected_timer();var wt=this.webtransport;wt&&wt.closed.then(()=>{console.log("closed WebTransport connection"),handle(["close","WebTransport closed"])}).catch(e=>{console.log("error closing WebTransport connection: "+e),handle(["close","error closing WebTransport connection",e.toString()])}),this.webtransport=null}process_receive_queue(){for(;this.webtransport&&this.do_process_receive_queue(););}do_process_receive_queue(){if(this.header.length<8&&0<this.rQ.length){for(;this.header.length<8&&0<this.rQ.length;){var slice=this.rQ[0],needed=8-this.header.length,n=Math.min(needed,slice.length);this.header.push(...slice.subarray(0,n)),slice.length>needed?this.rQ[0]=slice.subarray(n):this.rQ.shift()}if(80!==this.header[0]){var message="invalid packet header format: "+this.header[0];if(1<this.header.length){var p,hex="";for(p of this.header){var v=p.toString(16);hex+=v.length<2?"0"+v:v}message+=": 0x"+hex}return this.protocol_error(message),!1}}if(this.header.length<8)return!1;message=this.header[1];if(2&message)throw"crypto packets not supported";if(8&message&&(message&=-9),!(1<message&&16!==message)){var level=this.header[2];if(32&level)return this.protocol_error("lzo compression is not supported"),!1;if(20<=(index=this.header[3]))return this.protocol_error("invalid packet index: "+index),!1;var packet_data,inflated,packet_size=[4,5,6,7].reduce((accumulator,value)=>256*accumulator+this.header[value],0),rsize=this.rQ.reduce((accumulator,value)=>accumulator+value.length,0);if(rsize<packet_size)return!1;if(this.header=[],this.rQ[0].length===packet_size)packet_data=this.rQ.shift();else for(packet_data=new Uint8Array(packet_size),rsize=0;rsize<packet_size;){needed=packet_size-rsize;(slice=this.rQ[0]).length>needed?(packet_data.set(slice.subarray(0,needed),rsize),rsize+=needed,this.rQ[0]=slice.subarray(needed)):(packet_data.set(slice,rsize),rsize+=slice.length,this.rQ.shift())}if(0!==level){if(16&level)inflated=lz4.decode(packet_data);else{if(!(64&level))throw"zlib is no longer supported";inflated=new Uint8Array(BrotliDecode(packet_data))}packet_data=inflated}if(0<index){if(this.raw_packets[index]=packet_data,4<=this.raw_packets.length)return this.protocol_error("too many raw packets: "+this.raw_packets.length),!1}else{var packet=null;try{if(16!==message)throw 1===message?"rencode legacy mode is not supported, protocol flag: "+message:"invalid packet encoder flags "+message;for(var index in packet=rdecode(packet_data),this.raw_packets)packet[index]=this.raw_packets[index];this.raw_packets={}}catch(error){return console.error("error decoding packet",error),console.error("packet="+packet_data),console.error("protocol flags="+message),this.raw_packets=[],0<this.rQ.length}try{this.packet_handler(packet)}catch(error){console.error(`error processing packet ${packet[0]}: `+error),console.error(" packet data: "+packet_data)}}return 0<this.rQ.length}this.protocol_error("we can't handle this protocol flag yet: "+message)}process_send_queue(){for(;0<this.sQ.length&&this.webtransport;){var packet=this.sQ.shift();if(!packet)return;var bdata=null;try{bdata=rencode(packet)}catch(error){console.error("Error: failed to encode packet:",packet),console.error(error);continue}var payload_size=bdata.length,packet_data=new Uint8Array(payload_size+8);packet_data[0]="P".charCodeAt(0),packet_data[1]=16,packet_data[2]=0;for(var index=packet_data[3]=0;index<4;index++)packet_data[7-index]=payload_size>>8*index&255;packet_data.set(bdata,8),this.stream&&this.writer.write(new Uint8Array(packet_data).buffer)}}send(packet){this.sQ[this.sQ.length]=packet,setTimeout(()=>this.process_send_queue(),this.process_interval)}set_packet_handler(callback){this.packet_handler=callback}set_cipher_in(caps,key){throw"not supported with WebTransport"}set_cipher_out(caps,key){throw"not supported with WebTransport"}}