/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.store;

import io.xpipe.app.browser.BrowserFullSessionModel;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.hub.comp.OsLogoComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.process.ProcessControl;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.SystemState;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.terminal.TerminalLaunch;
import io.xpipe.app.terminal.TerminalPromptManager;
import io.xpipe.app.util.StoreStateFormat;
import io.xpipe.core.FailableRunnable;
import io.xpipe.ext.base.script.ScriptStoreSetup;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;

public interface ShellStoreProvider
extends DataStoreProvider {
    default public FailableRunnable<Exception> launch(DataStoreEntry entry) {
        return () -> {
            DataStoreEntryRef replacement = ProcessControlProvider.get().replace(entry.ref());
            ShellStore store = (ShellStore)replacement.getStore().asNeeded();
            ShellControl control = store.standaloneControl();
            TerminalPromptManager.configurePromptScript((ShellControl)control);
            ScriptStoreSetup.controlWithDefaultScripts(control);
            TerminalLaunch.builder().entry(replacement.get()).command((ProcessControl)control).launch();
        };
    }

    default public FailableRunnable<Exception> launchBrowser(BrowserFullSessionModel sessionModel, DataStoreEntry store, BooleanProperty busy) {
        return () -> sessionModel.openFileSystemAsync(store.ref(), null, null, busy);
    }

    default public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new OsLogoComp(w, SystemStateComp.State.shellState((StoreEntryWrapper)w));
    }

    default public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.SHELL;
    }

    default public ObservableValue<String> informationString(StoreSection section) {
        return StoreStateFormat.shellStore((StoreSection)section, state -> (String[])this.formatAdditionalInformation(section, (SystemState)state).toArray(String[]::new), null);
    }

    default public List<String> formatAdditionalInformation(StoreSection section, SystemState state) {
        return List.of();
    }
}

