/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreComboChoiceComp;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.platform.BindingsHelper;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.host.AbstractHostStore;
import io.xpipe.ext.base.service.AbstractServiceStore;
import io.xpipe.ext.base.service.AbstractServiceStoreProvider;
import io.xpipe.ext.base.service.CustomServiceStore;
import io.xpipe.ext.base.service.ServiceProtocolType;
import io.xpipe.ext.base.service.ServiceProtocolTypeHelper;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class CustomServiceStoreProvider
extends AbstractServiceStoreProvider {
    @Override
    public DataStoreEntry getSyntheticParent(DataStoreEntry store) {
        CustomServiceStore c = (CustomServiceStore)store.getStore();
        if (c.getHost() == null || c.getHost().getStore() instanceof AbstractHostStore) {
            return null;
        }
        return super.getSyntheticParent(store);
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        CustomServiceStore c = (CustomServiceStore)store.getStore();
        if (c.getHost() != null && c.getHost().getStore() instanceof AbstractHostStore) {
            return c.getHost().get();
        }
        return super.getDisplayParent(store);
    }

    public int getOrderPriority() {
        return -1;
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.SERVICE;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        CustomServiceStore st = (CustomServiceStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty comboHost = new SimpleObjectProperty((Object)StoreComboChoiceComp.ComboValue.of((String)st.getAddress(), st.getHost()));
        SimpleObjectProperty gateway = new SimpleObjectProperty(st.getGateway());
        ObservableValue hideGateway = BindingsHelper.map((ObservableValue)comboHost, c -> c == null || c.getRef() != null);
        SimpleObjectProperty localPort = new SimpleObjectProperty((Object)st.getLocalPort());
        SimpleObjectProperty remotePort = new SimpleObjectProperty((Object)st.getRemotePort());
        SimpleObjectProperty serviceProtocolType = new SimpleObjectProperty((Object)st.getServiceProtocolType());
        StoreComboChoiceComp hostChoice = new StoreComboChoiceComp(hostStore -> {
            String string;
            if (hostStore instanceof AbstractHostStore) {
                AbstractHostStore a = (AbstractHostStore)hostStore;
                string = a.getHostAddress().get();
            } else if (hostStore instanceof NetworkTunnelStore) {
                NetworkTunnelStore t = (NetworkTunnelStore)hostStore;
                string = t.getTunnelHostName();
            } else {
                string = "?";
            }
            return string;
        }, entry, (Property)comboHost, NetworkTunnelStore.class, n -> {
            NetworkTunnelStore t;
            DataStore patt0$temp;
            return n.getStore() instanceof AbstractHostStore || (patt0$temp = n.getStore()) instanceof NetworkTunnelStore && (t = (NetworkTunnelStore)patt0$temp).isLocallyTunnelable();
        }, StoreViewState.get().getAllConnectionsCategory());
        StoreChoiceComp gatewayChoice = new StoreChoiceComp(StoreChoiceComp.Mode.PROXY, entry, (Property)gateway, NetworkTunnelStore.class, ref -> !ref.get().equals((Object)DataStorage.get().local()), StoreViewState.get().getAllConnectionsCategory());
        OptionsBuilder q = new OptionsBuilder().nameAndDescription("serviceHost").addComp((Comp)hostChoice, (Property)comboHost).nonNull().nameAndDescription("gateway").addComp((Comp)gatewayChoice, (Property)gateway).hide(hideGateway).nameAndDescription("serviceRemotePort").addInteger((Property)remotePort).nonNull().sub(ServiceProtocolTypeHelper.choice((Property<ServiceProtocolType>)serviceProtocolType), (Property)serviceProtocolType).nonNull().nameAndDescription("serviceLocalPort").addInteger((Property)localPort).bind(() -> ((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((AbstractServiceStore.AbstractServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)CustomServiceStore.builder().address(comboHost.get() != null ? ((StoreComboChoiceComp.ComboValue)comboHost.get()).getManualHost() : null)).host(comboHost.get() != null ? ((StoreComboChoiceComp.ComboValue)comboHost.get()).getRef() : null)).gateway((DataStoreEntryRef<NetworkTunnelStore>)((DataStoreEntryRef)gateway.get()))).localPort((Integer)localPort.get())).remotePort((Integer)remotePort.get())).serviceProtocolType((ServiceProtocolType)serviceProtocolType.get())).build(), new Property[]{store});
        return q.buildDialog();
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return CustomServiceStore.builder().build();
    }

    public String getId() {
        return "customService";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(CustomServiceStore.class);
    }
}

