/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.ext.base.service.AbstractServiceGroupStore;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;

public abstract class AbstractServiceGroupStoreProvider
implements DataStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.SERVICES;
    }

    public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp((ObservableValue)new SimpleObjectProperty((Object)SystemStateComp.State.SUCCESS));
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.GROUP;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        AbstractServiceGroupStore s = (AbstractServiceGroupStore)store.getStore().asNeeded();
        return s.getParent().get();
    }

    public ObservableValue<String> informationString(StoreSection section) {
        return Bindings.createStringBinding(() -> {
            Integer string;
            ObservableList all = section.getAllChildren().getList();
            ObservableList shown = section.getShownChildren().getList();
            if (shown.size() == 0) {
                return null;
            }
            Integer n = string = all.size() == shown.size() ? Integer.valueOf(all.size()) : shown.size() + "/" + all.size();
            return all.size() > 0 ? (all.size() == 1 ? AppI18n.get((String)"hasService", (Object[])new Object[]{string}) : AppI18n.get((String)"hasServices", (Object[])new Object[]{string})) : AppI18n.get((String)"noServices", (Object[])new Object[0]);
        }, (Observable[])new Observable[]{section.getShownChildren().getList(), section.getAllChildren().getList(), AppI18n.activeLanguage()});
    }

    public String getDisplayIconFileName(DataStore store) {
        return "base:serviceGroup_icon.svg";
    }
}

